/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.powermock.api.mockito.PowerMockito.mockStatic;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.asm.datamgr.DMFactory;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.media.DigitOptions;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.services.CallDeflection.util.ClusterAttributeReader;
import com.avaya.services.CallDeflection.util.ServiceAttributeReader;
import com.avaya.services.CallDeflection.util.TrafficInterfaceAddressRetriever;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;

@RunWith(PowerMockRunner.class)
@PrepareForTest(
{ MediaFactory.class, ServiceAttributeReader.class, ClusterAttributeReader.class, Logger.class, ServiceUtil.class,
        CollaborationDataFactory.class, ServiceDescriptor.class, DMFactory.class })
public final class CallDeflectionMediaOperationsImplTest
{
    @Mock
    private ServiceAttributeReader serviceAttributeReader;
    @Mock
    private ClusterAttributeReader clusterAttributeReader;
    @Mock
    private TrafficInterfaceAddressRetriever trafficInterfaceAddressRetriever;
    @Mock
    private Logger logger;
    @Mock
    private Call call;
    @Mock
    private DigitOptions digitOptions;
    @Mock
    private PlayItem playItem;
    @Mock
    private MediaService mediaService;
    @Mock
    private Participant participant;
    @Mock
    private ServiceData serviceData;
    @Mock
    private ServiceDescriptor serviceDescriptor;
    @Mock
    private DMFactory dMFactory;

    CallDeflectionMediaOperationsImpl callDeflectionOperationsImpl;

    @Before
    public void setupn()
    {
        callDeflectionOperationsImpl = new CallDeflectionMediaOperationsImpl(serviceAttributeReader, trafficInterfaceAddressRetriever,
                logger);
    }

    @Test
    public void executePromptAndCollectOperation() throws NoAttributeFoundException, ServiceNotFoundException
    {
        when(logger.isFinestEnabled()).thenReturn(true);
        mockStatic(MediaFactory.class);
        when(MediaFactory.createDigitOptions()).thenReturn(digitOptions);
        when(MediaFactory.createPlayItem()).thenReturn(playItem);
        when(MediaFactory.createMediaService()).thenReturn(mediaService);
        when(serviceAttributeReader.getAnnouncementSourcePath()).thenReturn("");
        when(clusterAttributeReader.getAnnouncementFileNetworkProtocol()).thenReturn("http");
        when(trafficInterfaceAddressRetriever.getTrafficInterfaceAddress()).thenReturn("1.1.1.1");
        when(call.getCallingParty()).thenReturn(participant);
        mockStatic(ServiceUtil.class);
        when(ServiceUtil.getServiceDescriptor()).thenReturn(serviceDescriptor);
        mockStatic(CollaborationDataFactory.class);
        when(CollaborationDataFactory.getServiceData(null, null)).thenReturn(serviceData);
        mockStatic(DMFactory.class);
        when(DMFactory.getInstance()).thenReturn(dMFactory);
        callDeflectionOperationsImpl.executePromptAndCollectOperation(call, 1);
        verify(mediaService).promptAndCollect(Matchers.eq(participant), Matchers.eq(playItem), Matchers.eq(digitOptions),
                Matchers.any(CallDeflectionMediaListener.class));
    }

    @Test
    public void executePlayOperation() throws NoAttributeFoundException, ServiceNotFoundException
    {
        when(logger.isFinestEnabled()).thenReturn(true);
        mockStatic(MediaFactory.class);
        when(MediaFactory.createPlayItem()).thenReturn(playItem);
        when(MediaFactory.createMediaService()).thenReturn(mediaService);
        when(serviceAttributeReader.getAnnouncementSourcePath()).thenReturn("");
        when(clusterAttributeReader.getAnnouncementFileNetworkProtocol()).thenReturn("http");
        when(trafficInterfaceAddressRetriever.getTrafficInterfaceAddress()).thenReturn("1.1.1.1");
        when(call.getCallingParty()).thenReturn(participant);
        mockStatic(ServiceUtil.class);
        when(ServiceUtil.getServiceDescriptor()).thenReturn(serviceDescriptor);
        mockStatic(CollaborationDataFactory.class);
        when(CollaborationDataFactory.getServiceData(null, null)).thenReturn(serviceData);
        mockStatic(DMFactory.class);
        when(DMFactory.getInstance()).thenReturn(dMFactory);
        callDeflectionOperationsImpl.executePlayOperation(call, 1);
        verify(mediaService).play(Matchers.eq(participant), Matchers.eq(playItem),
                Matchers.any(CallDeflectionMediaListener.class));
    }
}
