/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService.operations;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.PromptsToPlay;
import com.avaya.zephyr.services.sample_services.CallableService.menus.CallableServiceMainMenuMediaListener;
import com.avaya.zephyr.services.sample_services.CallableService.util.CallableServiceUtil;

public final class PlayAnnouncementOperationImpl implements PlayAnnouncementOperation
{
    private final CallableServiceUtil callableServiceUtil;
    private final Logger logger;

    public PlayAnnouncementOperationImpl()
    {
        this(new CallableServiceUtil(), Logger.getLogger(PlayAnnouncementOperationImpl.class));
    }

    PlayAnnouncementOperationImpl(final CallableServiceUtil callableServiceUtil, final Logger logger)
    {
        this.callableServiceUtil = callableServiceUtil;
        this.logger = logger;
    }

    @Override
    public void executePlayAnnouncementOperation(final Call call, final PromptsToPlay promptToPlay)
    {
        logger.finer("PlayAnnouncementOperationImpl executePlayAnnouncementOperation PromptsToPlay ENTER");
        final PlayItem playItem = setPlayItem();
        try
        {
            final StringBuffer source = new StringBuffer();
            source.append(callableServiceUtil.buildUri()).append(promptToPlay.getTitle());
            playItem.setSource(source.toString());
            if (logger.isFinestEnabled())
            {
                logger.finest("PlayAnnouncementOperationImpl executePlayAnnouncementOperation PromptsToPlay setSource: " +
                        source.toString());
            }
        }
        catch (final Exception e)
        {
            logger.error("PlayAnnouncementOperationImpl executePlayAnnouncementOperation: exception=", e);
            call.drop();
        }
        callableServiceUtil.writeLog(PlayAnnouncementOperationImpl.class, call, playItem, logger);
        playAnnouncement(call, playItem);
        logger.finer("PlayAnnouncementOperationImpl executePlayAnnouncementOperation PromptsToPlay EXIT");
    }

    @Override
    public void executePlayAnnouncementOperation(final Call call, final String promptToPlay)
    {
        logger.finer("PlayAnnouncementOperationImpl executePlayAnnouncementOperation String ENTER");
        final PlayItem playItem = setPlayItem();
        try
        {
            final StringBuffer source = new StringBuffer();
            source.append(callableServiceUtil.buildUri()).append(promptToPlay);
            if (logger.isFinestEnabled())
            {
                logger.finest("PlayAnnouncementOperationImpl executePlayAnnouncementOperation String setSource: " +
                        source.toString());
            }
            playItem.setSource(source.toString());
        }
        catch (final Exception e)
        {
            logger.error("PlayAnnouncementOperationImpl executePlayAnnouncementOperation String: exception=",
                    e);
            call.drop();
        }
        callableServiceUtil.writeLog(PlayAnnouncementOperationImpl.class, call, playItem, logger);
        playAnnouncement(call, playItem);
        logger.finer("PlayAnnouncementOperationImpl executePlayAnnouncementOperation String EXIT");
    }

    private PlayItem setPlayItem()
    {
        final PlayItem setPlayItem = MediaFactory.createPlayItem();
        setPlayItem.setInterruptible(true);
        setPlayItem.setIterateCount(1);
        return setPlayItem;
    }

    private void playAnnouncement(final Call call, final PlayItem playItem)
    {
        logger.finer("PlayAnnouncementOperationImpl playAnnouncement ENTER");
        final MediaService mediaService = MediaFactory.createMediaService();
        final CallableServiceMainMenuMediaListener callableServiceMainMenuMediaListener =
                new CallableServiceMainMenuMediaListener(call);
        final Participant participant = call.getCallingParty();

        if (logger.isFinestEnabled())
        {
            logger.finest("PlayAnnouncementOperationImpl playAnnouncement() playing " + playItem.getSource() +
                    " to participant: " + participant.getHandle());
        }

        mediaService.play(participant, playItem, callableServiceMainMenuMediaListener);
        logger.finer("PlayAnnouncementOperationImpl playAnnouncement EXIT");
    }
}
