package com.avaya.zephyr.services.sample_services.CallableService;

import static org.mockito.Mockito.verify;
import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.util.logger.Logger;

@RunWith(PowerMockRunner.class)
@PrepareForTest({ Logger.class })
public class CacheWebFilterTest {
	
	CacheWebFilter cacheWebFilter;
	
	@Mock
	FilterConfig filterConfig;
	
	@Mock
	ServletRequest servletRequest;
	
	@Mock
	HttpServletResponse httpServletResponse;
	
	@Mock
	FilterChain filterChain;
	
	@Mock
	Logger logger;

	@Before
	public void setUp() {
		PowerMockito.mockStatic(Logger.class);
		Mockito.when(Logger.getLogger(Mockito.any(Class.class))).thenReturn(logger);
		CacheWebFilter.logger = logger;
		cacheWebFilter = new CacheWebFilter();
	}
	
	@Test
	public void testInit() throws ServletException {
		cacheWebFilter.init(filterConfig);
	}

	@Test
	public void testDoFilter() throws ServletException, IOException {
		cacheWebFilter.doFilter(servletRequest, httpServletResponse, filterChain);
		verify(filterChain, Mockito.times(1)).doFilter(servletRequest, httpServletResponse);
	}

	@Test
	public void testDestroy() {
		cacheWebFilter.destroy();
	}

}
