package com.avaya.zephyr.services.sample_services.CallableService.operations;

import static org.mockito.Mockito.when;
import static org.mockito.Mockito.verify;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.ServiceAttributeReaderImpl;
import com.avaya.zephyr.services.sample_services.CallableService.util.*;
import com.avaya.collaboration.call.media.MediaFactory;
import com.avaya.collaboration.call.media.MediaService;
import com.avaya.collaboration.call.media.RecordItem;
@RunWith(PowerMockRunner.class)
@PrepareForTest({ServiceAttributeReaderImpl.class, CallableServiceUtil.class,
	MediaFactory.class, RecordItem.class, RecordMessageOperationImpl.class,
	MediaService.class})
public class RecordMessageOperationImplTest {
	private RecordMessageOperationImpl recOperationImpl;

	@Mock
	private Call call;
	@Mock
	private CallableServiceUtil callableServiceUtil;
	@Mock
	private Logger logger;
	@Mock
	private ServiceAttributeReaderImpl serviceAttributeReaderImpl;
	@Mock
	private Participant participant;
	
	@Before
	public void setUp() throws Exception
	{
		recOperationImpl = new RecordMessageOperationImpl(callableServiceUtil, logger);
		when(logger.isFinerEnabled()).thenReturn(true);
		when(logger.isFinestEnabled()).thenReturn(true);
		when(call.getCallingParty()).thenReturn(participant);
		PowerMockito.mockStatic(MediaFactory.class);
		PowerMockito.when(MediaFactory.createRecordItem()).thenReturn(Mockito.mock(RecordItem.class));
		PowerMockito.when(MediaFactory.createMediaService()).thenReturn(Mockito.mock(MediaService.class));
		PowerMockito.whenNew(ServiceAttributeReaderImpl.class).
		withAnyArguments().thenReturn(serviceAttributeReaderImpl);
	}

	@Test
	public void executeRecordMessageOperation()
	{
		recOperationImpl.executeRecordMessageOperation(call);
		verify(logger, Mockito.never()).error(Mockito.any(), Mockito.any(Throwable.class));
		verify(call, Mockito.never()).drop();
	}
	
}
