package com.avaya.zephyr.services.sample_services.CallableService.util;

import static org.mockito.Mockito.when;
import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.verify;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.media.DigitOptions;
import com.avaya.collaboration.call.media.PlayItem;
import com.avaya.collaboration.call.media.RecordItem;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.ClusterAttributeReader;
import com.avaya.zephyr.services.sample_services.CallableService.attributeReaders.TrafficInterfaceAddressRetriever;
@RunWith(PowerMockRunner.class)
public class CallableServiceUtilTest {

	
	CallableServiceUtil callableServiceUtil;
	
	@Mock
	ClusterAttributeReader clusterAttributeReader;
	
	@Mock
	TrafficInterfaceAddressRetriever trafficInterfaceAddressRetriever;
	
	@Mock
	Call call;
	
	@Mock
	PlayItem playItem;
	
	@Mock
	Logger logger;
	
	@Mock
	DigitOptions digitOptions;
	
	@Mock
	RecordItem recordItem;
	
	@Before
	public void setUp()
	{
		callableServiceUtil = new CallableServiceUtil(clusterAttributeReader, trafficInterfaceAddressRetriever);
	}

	@Test
	public void buildUri() throws NoAttributeFoundException
	{
		assertTrue(callableServiceUtil.buildUri().contains("/services/CallableService/"));
	}
	
	@Test
	public void writeLogs() {
		when(logger.isFinestEnabled()).thenReturn(false);
		callableServiceUtil.writeLog(Object.class, call, playItem, logger);
		
		callableServiceUtil.writeLog(Object.class, call, digitOptions, playItem, logger);
		callableServiceUtil.writeLog(Object.class, call, recordItem, logger);
		verify(logger, Mockito.never()).finest(Mockito.any());
		when(logger.isFinestEnabled()).thenReturn(true);
		callableServiceUtil.writeLog(Object.class, call, playItem, logger);
		callableServiceUtil.writeLog(Object.class, call, digitOptions, playItem, logger);
		callableServiceUtil.writeLog(Object.class, call, recordItem, logger);
		verify(logger, Mockito.times(3)).finest(Mockito.any());
	}
	
}
