/*****************************************************************************
 * © 2014 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.Callingpolicies;

import java.util.List;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.ParticipantFactory;
import com.avaya.collaboration.util.logger.Logger;

public final class ForkingOperationImpl implements ForkingOperation
{
    private static final String DOMAIN_DELIMITER_AT = "@";
    private final ServiceAttributeReader serviceAttributeReader;
    private final ClusterAttributeReader clusterAttributeReader;

    private final Logger logger;

    public ForkingOperationImpl()
    {
        this(new ServiceAttributeReaderImpl(), new ClusterAttributeReaderImpl(), Logger
                .getLogger(ForkingOperationImpl.class));
    }

    ForkingOperationImpl(final ServiceAttributeReader serviceAttributeReader,
            final ClusterAttributeReader clusterAttributeReader, final Logger logger)
    {
        this.serviceAttributeReader = serviceAttributeReader;
        this.clusterAttributeReader = clusterAttributeReader;
        this.logger = logger;
    }

    @Override
    public void forkTo(final Call call) throws NoUserFoundException, NoAttributeFoundException,
            ServiceNotFoundException, NoServiceProfileFoundException
    {
        final List<String> forkedParticipants =
                serviceAttributeReader.getForkedDestinations(call.getCalledParty());

        if (logger.isFinestEnabled())
        {
            logger.finest("toFork:  CalledParty=" + call.getCalledParty() + "forkingOperation  Forks=" +
                    forkedParticipants);
        }

        for (final String forkedParticipant : forkedParticipants)
        {
            if (forkedParticipant.contains(DOMAIN_DELIMITER_AT))
            {
                final String handle = getHandle(forkedParticipant);
                final String domain = getDomain(forkedParticipant);
                final String displayNumber = "Trying Fork..." + handle;

                call.addParticipant(ParticipantFactory.create(handle, domain, displayNumber));
            }
            else
            {
                call.addParticipant(ParticipantFactory.create(forkedParticipant,
                        clusterAttributeReader.getDefaultClusterDomain()));
            }
        }
    }

    private String getHandle(final String forkedParticipant)
    {
        final int delimeterIndex = forkedParticipant.indexOf(DOMAIN_DELIMITER_AT);
        final String handle = forkedParticipant.substring(0, delimeterIndex);

        return handle;
    }

    private String getDomain(final String forkedParticipant)
    {
        final int delimeterIndex = forkedParticipant.indexOf(DOMAIN_DELIMITER_AT);
        final String domain = forkedParticipant.substring(delimeterIndex + 1, forkedParticipant.length());

        return domain;
    }
}
