/*****************************************************************************
 * Â© 2014 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.ClickToCall;

import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.CallListenerAbstract;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.call.TheCallListener;
import com.avaya.collaboration.util.logger.Logger;

@TheCallListener
public final class ClickToCallListener extends CallListenerAbstract
{
    private final Logger logger;

    public ClickToCallListener()
    {
        this.logger = Logger.getLogger(ClickToCallListener.class);
    }

    /**
     * This is not a call intercept snap-in. Therefore the callIntercepted
     * method will not be invoked.
     */
    @Override
    public void callIntercepted(final Call call)
    {
    }

    @Override
    public void callAlerting(final Participant alertingParty)
    {
        if (logger.isFinestEnabled())
        {
            logger.finest("callAlerting:" + alertingParty.getAddress());
        }
    }

    @Override
    public void callOriginated(final Call call)
    {
        if (logger.isFinestEnabled())
        {
            logger.finest("callOriginated: first party " + call.getCallingParty().getAddress() +
                    " answered ");
        }
    }

    @Override
    public void callAnswered(final Call call)
    {
        if (logger.isFinestEnabled())
        {
            logger.finest("callAnswered: second party" + call.getCalledParty().getAddress() +
                    " answered ");
        }
    }
}
