/*****************************************************************************
© 2017 Avaya Inc. All rights reserved. 
****************************************************************************/

package com.avaya.zephyr.services.sample_services.OutboundHttpsSample;

import org.apache.commons.lang.StringUtils;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.dal.factory.CollaborationDataFactory;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import com.avaya.zephyr.platform.dal.api.ServiceUtil;

final class AttributeReaderImpl implements AttributeReader
{
    static final String HTTP_MAX_TOTAL_CONNECTIONS = "http.MaxTotalConnections";
    static final String HTTP_MAX_CONNECTIONS_PER_HOST = "http.MaxConnectionsPerRoute";
    static final String HTTP_CONNECTION_REQUEST_TIMEOUT = "http.ConnectionRequestTimeout";
    static final String HTTP_CONNECT_TIMEOUT = "http.ConnectTimeout";
    static final String HTTP_SOCKET_TIMEOUT = "http.SocketTimeout";
    static final int DEFAULT_HTTP_MAX_TOTAL_CONNECTIONS = 1000;
    static final int DEFAULT_HTTP_MAX_CONNECTIONS_PER_HOST = 20;
    static final int TIMEOUT = 2000;
    private ServiceData serviceData;

    public AttributeReaderImpl()
    {
        final ServiceDescriptor sd = ServiceUtil.getServiceDescriptor();
        if (sd != null)
        {
            this.serviceData = CollaborationDataFactory.getServiceData(sd.getName(), sd.getVersion());
        }
        else
        {
            this.serviceData = CollaborationDataFactory.getServiceData("OutboundHttpsSample", "1.0");
        }
    }

    private String getString(final String attName)
    {
        try
        {
            return this.serviceData.getServiceAttribute(attName);
        }
        catch (final NoAttributeFoundException | ServiceNotFoundException e)
        {
            return null;
        }
    }

    private int getInt(final String attName, final int defaultValue)
    {
        try
        {
            final String attValue = getString(attName);
            if (StringUtils.isNotBlank(attValue))
            {
                return Integer.parseInt(attValue);
            }
        }
        catch (final NumberFormatException e)
        {
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public int getHttpMaxTotalConnections()
    {
        return getInt(HTTP_MAX_TOTAL_CONNECTIONS, DEFAULT_HTTP_MAX_TOTAL_CONNECTIONS);
    }

    @Override
    public int getHttpMaxConnectionsPerHost()
    {
        return getInt(HTTP_MAX_CONNECTIONS_PER_HOST, DEFAULT_HTTP_MAX_CONNECTIONS_PER_HOST);
    }

    @Override
    public int getHttpConnectionRequestTimeout()
    {
        return getInt(HTTP_CONNECTION_REQUEST_TIMEOUT, TIMEOUT);
    }

    @Override
    public int getHttpConnectTimeout()
    {
        return getInt(HTTP_CONNECT_TIMEOUT, TIMEOUT);
    }

    @Override
    public int getHttpSocketTimeout()
    {
        return getInt(HTTP_SOCKET_TIMEOUT, TIMEOUT);
    }
}
