package com.avaya.services.whitelist.util;

import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.util.Map;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.util.logger.Logger;

public class PersitanceUnitPropertiesTest
{

    private PersitanceUnitProperties persistanceUnitProperties;
    private ServiceData serviceData;
    private Logger logger;

    @Before
    public void setup()
    {
        serviceData = mock(ServiceData.class);
        logger = Logger.getLogger(PersitanceUnitPropertiesTest.class);
        persistanceUnitProperties = new PersitanceUnitProperties(serviceData,
                logger);
    }

    @Test
    public void testGetPersistanceUnitMapPostgres()
            throws NoAttributeFoundException, ServiceNotFoundException
    {
        when(
                serviceData
                        .getServiceAttribute(PersitanceUnitProperties.JTA_DATA_SOURCE))
                                .thenReturn("java/whitelist");
        Map<String, String> postgresMap = persistanceUnitProperties
                .getPersistanceUnitMap();

        Assert.assertEquals("java/whitelist", postgresMap.get("javax.persistence.jtaDataSource"));
    }

}
