///////////////////////////////////////////////////////////////////////////////
//// MultiChanBroadcastEmailListener.java
////Description:: MultiChanBroadcastEmailListener class logs success and failure Email responses
////
//// Copyright 2013 Avaya Inc. All rights reserved.
//// Usage of this source is bound to the terms described
//// in http://www.avaya.com/devconnect
//// Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
/////////////////////////////////////////////////////////////////////////////////

package com.avaya.zephyr.services.multichanbroadcast.email;

import java.util.List;

import com.avaya.collaboration.email.EmailListener;
import com.avaya.collaboration.email.EmailRequest;
import com.avaya.collaboration.email.EmailResponse;
import com.avaya.collaboration.util.logger.Logger;

public final class MultiChanBroadcastEmailListener implements EmailListener
{
    private final Logger logger;
    private EmailRequest emailRequest = null;

    public MultiChanBroadcastEmailListener(final EmailRequest emailRequest)
    {
        this.emailRequest = emailRequest;
        logger = Logger.getLogger(MultiChanBroadcastEmailListener.class);
    }

    // JUnit constructor
    public MultiChanBroadcastEmailListener(final EmailRequest emailRequest, final Logger logger)
    {
        this.emailRequest = emailRequest;
        this.logger = logger;
    }

    //For a given List of values return a comma separated values
    private StringBuilder createCommaSeparatedFromList(final List<String> inputList){
    	final StringBuilder commaSeperatedValues = new StringBuilder();
    	for (final String commaValue : inputList)
        {
            if (commaSeperatedValues.length() > 0)
            {
            	commaSeperatedValues.append(",");
            }
            commaSeperatedValues.append(commaValue);
        }
    	return commaSeperatedValues;

    }

    // Logs success and failure email recipients with response codes
    @Override
    public void responseReceived(final EmailResponse emailResponse)
    {
    	// Create comma separated recipients in To header
    	final StringBuilder sbRequestTos = createCommaSeparatedFromList(emailRequest.getTo());

        // Create comma separated recipients in Cc header
        final StringBuilder sbRequestCcs = createCommaSeparatedFromList(emailRequest.getCc());


        // Create comma separated recipients in Bcc header
        final StringBuilder sbRequestBccs = createCommaSeparatedFromList(emailRequest.getBcc());


        // Create comma separated invalid recipients
        final StringBuilder sbInvalidAddresses = createCommaSeparatedFromList(emailResponse.getInvalidAddresses());


        // Create comma separated valid unsent recipients
        final StringBuilder sbValidUnsentAddresses = createCommaSeparatedFromList(emailResponse.getValidUnsentAddresses());

        // Create comma separated valid sent recipients
        final StringBuilder sbValidSentAddresses = createCommaSeparatedFromList(emailResponse.getValidSentAddresses());


        // Create a String which holds the email response
        final String emailResponseToString =
                "emailResponse[" + " Status= " + emailResponse.getStatus() +
                        (sbInvalidAddresses.length() == 0 ? ""
                                : " InvalidAddresses=" + sbInvalidAddresses.toString()) +
                        (sbValidUnsentAddresses.length() == 0 ? ""
                                : " ValidUnsentAddresses=" + sbValidUnsentAddresses.toString()) +
                        (sbValidSentAddresses.length() == 0 ? ""
                                : " ValidSentAddresses=" + sbValidSentAddresses.toString()) +
                        " Detail= " + emailResponse.getDetail() + " ]";

        // Create a String which holds the email request with To, Cc and Bcc headers
        final String emailRequestToString = "emailRequest[" +
                (sbRequestTos.length() == 0 ? "" : " To=" + sbRequestTos.toString()) +
                (sbRequestCcs.length() == 0 ? "" : " Cc=" + sbRequestCcs.toString()) +
                (sbRequestBccs.length() == 0 ? "" : " Bcc=" + sbRequestBccs.toString()) +
                ", Subject=" + emailRequest.getSubject() + " Message=" +
                emailRequest.getTextBody() + " ]";

        final String responseReceivedLogString =
                "responseReceived: " + emailResponseToString + " for " + emailRequestToString;

        logger.info(responseReceivedLogString);
    }
}
