#!/usr/bin/env bash
goerror(){

        echo "Exiting without eclipse plugin installation"

}

goConfirmation(){
		while true; do
        read  -p "You are installing older version of zephyr_eclipse plug-in. Do you still want to install Eclipse Plug-in for Avaya Breeze(R) platform[y/n]:" data
        case $data in
            [Yy]* ) goCopyPluginJar;;
            [Nn]* ) echo "Exiting without eclipse plugin installation.";exit 1;;
                * ) echo "Please answer Y/y or N/n.";;
        esac
done
}

goSnapshotConfirmation(){
		while true; do
        read  -p "You are installing Snapshot version of zephyr_eclipse plug-in. Do you still want to install Eclipse Plug-in for Avaya Breeze(R) platform[y/n]:" data
        case $data in
            [Yy]* ) goCopyPluginJar;;
            [Nn]* ) echo "Exiting without eclipse plugin installation.";exit 1;;
                * ) echo "Please answer Y/y or N/n.";;
        esac
done
}

goCopyPluginJar(){
		if [ -d "$var/plugins" ]; 
		then
			cp lib/com.avaya.zephyr.eclipse.plugin.jar "$var/plugins/"
			cp eclipse-bundles/*.jar "$var/plugins/"
		else
			cp lib/com.avaya.zephyr.eclipse.plugin.jar "$var/dropins/"
			cp eclipse-bundles/*.jar "$var/dropins/"
		fi

		
		read  -p "Eclipse plugin installation needs eclipse to start in clean mode. Do you want to add the '-clean' option to eclipse.ini file ? [y/n]:" data
		case $data in
            [Yy]* )
                grep  -clean $var/eclipse.ini > /dev/null;
                if [ $? -ne 0 ]
                then
                	sed -i '1i-clean' $var/eclipse.ini;
                fi;;
             * )    read -p "Please start Eclipse with -clean option for all your existing eclipse Workspaces for this plugin to take effect. Hit enter to continue.";;
		esac
		
	 	echo "Plug-in installation Succeeded.Restart your eclipse to load the new plug-in."
	 	exit 1
}

while true; do
        read  -p "Do you want to install Eclipse Plugin for Avaya Breeze(R) platform[y/n]:" data
        case $data in
            [Yy]* ) break;;
            [Nn]* ) echo "Exiting without eclipse plugin installation.";exit 1;;
                * ) echo "Please answer Y/y or N/n.";;
        esac
done

	read  -p "Enter eclipse Install Directory [/var/eclipse/]:" var

	if [ -z "$var" ]; then
		var="/var/eclipse/"

	fi
	
	if [ -d "$var/plugins" ]; then
		pluginDir="$var/plugins"
	fi
	
	if [ -d "$var/dropins" ]; then
		pluginDir="$var/dropins"
	fi
	
	if [ -d "$pluginDir" ]; then
	
	#verify plugin Bundle Version before copying to eclipse plug-in directory
	
	if [ -f ./lib/com.avaya.zephyr.eclipse.plugin.jar ]
	then
	echo "Eclipse plug-in jar present in sdk!"
	else
      echo "Eclipse plug-in jar not available in sdk!"
	fi
	cp ./lib/com.avaya.zephyr.eclipse.plugin.jar /tmp/com.avaya.zephyr.eclipse.plugin.jar

	cd /tmp/

	jar -xvf com.avaya.zephyr.eclipse.plugin.jar META-INF/MANIFEST.MF

	cd -

	BUNDLE_VERSION=`sed -n 's/.*Bundle-Version:=*//p' /tmp/META-INF/MANIFEST.MF`
	echo $BUNDLE_VERSION
	MAJOR_VERSION=$(echo $BUNDLE_VERSION | cut -f1 -d.)
	echo "Plug-in major version is :  $MAJOR_VERSION"
	MINOR_VERSION=$(echo $BUNDLE_VERSION | cut -f2 -d.)
	echo "Plug-in minor version is :  $MINOR_VERSION"
	MICRO_VERSION=$(echo $BUNDLE_VERSION | cut -f3 -d.)
	echo "Plug-in micro version is :  $MICRO_VERSION"
	QUALIFIER=$(echo $BUNDLE_VERSION | cut -f4 -d.)
	QUALIFIER_VERSION=$(echo $QUALIFIER | cut -f1 -d-)
	echo "Plug-in qualifier version is :  $QUALIFIER_VERSION"
	RELEASE_VERSION=$(echo $QUALIFIER | cut -f2 -d- | tr -d '\n' | tr -d '\r')
	#RELEASE_VERSION=sed -i 's/\\n//g' $RELEASE_VERSION	
	echo "Plug-in release version is :  $RELEASE_VERSION"	
	
	#verify that if eclipse plug-in already installed
	
	if [ -f "$pluginDir/"com.avaya.zephyr.eclipse.plugin.jar ]
	then
		echo "Eclipse plug-in already installed on given eclipse!"
		cp "$pluginDir/"com.avaya.zephyr.eclipse.plugin.jar /tmp/com.avaya.zephyr.eclipse.plugin.jar
	cd /tmp/

	jar -xvf com.avaya.zephyr.eclipse.plugin.jar META-INF/MANIFEST.MF

	cd -	
	DEPLOYED_BUNDLE_VERSION=`sed -n 's/.*Bundle-Version:=*//p' /tmp/META-INF/MANIFEST.MF`
	echo $DEPLOYED_BUNDLE_VERSION
	DEPLOYED_MAJOR_VERSION=$(echo $BUNDLE_VERSION | cut -f1 -d.)
	echo "Deployed Plug-in major version is :  $DEPLOYED_MAJOR_VERSION"
	DEPLOYED_MINOR_VERSION=$(echo $DEPLOYED_BUNDLE_VERSION | cut -f2 -d.)
	echo "Deployed Plug-in minor version is :  $DEPLOYED_MINOR_VERSION"
	DEPLOYED_MICRO_VERSION=$(echo $DEPLOYED_BUNDLE_VERSION | cut -f3 -d.)
	echo "Deployed Plug-in micro version is :  $MICRO_VERSION"
	DEPLOYED_QUALIFIER=$(echo $DEPLOYED_BUNDLE_VERSION | cut -f4 -d.)
	DEPLOYED_QUALIFIER_VERSION=$(echo $DEPLOYED_QUALIFIER | cut -f1 -d-)
	echo "Deployed Plug-in qualifier version is :  $DEPLOYED_QUALIFIER_VERSION"
	DEPLOYED_RELEASE_VERSION=$(echo $DEPLOYED_QUALIFIER | cut -f2 -d- | tr -d '\n' | tr -d '\r')
	#DEPLOYED_RELEASE_VERSION=sed -i 's/\\n//g' $DEPLOYED_RELEASE_VERSION 
	echo "Deployed Plug-in release version is :  $DEPLOYED_RELEASE_VERSION"
	

if [ $MAJOR_VERSION -gt $DEPLOYED_MAJOR_VERSION ]; then
                echo "Deployed plug-in major version is lower than major version of new plug-in!"
                if [ "$RELEASE_VERSION" = "SNAPSHOT" ]; then 
   	 				echo "Eclipse plug-in release version is SNAPSHOT!"
					goSnapshotConfirmation
					fi
                echo "Replacing old plug-in with new plug-in".
                goCopyPluginJar
				
				elif [ $MAJOR_VERSION -lt $DEPLOYED_MAJOR_VERSION ]; then 
				echo "Deployed plug-in major version is higher than major version of new plug-in!"
				goConfirmation
               
     fi
     
	if [ $MINOR_VERSION -gt $DEPLOYED_MINOR_VERSION ]; then
                echo "Deployed plug-in minor version is lower than minor version of new plug-in!"
                if [ "$RELEASE_VERSION" = "SNAPSHOT" ]; then 
   	 				echo "Eclipse plug-in release version is SNAPSHOT!"
					goSnapshotConfirmation
					fi
                echo "Replacing old plug-in with new plug-in".
                goCopyPluginJar
				elif [ $MINOR_VERSION -lt $DEPLOYED_MINOR_VERSION ]; then 
				echo "Deployed plug-in minor version is higher than minor version of new plug-in!"
				goConfirmation
               
     fi
     
     if [ $MICRO_VERSION -gt $DEPLOYED_MICRO_VERSION ]; then
                echo "Deployed plug-in micro version is lower than micro version of new plug-in!"
                if [ "$RELEASE_VERSION" = "SNAPSHOT" ]; then 
   	 				echo "Eclipse plug-in release version is SNAPSHOT!"
					goSnapshotConfirmation
					fi
					echo "Replacing old plug-in with new plug-in".
                goCopyPluginJar
				elif [ $MICRO_VERSION -lt $DEPLOYED_MICRO_VERSION ]; then 
				echo "Deployed plug-in micro version is higher than micro version of new plug-in!"
				goConfirmation
               
     fi
     
      if [ $QUALIFIER_VERSION -gt $DEPLOYED_QUALIFIER_VERSION ]; then
                echo "Deployed plug-in qualifier version is lower than qualifier version of new plug-in!"
                echo "Replacing old plug-in with new plug-in".
                if [ "$RELEASE_VERSION" = "SNAPSHOT" ]; then 
   	 				echo "Eclipse plug-in release version is SNAPSHOT!"
					goSnapshotConfirmation
					fi
                goCopyPluginJar
				elif [ $QUALIFIER_VERSION -lt $DEPLOYED_QUALIFIER_VERSION ]; then 
				echo "Deployed plug-in qualifier version is higher than qualifier version of new plug-in!"
				goConfirmation
               
     fi
	
	if [ "$DEPLOYED_RELEASE_VERSION" = "SNAPSHOT" ]; then
         echo "Eclipse plug-in deployed version is SNAPSHOT"
         goCopyPluginJar
          echo "Plug-in installation Succeeded.Restart your eclipse to load the new plug-in."
	exit 1
        fi

		
	if [ "$RELEASE_VERSION" = "SNAPSHOT" ]; then 
   	 echo "Eclipse plug-in release version is SNAPSHOT!"
	goSnapshotConfirmation
	fi

 
	 if [ $RELEASE_VERSION -gt $DEPLOYED_RELEASE_VERSION ]; then
                echo "Deployed plug-in release version is lower than release version of new plug-in!"
                goCopyPluginJar
				elif [ $RELEASE_VERSION -lt $DEPLOYED_RELEASE_VERSION ]; then 
				echo "Deployed plug-in release version is higher than release version of new plug-in!"
				goConfirmation

     fi

	
	
	if [ $DEPLOYED_MAJOR_VERSION -eq $MAJOR_VERSION ]; then
	if [ $DEPLOYED_MINOR_VERSION -eq $MINOR_VERSION ]; then
	if [ $DEPLOYED_MICRO_VERSION -eq $MICRO_VERSION ]; then
	if [ $DEPLOYED_QUALIFIER_VERSION -eq $QUALIFIER_VERSION ]; then
	if [ $DEPLOYED_RELEASE_VERSION -eq $RELEASE_VERSION ]; then
		echo "Deployed plug-in Bundle-Version and new plug-in Bundle-Version is same and replacing deployed plug-in with new plug-in."
		goCopyPluginJar
	 	echo "Plug-in installation Succeeded.Restart your eclipse to load the new plug-in."
	 	exit 1
	fi
	fi
	fi
	fi
	fi
    
    #code for copying older plugin
     goConfirmation
    echo "Eclipse-release plug-in version is newer.Replacing existing plug-in with new plug-in."
        goCopyPluginJar
        echo "Plug-in installation Succeeded.Restart your eclipse to load the new plug-in."
        exit 1                   
	else
      echo "Eclipse plug-in previously not installed on given eclipse."
          goCopyPluginJar
	  echo "Plug-in installation Succeeded.Restart your eclipse to load the new plug-in."
	  exit 1
	fi 
	
         else
	   echo "Plugins folder not found in the target directory"
	   goerror
	fi
