#!/usr/bin/env bash

#SDK_MVN_OPT is used to provide extra maven options during installer testing.

# install_jar installs a jar artifact to the local maven repository
# usage: install_jar file pom_file
INSTALL_DIR=`dirname "$0"`

SDK_VERSION=3.9

install_jar() {
	mvn $SDK_MVN_OPT install:install-file \
		-Dfile=$1 \
		-DpomFile=$2
	if [ $? -ne 0 ]; then fail; fi;
}

install_jar_javadoc() {
	mvn $SDK_MVN_OPT install:install-file \
		-Dfile=$1 \
		-DpomFile=$2 \
		-Djavadoc=$3
	if [ $? -ne 0 ]; then fail; fi;
}

install_archetype() {
	mvn $SDK_MVN_OPT install:install-file \
		-Dfile=$1 \
		-DpomFile=$2 \
		-Dpackaging=jar
	if [ $? -ne 0 ]; then fail; fi;
}

fail() {
	echo "Install failed."
	while true; do
        read -p "Please enter Y/y to close the prompt.)" yn
        case $yn in
            [Yy]* ) exit 1;;
                * ) echo "Please enter Y/y.";;
        esac
done
	exit 1
}

more $INSTALL_DIR/LICENSE.txt

while true; do
        read -p "Accept above End User License Agreement(EULA)? (Y/N)" yn
        case $yn in
            [Yy]* ) break;;
            [Nn]* ) echo "EULA is not accepted, install terminated!!!.";exit 1;;
                * ) echo "Please answer Y/y or N/n.";;
        esac
done

dos2unix $INSTALL_DIR/eclipse.sh
sh $INSTALL_DIR/eclipse.sh
install_jar "$INSTALL_DIR/lib/archive-xsd.jar" "$INSTALL_DIR/lib/archive-xsd.pom"
install_jar "$INSTALL_DIR/lib/xsds.pom" "$INSTALL_DIR/lib/xsds.pom"
install_jar "$INSTALL_DIR/lib/java-facade.jar" "$INSTALL_DIR/lib/java-facade.pom"
install_jar "$INSTALL_DIR/lib/unit-test-utils.jar" "$INSTALL_DIR/lib/unit-test-utils.pom"
install_jar "$INSTALL_DIR/lib/avaya-aura-collaboration-api-$SDK_VERSION.jar" "$INSTALL_DIR/lib/avaya-aura-collaboration-api-$SDK_VERSION.pom"
install_jar "$INSTALL_DIR/lib/avaya-aura-collaboration-sdk.pom" "$INSTALL_DIR/lib/avaya-aura-collaboration-sdk.pom"
install_jar "$INSTALL_DIR/lib/zephyrDataUtil.jar" "$INSTALL_DIR/lib/zephyrDataUtil.pom"
install_jar "$INSTALL_DIR/lib/avaya-commons-java-pom.pom" "$INSTALL_DIR/lib/avaya-commons-java-pom.pom"
install_jar "$INSTALL_DIR/lib/avaya-commons-pom.pom" "$INSTALL_DIR/lib/avaya-commons-pom.pom"
install_jar "$INSTALL_DIR/lib/avaya-logging-client.jar" "$INSTALL_DIR/lib/avaya-logging-client.pom"
install_jar "$INSTALL_DIR/lib/avaya-commons-io.jar" "$INSTALL_DIR/lib/avaya-commons-io.pom"
install_jar "$INSTALL_DIR/lib/asm-common.jar" "$INSTALL_DIR/lib/asm-common.pom"
install_jar "$INSTALL_DIR/lib/avaya-commons-lang.jar" "$INSTALL_DIR/lib/avaya-commons-lang.pom"
install_jar "$INSTALL_DIR/lib/sdk.pom" "$INSTALL_DIR/lib/sdk.pom"
install_archetype "$INSTALL_DIR/lib/service-archetype.jar" "$INSTALL_DIR/lib/service-archetype.pom"
install_jar_javadoc "$INSTALL_DIR/lib/smc-api.jar" "$INSTALL_DIR/lib/smc-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/smc.pom" "$INSTALL_DIR/lib/smc.pom"
install_jar_javadoc "$INSTALL_DIR/lib/logging-api.jar" "$INSTALL_DIR/lib/logging-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/logging.pom" "$INSTALL_DIR/lib/logging.pom"
install_jar_javadoc "$INSTALL_DIR/lib/schedConf-api.jar" "$INSTALL_DIR/lib/schedConf-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/schedConf.pom" "$INSTALL_DIR/lib/schedConf.pom"
install_jar_javadoc "$INSTALL_DIR/lib/sms-api.jar" "$INSTALL_DIR/lib/sms-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/sms.pom" "$INSTALL_DIR/lib/sms.pom"
install_jar_javadoc "$INSTALL_DIR/lib/email-api.jar" "$INSTALL_DIR/lib/email-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/email.pom" "$INSTALL_DIR/lib/email.pom"
install_jar_javadoc "$INSTALL_DIR/lib/eventing-api.jar" "$INSTALL_DIR/lib/eventing-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/eventing.pom" "$INSTALL_DIR/lib/eventing.pom"
install_jar_javadoc "$INSTALL_DIR/lib/http-api.jar" "$INSTALL_DIR/lib/http-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/http.pom" "$INSTALL_DIR/lib/http.pom"
install_jar_javadoc "$INSTALL_DIR/lib/ssl_util-api.jar" "$INSTALL_DIR/lib/ssl_util-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/ssl_util.pom" "$INSTALL_DIR/lib/ssl_util.pom"
install_jar_javadoc "$INSTALL_DIR/lib/authorization_helper-api.jar" "$INSTALL_DIR/lib/authorization_helper-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/authorization_helper.pom" "$INSTALL_DIR/lib/authorization_helper.pom"
install_jar_javadoc "$INSTALL_DIR/lib/serviceActivity-api.jar" "$INSTALL_DIR/lib/serviceActivity-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/serviceActivity.pom" "$INSTALL_DIR/lib/serviceActivity.pom"
install_jar_javadoc "$INSTALL_DIR/lib/reliableeventing-api.jar" "$INSTALL_DIR/lib/reliableeventing-api.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/reliableeventing.pom" "$INSTALL_DIR/lib/reliableeventing.pom"
install_jar_javadoc "lib/platformListener-api.jar" "lib/platformListener-api.pom" "javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "lib/platformListener.pom" "lib/platformListener.pom"
install_jar "$INSTALL_DIR/lib/archive-xsd.jar" "$INSTALL_DIR/lib/archive-xsd.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/archive-jaxb.jar" "$INSTALL_DIR/lib/archive-jaxb.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar_javadoc "$INSTALL_DIR/lib/zephyrDataApiFactory.jar" "$INSTALL_DIR/lib/zephyrDataApiFactory.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar_javadoc "$INSTALL_DIR/lib/zephyrDM.jar" "$INSTALL_DIR/lib/zephyrDM.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar_javadoc "$INSTALL_DIR/lib/zephyrDataAPI.jar" "$INSTALL_DIR/lib/zephyrDataAPI.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar_javadoc "$INSTALL_DIR/lib/ceSystemStatus.jar" "$INSTALL_DIR/lib/ceSystemStatus.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/zephyrEncryptDecrypt.jar" "$INSTALL_DIR/lib/zephyrEncryptDecrypt.pom"
install_jar "$INSTALL_DIR/lib/zephyrCommon.pom" "$INSTALL_DIR/lib/zephyrCommon.pom"
install_jar "$INSTALL_DIR/lib/zephyrDAO.pom" "$INSTALL_DIR/lib/zephyrDAO.pom"
install_jar "$INSTALL_DIR/lib/sample_services.pom" "$INSTALL_DIR/lib/sample_services.pom"
install_jar "$INSTALL_DIR/lib/collaborationBus.pom" "$INSTALL_DIR/lib/collaborationBus.pom"
install_jar_javadoc "$INSTALL_DIR/lib/collaborationBusAPI.jar" "$INSTALL_DIR/lib/collaborationBusAPI.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar_javadoc "$INSTALL_DIR/lib/collaborationBusFactory.jar" "$INSTALL_DIR/lib/collaborationBusFactory.pom" "$INSTALL_DIR/javadoc/avaya-aura-collaboration-javadoc-$SDK_VERSION.jar"
install_jar "$INSTALL_DIR/lib/platform.pom" "$INSTALL_DIR/lib/platform.pom"
install_jar "$INSTALL_DIR/lib/main.pom" "$INSTALL_DIR/lib/main.pom"
install_jar "$INSTALL_DIR/lib/api.pom" "$INSTALL_DIR/lib/api.pom"
install_jar "$INSTALL_DIR/lib/schemas.pom" "$INSTALL_DIR/lib/schemas.pom"

mvn $SDK_MVN_OPT archetype:crawl -Dcatalog='${settings.localRepository}/../archetype-catalog.xml'
if [ $? -ne 0 ] ; then fail ; fi ;

echo "Install successful."
	while true; do
        read -p "Please enter Y/y to close the prompt.)" yn
        case $yn in
            [Yy]* ) exit 1;;
                * ) echo "Please enter Y/y.";;
        esac
done
	exit 1
