/****************************************************************************
 * Copyright Avaya Inc., All Rights Reserved.
 * THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 * The copyright notice above does not evidence any actual or intended publication of such source code.
 * Some third-party source code components may have been modified from their original versions by Avaya Inc.
 * The modifications are Copyright Avaya Inc., All Rights Reserved.
 * Avaya Confidential & Restricted. May not be distributed further without written permission of
 * the Avaya owner.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.TaskDashboard.provider;

import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import com.avaya.asm.core.AsmConstants.TRANSPORT;
import com.avaya.asm.datamgr.AssetDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.objectapi.AssetLinkInfo;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(MockitoJUnitRunner.class)
public class EndpointProviderImplTest
{
    EndpointProvider endpointProvider;
    @Mock
    ServiceData mockServiceData;
    @Mock
    Logger mockLogger;
    @Mock
    private static DMFactory dmFactoryMock;
    @Mock
    private static AssetDM assetDmMock;
    @Mock
    private static AssetLinkInfo localAssetMock;

    @Before
    public void before()
    {
        endpointProvider = new EndpointProviderImpl(dmFactoryMock, mockLogger);
    }

    @Test
    public void buildResourceEndpoint_resourceEndpointBuilding_success() throws Exception
    {
        Mockito.when(dmFactoryMock.getDataMgr(AssetDM.class)).thenReturn(assetDmMock);
        Mockito.when(assetDmMock.getAssetLinkInfo(TRANSPORT.TCP)).thenReturn(localAssetMock);
        
        endpointProvider.buildResourceEndpoint();
        
        assertNotNull(endpointProvider.getResourceEndpoint());
    }
}
