/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.sms;

import java.util.List;

import com.avaya.collaboration.sms.SmsListener;
import com.avaya.collaboration.sms.SmsRequest;
import com.avaya.collaboration.sms.SmsResponse;
import com.avaya.collaboration.util.logger.Logger;

public final class CallDeflectionSmsListener implements SmsListener
{
    private final Logger logger;
    private SmsRequest smsRequest = null;

    public CallDeflectionSmsListener(final SmsRequest smsRequest)
    {
        this.smsRequest = smsRequest;
        logger = Logger.getLogger(CallDeflectionSmsListener.class);
    }

    public CallDeflectionSmsListener(final SmsRequest smsRequest, final Logger logger)
    {
        this.smsRequest = smsRequest;
        this.logger = logger;
    }

    private StringBuilder createCommaSeparatedFromList(final List<String> inputList)
    {
        final StringBuilder commaSeperatedValues = new StringBuilder();
        for (final String commaValue : inputList)
        {
            if (commaSeperatedValues.length() > 0)
            {
                commaSeperatedValues.append(",");
            }
            commaSeperatedValues.append(commaValue);
        }
        return commaSeperatedValues;

    }

    @Override
    public void responseReceived(final SmsResponse smsResponse)
    {
        // Create comma separated recipients
        final StringBuilder sbRequestRecipients = createCommaSeparatedFromList(smsRequest.getRecipients());

        // Create comma separated delivered recipients
        final StringBuilder sbDeliveredRecipients = createCommaSeparatedFromList(smsResponse.getDeliveredRecipients());

        // Create comma separated pending recipients
        final StringBuilder sbPendingRecipients = createCommaSeparatedFromList(smsResponse.getPendingRecipients());

        // Create comma separated failed recipients
        final StringBuilder sbFailedRecipients = createCommaSeparatedFromList(smsResponse.getFailedRecipients());

        // Create a String which holds the SMS response
        final String smsResponseToString =
                "smsResponse[" + " Status= " + smsResponse.getStatus() +
                        (sbDeliveredRecipients.length() == 0 ? "" : " DeliveredRecipients=" +
                                sbDeliveredRecipients.toString()) +
                        (sbPendingRecipients.length() == 0 ? "" : " PendingRecipients=" +
                                sbPendingRecipients.toString()) +
                        (sbFailedRecipients.length() == 0 ? "" : " FailedRecipients=" +
                                sbFailedRecipients.toString()) +
                        " Detail= " + smsResponse.getDetail() + " ]";

        // Create a String which holds the SMS request
        final String smsRequestToString = "smsRequest[ To=" +
                (sbRequestRecipients.toString()) + " Message=" + smsRequest.getText() + " ]";

        final String responseReceivedLogString =
                "responseReceived: " + smsResponseToString + " for " + smsRequestToString;

        logger.info(responseReceivedLogString);
    }
}
