/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.email;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.Arrays;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.email.EmailRequest;
import com.avaya.collaboration.email.EmailResponse;
import com.avaya.collaboration.util.logger.Logger;

@RunWith(PowerMockRunner.class)
public final class CallDeflectionEmailListenerTest
{
    private CallDeflectionEmailListener callDeflectionEmailListenerTest;
    @Mock
    private EmailRequest mockEmailRequest;
    @Mock
    private EmailResponse mockEmailResponse;
    @Mock
    private Logger mockLogger;

    @Before
    public void setUpMockCommon() throws Exception
    {
        callDeflectionEmailListenerTest = new CallDeflectionEmailListener(mockEmailRequest, mockLogger);
    }

    @Test
    public void testResponseReceived() throws Exception
    {
        when(mockEmailRequest.getTo()).thenReturn(new ArrayList<String>(Arrays.asList("to@domain.com")));
        when(mockEmailRequest.getCc()).thenReturn(new ArrayList<String>(Arrays.asList("cc@domain.com")));
        when(mockEmailRequest.getBcc()).thenReturn(new ArrayList<String>(Arrays.asList("bcc@domain.com")));
        when(mockEmailRequest.getSubject()).thenReturn("subject");
        when(mockEmailRequest.getTextBody()).thenReturn("body");

        when(mockEmailResponse.getInvalidAddresses()).thenReturn(new ArrayList<String>(Arrays.asList("invalid@domain.com")));
        when(mockEmailResponse.getValidUnsentAddresses()).thenReturn(new ArrayList<String>(Arrays.asList("validUnsent@domain.com")));
        when(mockEmailResponse.getValidSentAddresses()).thenReturn(new ArrayList<String>(Arrays.asList("validSent@domain.com")));
        when(mockEmailResponse.getStatus()).thenReturn(5);
        when(mockEmailResponse.getDetail()).thenReturn("detail");

        callDeflectionEmailListenerTest.responseReceived(mockEmailResponse);
        verify(mockLogger).info(Matchers.any(String.class));
    }
}
