/*****************************************************************************
 * © 2017 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.services.CallDeflection.sms;

import static org.junit.Assert.assertTrue;
import static org.mockito.Mockito.doThrow;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;
import static org.powermock.api.mockito.PowerMockito.mockStatic;

import javax.servlet.http.HttpServletRequest;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.bus.CollaborationBusException;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceData;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.call.Call;
import com.avaya.collaboration.call.Participant;
import com.avaya.collaboration.sms.SmsFactory;
import com.avaya.collaboration.sms.SmsRequest;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.services.CallDeflection.util.ServiceAttributeReader;

@RunWith(PowerMockRunner.class)
@PrepareForTest(
{ SmsRequest.class, SmsFactory.class, CallDeflectionSmsListener.class, ServiceAttributeReader.class })
public class CallDeflectionSmsSenderTest
{
    @Mock
    private CollaborationBusException exception;
    private CallDeflectionSmsSender CallDeflectionSmsSenderTest;
    @Mock
    private Logger mockLogger;
    @Mock
    ServiceAttributeReader mockServiceAttributeReader;
    @Mock
    private HttpServletRequest mockHttpServletRequest;
    @Mock
    private ServiceData mockServiceData;
    @Mock
    private SmsRequest mockSmsRequest;
    @Mock
    private CallDeflectionSmsListener mockCallDeflectionSmsListener;
    @Mock
    private Call call;
    @Mock
    private Participant participant;

    @Before
    public final void setup()
    {
        CallDeflectionSmsSenderTest = new CallDeflectionSmsSender(mockServiceAttributeReader, mockLogger);
    }

    @Test
    public void sendSms() throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException
    {
        when(mockServiceAttributeReader.getSmsTo()).thenReturn("smsTo");
        when(mockServiceAttributeReader.getSmsFrom()).thenReturn("smsFrom");
        mockStatic(SmsFactory.class);
        when(SmsFactory.createSmsRequest("smsTo", "CallDeflection Demo")).thenReturn(mockSmsRequest);
        assertTrue(CallDeflectionSmsSenderTest.sendSms(call));
        verify(mockSmsRequest).setSender("smsFrom");
    }

    @Test
    public void sendSmsException()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException,
            CollaborationBusException
    {
        when(mockServiceAttributeReader.getSmsTo()).thenReturn("smsTo");
        when(mockServiceAttributeReader.getSmsFrom()).thenReturn("smsFrom");
        mockStatic(SmsFactory.class);
        when(SmsFactory.createSmsRequest("smsTo", "CallDeflection Demo")).thenReturn(mockSmsRequest);
        doThrow(exception).when(mockSmsRequest).send();
        CallDeflectionSmsSenderTest.sendSms(call);
        verify(mockLogger).error("Error: Error occured sending SMS.", exception);
    }

    @Test
    public void sendSmsToBlank()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException,
            CollaborationBusException
    {
        when(mockServiceAttributeReader.getSmsFrom()).thenReturn("smsFrom");
        CallDeflectionSmsSenderTest.sendSms(call);
        verify(mockLogger).info("Info: SMS To is blacnk,  SMS will not be sent");
    }

    @Test
    public void sendSmsToBlankWithCallingNumber()
            throws NoAttributeFoundException, ServiceNotFoundException, NoUserFoundException, NoServiceProfileFoundException,
            CollaborationBusException
    {
        when(call.getCallingParty()).thenReturn(participant);
        when(participant.getHandle()).thenReturn("1111");
        when(mockServiceAttributeReader.getSmsFrom()).thenReturn("smsFrom");
        mockStatic(SmsFactory.class);
        when(SmsFactory.createSmsRequest("1111", "CallDeflection Demo")).thenReturn(mockSmsRequest);
        assertTrue(CallDeflectionSmsSenderTest.sendSms(call));
        verify(mockSmsRequest).setSender("smsFrom");
    }
}
