/*****************************************************************************
 * © 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.CallableService;

import static org.mockito.Mockito.when;
import static org.mockito.Mockito.verify;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

import org.apache.commons.io.IOUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.powermock.modules.junit4.PowerMockRunner;

import com.avaya.collaboration.util.logger.Logger;

import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;



@RunWith(PowerMockRunner.class)
@PrepareForTest({ Logger.class, File.class, FileOutputStream.class,
	CallableServiceServlet.class })
public class CallableServiceServletTest {
	
	CallableServiceServlet callableServiceServlet;
	
	@Mock
	HttpServletRequest httpServletRequest;
	
	@Mock
	HttpServletResponse httpServletResponse;
	
	@Mock
	ServletConfig servletConfig;
	
	@Mock
	Logger logger;
	
	@Mock
	File file;
	
	@Mock
	FileOutputStream fileOutputStream;
	
	InputStream inputStream;
	
	@Mock
	ServletContext servletContext;
	
	@Mock
	Part part;
	
	@Mock
	PrintWriter printWriter;
	
	@Before
	public void setUp() throws ServletException, Exception
	{
		PowerMockito.mockStatic(Logger.class);
		Mockito.when(Logger.getLogger(Mockito.any(Class.class))).thenReturn(logger);
		when(logger.isFinestEnabled()).thenReturn(true);
		PowerMockito.mockStatic(File.class);
		PowerMockito.whenNew(File.class).withAnyArguments().thenReturn(file);
		when(file.delete()).thenReturn(true);
		PowerMockito.whenNew(FileOutputStream.class).withAnyArguments().thenReturn(fileOutputStream);
		when(httpServletRequest.getPart(Mockito.anyString())).thenReturn(part);
		when(httpServletResponse.getWriter()).thenReturn(printWriter);
		when(servletContext.getRealPath("/")).thenReturn("/");
		callableServiceServlet = new CallableServiceServlet() {
			public ServletContext getServletContext() {
				return servletContext;
			}
		};
		callableServiceServlet.init(servletConfig);
	}
	@Test
	public void doPost_audioFile() throws ServletException, IOException
	{
		String test = "ddddddddTestTestddddddddTestTestddddddddTestTest";
		inputStream = IOUtils.toInputStream(test);
		when(part.getInputStream()).thenReturn(inputStream);
		when(part.getSize()).thenReturn((long)test.length());
		when(file.delete()).thenReturn(true);
		callableServiceServlet.doPost(httpServletRequest, httpServletResponse);
		verify(printWriter, Mockito.never()).write(Mockito.anyString());
	}
	
	@Test
	public void doPost_emptyFile() throws ServletException, IOException
	{
		String test2 = "";
		inputStream = IOUtils.toInputStream(test2);
		when(part.getInputStream()).thenReturn(inputStream);
		when(part.getSize()).thenReturn((long)test2.length());
		when(file.delete()).thenReturn(false);
		callableServiceServlet.doPost(httpServletRequest, httpServletResponse);
		verify(printWriter, Mockito.never()).write(Mockito.anyString());
	}
	
	@Test
	public void doPut() throws ServletException, IOException
	{
		when(file.exists()).thenReturn(true);
		callableServiceServlet.doPut(httpServletRequest, httpServletResponse);
	}
	
	@Test
	public void doDelete() throws ServletException, IOException
	{
		when(file.delete()).thenReturn(true);
		callableServiceServlet.doDelete(httpServletRequest, httpServletResponse);
		when(file.delete()).thenReturn(false);
		callableServiceServlet.doDelete(httpServletRequest, httpServletResponse);
		verify(file, Mockito.times(2)).delete();
		verify(printWriter, Mockito.never()).write(Mockito.anyString());
	} 
      
}
