/****************************************************************************
* Copyright Avaya Inc., All Rights Reserved.
* THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
* The copyright notice above does not evidence any actual or intended publication of such source code.
* Some third-party source code components may have been modified from their original versions by Avaya Inc.
* The modifications are Copyright Avaya Inc., All Rights Reserved.
* Avaya Confidential & Restricted. May not be distributed further without written permission of
* the Avaya owner.
****************************************************************************/
package com.avaya.zephyr.services.sample_services.Authorization.TaskRepository.validator;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;

import com.avaya.zephyr.services.sample_services.Authorization.TaskRepository.exception.InvalidRequestException;
import com.avaya.zephyr.services.sample_services.Authorization.TaskRepository.util.RequestData;

public final class CreateRequestValidator implements RequestValidator
{
    @Override
    public void validate(final RequestData requestData) throws InvalidRequestException
    {
        if (StringUtils.isBlank(requestData.getBearerToken()))
        {
            throw new InvalidRequestException("Null or empty bearer token",
                    HttpServletResponse.SC_FORBIDDEN);
        }
        if (requestData.getTask() == null)
        {
            throw new InvalidRequestException("Input task cannot be null",
                    HttpServletResponse.SC_BAD_REQUEST);
        }
    }
}
