/*****************************************************************************
 * Â© 2014 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.ClickToCall;

import javax.enterprise.context.ApplicationScoped;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import com.avaya.collaboration.util.logger.Logger;

@ApplicationScoped
@Path("/twoPartyCallManager")
public final class TwoPartyCallManagerResource
{
    private final RequestProcessor requestProcessor;
    private final Logger logger;

    public TwoPartyCallManagerResource()
    {
        this(new RequestProcessorImpl(), Logger.getLogger(TwoPartyCallManagerResource.class));
    }

    TwoPartyCallManagerResource(final RequestProcessor requestProcessor, final Logger logger)
    {
        this.requestProcessor = requestProcessor;
        this.logger = logger;
    }

    @POST
    public String doPost(final String body)
    {
        // Validate the request to protect against CSRF, XSS etc.
        // Read more about CSRF and protection implementation against it
        // https://www.owasp.org/index.php/Cross-Site_Request_Forgery_(CSRF)_Prevention_Cheat_Sheet.
        try
        {
            requestProcessor.processHttpPost(body);
            return "doPost: request submitted, post body= "+body;
        }
        catch (final Exception e)
        {
            logger.error("doPost: exception=", e);
            return "doPost: exception="+e;
        }
    }
}
