/*****************************************************************************
 * Â© 2015 Avaya Inc. All rights reserved.
 ****************************************************************************/
package com.avaya.zephyr.services.sample_services.ClickToCall;

import static org.mockito.Mockito.mock;
import org.junit.Test;

public final class ClickToCallImplTest
{
    private static final String IDENTITY_ADDRESS = "3402@avaya.com";
    private static final String FIRST_PARTY = "3403";
    private static final String SECOND_PARTY = "3404";
    private static final String DISPLAY = "firstname,lastname";
    private ClickToCall clickToCallImpl;

    @Test
    public void makeCall_successful() throws Exception
    {
        clickToCallImpl = mock(ClickToCall.class);
        clickToCallImpl.makeCall(FIRST_PARTY, SECOND_PARTY, IDENTITY_ADDRESS,DISPLAY);
    }
    
    @Test
    public void makeCall_successfulWithNullDisplay() throws Exception
    {
        clickToCallImpl = mock(ClickToCall.class);
        clickToCallImpl.makeCall(FIRST_PARTY, SECOND_PARTY, IDENTITY_ADDRESS,null);
    }
}
