/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AgentDetails;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class AgentDetailsDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(AgentDetailsDAO.class);
    private static final String IPT_AGENT_LOGIN = "IPT_AGENT_LOGINID";
    private static final String GET_AGENT_DETAILS = "SELECT CSUSER.ID AS USERID, IPT_EXTENSION.CM_ID AS CMID, IPT_AGENT_LOGINID.ID AS AGENTID, CSCOMMPROFILESET.ID AS COMMPROFILESETID, IPT_EXTENSION.EXTENSION AS AGENTEXTENSION, IPT_EXTENSION.ID AS EXTENSIONID FROM CSCOMMPROFILESET, CSCOMMPROFILE, CMCOMMPROFILE, IPT_AGENT_LOGINID, IPT_EXTENSION, CSUSER WHERE CSCOMMPROFILESET.ID=CSCOMMPROFILE.CSCOMMPROFILESETID AND CSCOMMPROFILE.ID=CMCOMMPROFILE.ID AND CMCOMMPROFILE.AGENT_ID=IPT_AGENT_LOGINID.ID AND IPT_AGENT_LOGINID.LOGINIDEXT_ID=IPT_EXTENSION.ID AND CSCOMMPROFILESET.CSUSERID=CSUSER.ID";
    private static final String GET_AGENT_DETAILS_BY_AGENT_ID = "SELECT CSUSER.ID AS USERID, IPT_EXTENSION.CM_ID AS CMID, IPT_AGENT_LOGINID.ID AS AGENTID, CSCOMMPROFILESET.ID AS COMMPROFILESETID, IPT_EXTENSION.EXTENSION AS AGENTEXTENSION, IPT_EXTENSION.ID AS EXTENSIONID FROM CSCOMMPROFILESET, CSCOMMPROFILE, CMCOMMPROFILE, IPT_AGENT_LOGINID, IPT_EXTENSION, CSUSER WHERE CSCOMMPROFILESET.ID=CSCOMMPROFILE.CSCOMMPROFILESETID AND CSCOMMPROFILE.ID=CMCOMMPROFILE.ID AND CMCOMMPROFILE.AGENT_ID=IPT_AGENT_LOGINID.ID AND IPT_AGENT_LOGINID.LOGINIDEXT_ID=IPT_EXTENSION.ID AND CSCOMMPROFILESET.CSUSERID=CSUSER.ID AND IPT_AGENT_LOGINID.ID=?";
    private Map<Long, List<AgentDetails>> userIdToAgentDetailsMap = new ConcurrentHashMap<Long, List<AgentDetails>>();

    protected final ResultSetMapper getAgentDetailsMapperByAgentId() {
        return new ResultSetMapper(){

            public AgentDetails mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    AgentDetails agentDetails = new AgentDetails(results.getLong("AGENTID"), results.getString("AGENTEXTENSION"), results.getLong("USERID"));
                    return agentDetails;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map userIdToAgentDetailsMapTmp;
        AgentDetailsMapper agentDetailsMapper = new AgentDetailsMapper();
        try {
            Object[] params = new Object[]{};
            userIdToAgentDetailsMapTmp = (Map)this.dataSource.executeQuery(GET_AGENT_DETAILS, params, (Object)agentDetailsMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (userIdToAgentDetailsMapTmp != null) {
                this.userIdToAgentDetailsMap = userIdToAgentDetailsMapTmp;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList("ipt_agent_loginid");
    }

    protected Object getMainCollection() {
        return this.userIdToAgentDetailsMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Agent DAO event: " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null && tableName.equalsIgnoreCase(IPT_AGENT_LOGIN)) {
            this.updateIptAgent(operation, id);
        }
    }

    private void updateIptAgent(DAOReplicationEvent.OperationType operation, Long id) {
        AgentDetails oldObject = null;
        AgentDetails newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            oldObject = this.handleIptAgentDelete(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            newObject = this.handleIptAgentUpdate(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            newObject = this.handleIptAgentInsert(id);
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentDetails handleIptAgentInsert(Long id) {
        AgentDetails newObject;
        block8: {
            newObject = null;
            try {
                newObject = (AgentDetails)this.dataSource.executeQuery(GET_AGENT_DETAILS_BY_AGENT_ID, new Object[]{id}, (Object)this.getAgentDetailsMapperByAgentId());
                if (newObject == null) break block8;
                this.lock.acquireWriteLock();
                try {
                    List<AgentDetails> agents;
                    if (this.userIdToAgentDetailsMap == null) {
                        this.userIdToAgentDetailsMap = new ConcurrentHashMap<Long, List<AgentDetails>>();
                    }
                    if ((agents = this.userIdToAgentDetailsMap.get(newObject.getUserId())) == null || agents.isEmpty()) {
                        agents = new ArrayList<AgentDetails>();
                        agents.add(newObject);
                        this.userIdToAgentDetailsMap.put(newObject.getUserId(), agents);
                    } else {
                        agents.add(newObject);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table IPT_AGENT_LOGINID " + e.getMessage()));
            }
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentDetails handleIptAgentUpdate(Long id) {
        AgentDetails newObject;
        block7: {
            newObject = null;
            try {
                newObject = (AgentDetails)this.dataSource.executeQuery(GET_AGENT_DETAILS_BY_AGENT_ID, new Object[]{id}, (Object)this.getAgentDetailsMapperByAgentId());
                if (newObject == null) break block7;
                this.lock.acquireWriteLock();
                try {
                    List<AgentDetails> agents = this.userIdToAgentDetailsMap.get(newObject.getUserId());
                    if (agents != null) {
                        AgentDetails agentDetails = this.getDeletedHandle(id, agents);
                        if (agentDetails != null) {
                            agents.remove(agentDetails);
                        }
                        agents.add(newObject);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table IPT_AGENT_LOGINID " + e.getMessage()));
            }
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AgentDetails handleIptAgentDelete(Long id) {
        AgentDetails oldObject = null;
        try {
            this.lock.acquireWriteLock();
            for (List<AgentDetails> agents : this.userIdToAgentDetailsMap.values()) {
                oldObject = this.getDeletedHandle(id, agents);
                if (oldObject == null) continue;
                agents.remove(oldObject);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return oldObject;
    }

    private AgentDetails getDeletedHandle(Long id, List<AgentDetails> agents) {
        for (AgentDetails agentDetails : agents) {
            if (!agentDetails.getAgentId().equals(id)) continue;
            return agentDetails;
        }
        return null;
    }

    @SMConsole(description="Get agent extensions of user ID")
    public List<String> getAgentExtensions(Long userId) {
        ArrayList<String> agentExtensions = new ArrayList<String>();
        if (this.userIdToAgentDetailsMap.get(userId) == null || this.userIdToAgentDetailsMap.get(userId).isEmpty()) {
            return agentExtensions;
        }
        for (AgentDetails agentDetails : this.userIdToAgentDetailsMap.get(userId)) {
            if (StringUtils.isEmpty((CharSequence)agentDetails.getAgentExtension())) continue;
            agentExtensions.add(agentDetails.getAgentExtension());
        }
        return agentExtensions;
    }

    public static class AgentDetailsMapper
    implements ResultSetMapper {
        public Map<Long, List<AgentDetails>> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, List<AgentDetails>> userIdToAgentDetailsMapTmp = new ConcurrentHashMap<Long, List<AgentDetails>>();
            while (results.next()) {
                Long id = (Long)results.getObject("USERID");
                AgentDetails agentDetails = new AgentDetails(results.getLong("AGENTID"), results.getString("AGENTEXTENSION"), results.getLong("USERID"));
                ArrayList<AgentDetails> agents = (ArrayList<AgentDetails>)userIdToAgentDetailsMapTmp.get(id);
                if (agents == null || agents.isEmpty()) {
                    agents = new ArrayList<AgentDetails>();
                    agents.add(agentDetails);
                    userIdToAgentDetailsMapTmp.put(id, agents);
                    continue;
                }
                agents.add(agentDetails);
            }
            if (!userIdToAgentDetailsMapTmp.isEmpty()) {
                return userIdToAgentDetailsMapTmp;
            }
            return null;
        }
    }
}

