/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusBackupRestoreData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AusBackupRestoreDAO
extends DataAccessObject {
    protected static final Logger logger = Logger.getLogger(AusBackupRestoreDAO.class);
    protected static final String BACKUP_RESTORE_TABLE = "zr_backuprestore";
    protected static final String ID = "id";
    protected static final String CLUSTER_NAME = "cluster_name";
    protected static final String OPERATION = "operation";
    protected static final String REQUESTED_TIME = "requested_time";
    protected static final String INITIATED_TIME = "initiated_time";
    protected static final String COMPLETED_TIME = "completed_time";
    protected static final String LAST_STATUS_TIME = "last_status_time";
    protected static final String DB_NAME = "db_name";
    protected static final String SERVICE_NAME = "service_name";
    protected static final String SCHEMA_VERSION = "schema_version";
    protected static final String SIZE = "size";
    protected static final String STATUS = "status";
    protected static final String DISPOSITION = "disposition";
    protected static final String FILE_NAME = "file_name";
    protected static final String PATH_ON_SERVER = "path_on_server";
    protected static final String BACKUP_CLUSTER = "backup_cluster";
    protected static final String ENCRYPTION_KEY = "encryptionkey";
    protected static final String BACKUP_FORMAT = "backup_format";
    protected static final String DUMP_FORMAT = "dump_format";
    protected static final String GET_BACKUP_RESTORE_DATA = "SELECT br.id, br.cluster_name, br.operation, br.requested_time, br.initiated_time, br.completed_time, br.last_status_time, br.db_name, br.service_name, br.schema_version, br.size, br.status, br.disposition, br.file_name, br.path_on_server, br.backup_cluster, br.encryptionkey, br.backup_format, br.dump_format from zr_backuprestore br";
    protected static final String GET_BACKUP_RESTORE_DATA_BY_ID = "SELECT br.id, br.cluster_name, br.operation, br.requested_time, br.initiated_time, br.completed_time, br.last_status_time, br.db_name, br.service_name, br.schema_version, br.size, br.status, br.disposition, br.file_name, br.path_on_server, br.backup_cluster, br.encryptionkey, br.backup_format, br.dump_format from zr_backuprestore br  WHERE br.id= ?";
    private Map<Long, AusBackupRestoreData> idToAusBackupRestoreMap = new ConcurrentHashMap<Long, AusBackupRestoreData>();

    public AusBackupRestoreDAO() {
        super(true);
    }

    public List<String> getDependentTables() {
        return Arrays.asList(BACKUP_RESTORE_TABLE);
    }

    public Map<Long, AusBackupRestoreData> getIdToServiceBackupRestoreMap() {
        return this.idToAusBackupRestoreMap;
    }

    protected Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent daoTableEvent) {
        String tableName = daoTableEvent.getTableName();
        Long id = daoTableEvent.getKey();
        DAOReplicationEvent.OperationType operation = daoTableEvent.getOperation();
        AusBackupRestoreData newData = null;
        if (logger.isFineEnabled()) {
            logger.fine((Object)("updateDAO: table = " + tableName + " operation = " + operation + " event = " + daoTableEvent));
        }
        AusBackupRestoreData oldObject = null;
        AusBackupRestoreData newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            try {
                logger.fine((Object)"The InsertOperation is invoked\n");
                newData = (AusBackupRestoreData)this.dataSource.executeQuery(GET_BACKUP_RESTORE_DATA_BY_ID, new Object[]{id}, (Object)this.getServiceNotificationDataMapperById());
                try {
                    this.lock.acquireWriteLock();
                    this.idToAusBackupRestoreMap.put(id, newData);
                    oldObject = null;
                    newObject = newData;
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                logger.error((Object)("updateDAO :Exception while inserting new entry to DAO for change in table zr_backuprestore For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
            }
        } else if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            try {
                logger.fine((Object)"The UpdateOperation is invoked\n");
                newData = (AusBackupRestoreData)this.dataSource.executeQuery(GET_BACKUP_RESTORE_DATA_BY_ID, new Object[]{id}, (Object)this.getServiceNotificationDataMapperById());
                try {
                    this.lock.acquireWriteLock();
                    oldObject = this.idToAusBackupRestoreMap.put(id, newData);
                    newObject = newData;
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                logger.error((Object)("updateDAO :Exception while updating DAO for change in table zr_backuprestore For id=" + id + " Exception:" + e.getMessage()));
                this.reinit();
            }
        } else if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            oldObject = this.idToAusBackupRestoreMap.remove(id);
            newObject = null;
        }
        this.updateListeners(oldObject, newObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateListeners(Object oldObj, Object newObj) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        logger.fine((Object)("Inside Update Listeners : Service Listeners List ######" + this.getListeners() + "and the SERVICE_LISTENER_SIZE is =  " + this.getListeners().size()));
        for (DMListener listener : this.getListeners()) {
            try {
                Thread.currentThread().setContextClassLoader(listener.getClass().getClassLoader());
                logger.fine((Object)("AusBackupRestoreDAO : updateListeners() : The Current Listener is :" + listener));
                if (oldObj != null) {
                    logger.fine((Object)("---OldObj is----" + oldObj.getClass().getSimpleName()));
                }
                if (newObj != null) {
                    logger.fine((Object)("---NewObj is----" + newObj.getClass().getSimpleName()));
                }
                listener.objectChanged(oldObj, newObj);
            }
            catch (Exception e) {
                logger.error((Object)("Exception on invoking objectChanged on " + listener + " from " + ((Object)((Object)this)).getClass().getName()));
                logger.error((Object)"Exception is: ", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map tempIdToAusBackupRestoreDataMap;
        ServiceNotificationDataMapper serviceNotificationDataMapper = new ServiceNotificationDataMapper();
        logger.fine((Object)("The srvNotificationDataMapper obj is :" + serviceNotificationDataMapper));
        try {
            tempIdToAusBackupRestoreDataMap = (Map)this.dataSource.executeQuery(GET_BACKUP_RESTORE_DATA, new Object[0], (Object)serviceNotificationDataMapper);
            logger.fine((Object)("The tempMap is :" + tempIdToAusBackupRestoreDataMap));
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            logger.error((Object)("init(): Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.lock.acquireWriteLock();
        try {
            this.idToAusBackupRestoreMap = tempIdToAusBackupRestoreDataMap;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.setStatus(DataMgr.Status.OKAY);
    }

    protected final ResultSetMapper getServiceNotificationDataMapperById() {
        return new ResultSetMapper(){

            public AusBackupRestoreData mapResults(ResultSet resultSet) throws SQLException, DMException {
                AusBackupRestoreData result = null;
                while (resultSet.next()) {
                    try {
                        result = new AusBackupRestoreData(resultSet.getLong(AusBackupRestoreDAO.ID), resultSet.getString(AusBackupRestoreDAO.CLUSTER_NAME), resultSet.getString(AusBackupRestoreDAO.OPERATION), resultSet.getString(AusBackupRestoreDAO.REQUESTED_TIME), resultSet.getString(AusBackupRestoreDAO.INITIATED_TIME), resultSet.getString(AusBackupRestoreDAO.COMPLETED_TIME), resultSet.getString(AusBackupRestoreDAO.LAST_STATUS_TIME), resultSet.getString(AusBackupRestoreDAO.DB_NAME), resultSet.getString(AusBackupRestoreDAO.SERVICE_NAME), resultSet.getString(AusBackupRestoreDAO.SCHEMA_VERSION), resultSet.getString(AusBackupRestoreDAO.SIZE), resultSet.getString(AusBackupRestoreDAO.STATUS), resultSet.getString(AusBackupRestoreDAO.DISPOSITION), resultSet.getString(AusBackupRestoreDAO.FILE_NAME), resultSet.getString(AusBackupRestoreDAO.PATH_ON_SERVER), resultSet.getString(AusBackupRestoreDAO.BACKUP_CLUSTER), resultSet.getString(AusBackupRestoreDAO.ENCRYPTION_KEY), resultSet.getString(AusBackupRestoreDAO.BACKUP_FORMAT), resultSet.getString(AusBackupRestoreDAO.DUMP_FORMAT));
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage());
                    }
                }
                return result;
            }
        };
    }

    @SMConsole(description="Returns the list of map which contains the cluster names and their corresponding DB names")
    public Map<String, String> getDBNameByClusterName(String clusterName) {
        if (clusterName == null) {
            throw new IllegalArgumentException("component name cannot be null/empty");
        }
        HashMap<String, String> dbNames = new HashMap<String, String>();
        if (!this.idToAusBackupRestoreMap.isEmpty()) {
            for (AusBackupRestoreData data : this.idToAusBackupRestoreMap.values()) {
                if (!clusterName.equalsIgnoreCase(data.getClusterName())) continue;
                dbNames.put(data.getClusterName(), data.getDbName());
            }
        }
        return dbNames;
    }

    static class ServiceNotificationDataMapper
    implements ResultSetMapper {
        ServiceNotificationDataMapper() {
        }

        public Map<Long, AusBackupRestoreData> mapResults(ResultSet resultSet) throws SQLException, DMException {
            ConcurrentHashMap<Long, AusBackupRestoreData> map = new ConcurrentHashMap<Long, AusBackupRestoreData>();
            while (resultSet.next()) {
                Long id = resultSet.getLong(AusBackupRestoreDAO.ID);
                AusBackupRestoreData serviceNotificationData = null;
                try {
                    serviceNotificationData = new AusBackupRestoreData(id, resultSet.getString(AusBackupRestoreDAO.CLUSTER_NAME), resultSet.getString(AusBackupRestoreDAO.OPERATION), resultSet.getString(AusBackupRestoreDAO.REQUESTED_TIME), resultSet.getString(AusBackupRestoreDAO.INITIATED_TIME), resultSet.getString(AusBackupRestoreDAO.COMPLETED_TIME), resultSet.getString(AusBackupRestoreDAO.LAST_STATUS_TIME), resultSet.getString(AusBackupRestoreDAO.DB_NAME), resultSet.getString(AusBackupRestoreDAO.SERVICE_NAME), resultSet.getString(AusBackupRestoreDAO.SCHEMA_VERSION), resultSet.getString(AusBackupRestoreDAO.SIZE), resultSet.getString(AusBackupRestoreDAO.STATUS), resultSet.getString(AusBackupRestoreDAO.DISPOSITION), resultSet.getString(AusBackupRestoreDAO.FILE_NAME), resultSet.getString(AusBackupRestoreDAO.PATH_ON_SERVER), resultSet.getString(AusBackupRestoreDAO.BACKUP_CLUSTER), resultSet.getString(AusBackupRestoreDAO.ENCRYPTION_KEY), resultSet.getString(AusBackupRestoreDAO.BACKUP_FORMAT), resultSet.getString(AusBackupRestoreDAO.DUMP_FORMAT));
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                }
                map.put(id, serviceNotificationData);
            }
            return map;
        }
    }
}

