/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.AusJDBCProvider;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class AusExtJDBCProviderDAO
extends DataAccessObject {
    protected static final Logger LOGGER = Logger.getLogger(AusExtJDBCProviderDAO.class);
    protected static final String ZR_EXT_JDBC_PROVIDER = "zr_ext_jdbc_provider";
    protected static final String GET_ALLJDBC_PROVIDRS_QUERY = "select id, name_version, impl_class_name, driver_lib_path, sversion_id,custom_properties, description from zr_ext_jdbc_provider";
    protected static final String GET_JDBC_PROVIDRBYID_QUERY = "select id, name_version, impl_class_name, driver_lib_path, sversion_id,custom_properties, description from zr_ext_jdbc_provider where id = ?";
    private Map<String, AusJDBCProvider> jdbcProviderMap;
    private Map<Long, String> jdbcProviderIdToNameMap;

    public AusExtJDBCProviderDAO() {
        super(true);
    }

    public final List<String> getDependentTables() {
        return Arrays.asList(ZR_EXT_JDBC_PROVIDER);
    }

    protected final Object getMainCollection() {
        return null;
    }

    protected final ResultSetMapper getJDBCProviderDataMapper() {
        ResultSetMapper jdbcProviderDataMapper = new ResultSetMapper(){

            public Map<String, AusJDBCProvider> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<String, AusJDBCProvider> map = new ConcurrentHashMap<String, AusJDBCProvider>();
                while (results.next()) {
                    map.put(results.getString("name_version"), new AusJDBCProvider(results.getLong("id"), results.getLong("sversion_id"), results.getString("name_version"), results.getString("impl_class_name"), results.getString("driver_lib_path"), results.getString("custom_properties"), results.getString("description")));
                }
                return map;
            }
        };
        return jdbcProviderDataMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void init() {
        Map<Long, String> jdbcProviderIdToNameMapTmp;
        Map jdbcProviderDataMapTmp;
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"init ENTER");
        }
        try {
            jdbcProviderDataMapTmp = (Map)this.dataSource.executeQuery(GET_ALLJDBC_PROVIDRS_QUERY, new Object[0], (Object)this.getJDBCProviderDataMapper());
            jdbcProviderIdToNameMapTmp = this.prepareIdToNameMap(jdbcProviderDataMapTmp);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            LOGGER.error((Object)"init Error initializing AusExtJDBCProviderDAO", (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.jdbcProviderMap = jdbcProviderDataMapTmp;
            this.jdbcProviderIdToNameMap = jdbcProviderIdToNameMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        if (LOGGER.isFinerEnabled()) {
            LOGGER.finer((Object)"init EXIT");
        }
    }

    private Map<Long, String> prepareIdToNameMap(Map<String, AusJDBCProvider> jdbcProviderDataMapTmp) {
        ConcurrentHashMap<Long, String> jdbcIdToNameMap = new ConcurrentHashMap<Long, String>();
        for (AusJDBCProvider ausJDBCProvider : jdbcProviderDataMapTmp.values()) {
            jdbcIdToNameMap.put(ausJDBCProvider.getId(), ausJDBCProvider.getNameVersion());
        }
        return jdbcIdToNameMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateDAO(DAOTableEvent event) {
        Long id = event.getKey();
        AusJDBCProvider oldEntry = null;
        AusJDBCProvider newEntry = null;
        if (event.getTableName().equals(ZR_EXT_JDBC_PROVIDER) && event.getOperation() != null) {
            block10: {
                try {
                    this.lock.acquireWriteLock();
                    if (event.getOperation().equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                        String jdbcName = this.jdbcProviderIdToNameMap.get(id);
                        oldEntry = this.jdbcProviderMap.get(jdbcName);
                        if (oldEntry != null) {
                            this.jdbcProviderMap.remove(jdbcName);
                            this.jdbcProviderIdToNameMap.remove(id);
                        }
                        break block10;
                    }
                    try {
                        Map updatedJdbcDataMap = (Map)this.dataSource.executeQuery(GET_JDBC_PROVIDRBYID_QUERY, new Object[]{id}, (Object)this.getJDBCProviderDataMapper());
                        if (updatedJdbcDataMap != null) {
                            Iterator iterator = updatedJdbcDataMap.values().iterator();
                            while (iterator.hasNext()) {
                                AusJDBCProvider ausJDBCProvider;
                                newEntry = ausJDBCProvider = (AusJDBCProvider)iterator.next();
                                oldEntry = this.jdbcProviderMap.put(ausJDBCProvider.getNameVersion(), ausJDBCProvider);
                                this.jdbcProviderIdToNameMap.put(ausJDBCProvider.getId(), ausJDBCProvider.getNameVersion());
                            }
                        }
                    }
                    catch (DMException e) {
                        LOGGER.error((Object)("Error while updating cache for change in table zr_ext_jdbc_provider For id=" + id + " Exception:" + e.getMessage()));
                        this.reinit();
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            this.updateListeners(oldEntry, newEntry);
        }
    }

    @SMConsole(description="Get JDBC Provider Information by provider name")
    public AusJDBCProvider getJDBCProviderInfoByName(String name) {
        return this.jdbcProviderMap.get(name);
    }

    @SMConsole(description="Get names of all the JDBC Providers")
    public Set<String> getAllJDBCProviderNames() {
        return this.jdbcProviderMap.keySet();
    }
}

