/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.CommunicationAddress;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class CommunicationAddressDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(CommunicationAddressDAO.class);
    private static final String CSDOMAIN = "CSDOMAIN";
    private static final String CSHANDLE = "CSHANDLE";
    private static final String GET_COMM_ADDRESSES = "SELECT CSUSER.ID as USERID, CSHANDLE.ID AS HANDLEID, CSHANDLE.HANDLE, CSDOMAIN.ID AS DOMIANID, CSHANDLE.CSHANDLESUBTYPEID, CSHANDLE.CSHANDLETYPEID, CSCOMMPROFILESET.ID AS CSCOMMPROFILESETID FROM CSUSER, CSCOMMPROFILESET, CSHANDLE, CSDOMAIN WHERE CSUSER.ID=CSCOMMPROFILESET.CSUSERID AND CSHANDLE.CSCOMMPROFILESETID=CSCOMMPROFILESET.ID AND CSHANDLE.CSDOMAINID=CSDOMAIN.ID";
    private static final String GET_COMM_ADDRESSES_BY_HANDLE_ID = "SELECT CSUSER.ID as USERID, CSHANDLE.ID AS HANDLEID, CSHANDLE.HANDLE, CSDOMAIN.ID AS DOMIANID, CSHANDLE.CSHANDLESUBTYPEID, CSHANDLE.CSHANDLETYPEID, CSCOMMPROFILESET.ID AS CSCOMMPROFILESETID FROM CSUSER, CSCOMMPROFILESET, CSHANDLE, CSDOMAIN WHERE CSUSER.ID=CSCOMMPROFILESET.CSUSERID AND CSHANDLE.CSCOMMPROFILESETID=CSCOMMPROFILESET.ID AND CSHANDLE.CSDOMAINID=CSDOMAIN.ID AND CSHANDLE.ID=?";
    private static final String GET_DOMAINS_BY_ID = "SELECT ID, DOMAINNAME FROM CSDOMAIN WHERE ID=?";
    private static final String GET_DOMAINS = "SELECT ID, DOMAINNAME FROM CSDOMAIN";
    private Map<Long, List<CommunicationAddress>> userIdTocommAddressMap = new ConcurrentHashMap<Long, List<CommunicationAddress>>();
    private Map<Long, String> domains = new ConcurrentHashMap<Long, String>();

    protected final ResultSetMapper getCommunicationAddressMapperByHandleId() {
        return new ResultSetMapper(){

            public CommunicationAddress mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    CommunicationAddress commAddress = new CommunicationAddress(results.getLong("HANDLEID"), results.getString("HANDLE"), results.getLong("USERID"), results.getLong("DOMIANID"));
                    return commAddress;
                }
                return null;
            }
        };
    }

    protected ResultSetMapper getDomainMapper() {
        return new ResultSetMapper(){

            public Map<Long, String> mapResults(ResultSet results) throws SQLException, DMException {
                HashMap<Long, String> domainsTmp = new HashMap<Long, String>();
                while (results.next()) {
                    domainsTmp.put(results.getLong("ID"), results.getString("DOMAINNAME"));
                }
                if (!domainsTmp.isEmpty()) {
                    return domainsTmp;
                }
                return null;
            }
        };
    }

    protected final ResultSetMapper getDomainMapperByID() {
        return new ResultSetMapper(){

            public String mapResults(ResultSet results) throws SQLException, DMException {
                while (results.next()) {
                    if (results.getString("DOMAINNAME") == null) continue;
                    return results.getString("DOMAINNAME");
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map domainsTmp;
        Map userIdTocommAddressMapTmp;
        CommunicationAddressMapper commAddressMapper = new CommunicationAddressMapper();
        try {
            Object[] params = new Object[]{};
            userIdTocommAddressMapTmp = (Map)this.dataSource.executeQuery(GET_COMM_ADDRESSES, params, (Object)commAddressMapper);
            domainsTmp = (Map)this.dataSource.executeQuery(GET_DOMAINS, params, (Object)this.getDomainMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (userIdTocommAddressMapTmp != null) {
                this.userIdTocommAddressMap = userIdTocommAddressMapTmp;
            }
            if (domainsTmp != null) {
                this.domains = domainsTmp;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList("csdomain", "cshandle");
    }

    protected Object getMainCollection() {
        return this.userIdTocommAddressMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Communication Address DAO event: " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null) {
            if (tableName.equalsIgnoreCase(CSHANDLE)) {
                this.updateCsHandle(operation, id);
            }
            if (tableName.equalsIgnoreCase(CSDOMAIN)) {
                this.updateDomain(operation, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDomain(DAOReplicationEvent.OperationType operation, Long id) {
        String newObject;
        String oldObject;
        block12: {
            oldObject = null;
            newObject = null;
            if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                try {
                    this.lock.acquireWriteLock();
                    oldObject = this.domains.remove(id);
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE) || operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
                try {
                    newObject = (String)this.dataSource.executeQuery(GET_DOMAINS_BY_ID, new Object[]{id}, (Object)this.getDomainMapperByID());
                    if (newObject == null) break block12;
                    this.lock.acquireWriteLock();
                    try {
                        this.domains.put(id, newObject);
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                catch (DMException e) {
                    this.log.error((Object)("Error while updating Cache for table CSDOMAIN " + e.getMessage()));
                }
            }
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCsHandle(DAOReplicationEvent.OperationType operation, Long id) {
        CommunicationAddress newObject;
        CommunicationAddress oldObject;
        block11: {
            oldObject = null;
            newObject = null;
            if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                oldObject = this.handleCSHandleDelete(id);
            }
            if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
                try {
                    newObject = (CommunicationAddress)this.dataSource.executeQuery(GET_COMM_ADDRESSES_BY_HANDLE_ID, new Object[]{id}, (Object)this.getCommunicationAddressMapperByHandleId());
                    if (newObject == null) break block11;
                    this.lock.acquireWriteLock();
                    try {
                        List<CommunicationAddress> handleToCommAddressList = this.userIdTocommAddressMap.get(newObject.getUserId());
                        if (handleToCommAddressList != null) {
                            oldObject = this.getDeletedHandle(id, handleToCommAddressList);
                            if (oldObject != null) {
                                handleToCommAddressList.remove(oldObject);
                            }
                            handleToCommAddressList.add(newObject);
                        }
                    }
                    finally {
                        this.lock.releaseWriteLock();
                    }
                }
                catch (DMException e) {
                    this.log.error((Object)("Error while updating Cache for table CSDOMAIN " + e.getMessage()));
                }
            }
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            newObject = this.handleCSHandleInsert(id);
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommunicationAddress handleCSHandleInsert(Long id) {
        CommunicationAddress newObject;
        block7: {
            newObject = null;
            try {
                newObject = (CommunicationAddress)this.dataSource.executeQuery(GET_COMM_ADDRESSES_BY_HANDLE_ID, new Object[]{id}, (Object)this.getCommunicationAddressMapperByHandleId());
                if (newObject == null) break block7;
                this.lock.acquireWriteLock();
                try {
                    List<CommunicationAddress> handleToCommAddresses = this.userIdTocommAddressMap.get(newObject.getUserId());
                    if (handleToCommAddresses == null || handleToCommAddresses.isEmpty()) {
                        handleToCommAddresses = new ArrayList<CommunicationAddress>();
                        handleToCommAddresses.add(newObject);
                        this.userIdTocommAddressMap.put(newObject.getUserId(), handleToCommAddresses);
                    } else {
                        handleToCommAddresses.add(newObject);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table CSDOMAIN " + e.getMessage()));
            }
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommunicationAddress handleCSHandleDelete(Long id) {
        CommunicationAddress oldObject = null;
        try {
            this.lock.acquireWriteLock();
            for (List<CommunicationAddress> handleTocommAddress : this.userIdTocommAddressMap.values()) {
                oldObject = this.getDeletedHandle(id, handleTocommAddress);
                if (oldObject == null) continue;
                handleTocommAddress.remove(oldObject);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return oldObject;
    }

    private CommunicationAddress getDeletedHandle(Long id, List<CommunicationAddress> handleTocommAddress) {
        for (CommunicationAddress commAddress : handleTocommAddress) {
            if (!commAddress.getHandleId().equals(id)) continue;
            return commAddress;
        }
        return null;
    }

    @SMConsole(description="Get comm addresses of user ID")
    public List<String> getCommAddresses(Long userId) {
        ArrayList<String> commAddresses = new ArrayList<String>();
        if (this.userIdTocommAddressMap.get(userId) == null || this.userIdTocommAddressMap.get(userId).isEmpty()) {
            return commAddresses;
        }
        for (CommunicationAddress commAddress : this.userIdTocommAddressMap.get(userId)) {
            if (StringUtils.isEmpty((CharSequence)commAddress.getHandleName())) continue;
            if (commAddress.getDomainId() != null && this.domains != null && !StringUtils.isEmpty((CharSequence)this.domains.get(commAddress.getDomainId())) && !"__foreign__".equalsIgnoreCase(this.domains.get(commAddress.getDomainId()))) {
                commAddresses.add(commAddress.getHandleName() + "@" + this.domains.get(commAddress.getDomainId()));
                continue;
            }
            commAddresses.add(commAddress.getHandleName());
        }
        return commAddresses;
    }

    public static class CommunicationAddressMapper
    implements ResultSetMapper {
        public Map<Long, List<CommunicationAddress>> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, List<CommunicationAddress>> userIdTocommAddressMapTmp = new ConcurrentHashMap<Long, List<CommunicationAddress>>();
            while (results.next()) {
                Long id = (Long)results.getObject("USERID");
                CommunicationAddress commAddress = new CommunicationAddress(results.getLong("HANDLEID"), results.getString("HANDLE"), results.getLong("USERID"), results.getLong("DOMIANID"));
                ArrayList<CommunicationAddress> commAddresses = (ArrayList<CommunicationAddress>)userIdTocommAddressMapTmp.get(id);
                if (commAddresses == null || commAddresses.isEmpty()) {
                    commAddresses = new ArrayList<CommunicationAddress>();
                    commAddresses.add(commAddress);
                    userIdTocommAddressMapTmp.put(id, commAddresses);
                    continue;
                }
                commAddresses.add(commAddress);
            }
            if (!userIdTocommAddressMapTmp.isEmpty()) {
                return userIdTocommAddressMapTmp;
            }
            return null;
        }
    }
}

