/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.HttpCorsEntry;
import com.avaya.zephyr.platform.dao.HttpCorsByClusterDAO;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import com.avaya.zephyr.platform.dm.utilities.RunHttpCorsFile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HttpCorsDAO
extends DataAccessObject {
    private Map<Long, HttpCorsEntry> httpCorsMap;
    private static final Logger log = AsmLogger.getLogger(HttpCorsDAO.class);
    protected static final String ZR_HTTP_CORS = "zr_http_cors";
    private final String getHttpCorsEntries = "SELECT id, fqdn_or_ip From zr_http_cors";
    private final String getHttpCorsEntryById = "SELECT id, fqdn_or_ip From zr_http_cors where id = ?";
    private List<DMListener> listeners = new ArrayList<DMListener>();

    public Map<Long, HttpCorsEntry> getHttpCorsMap() {
        return this.httpCorsMap;
    }

    public List<DMListener> getListeners() {
        return this.listeners;
    }

    public String getGetHttpCorsEntries() {
        return "SELECT id, fqdn_or_ip From zr_http_cors";
    }

    public String getGetHttpCorsEntryById() {
        return "SELECT id, fqdn_or_ip From zr_http_cors where id = ?";
    }

    public void init() {
        Map httpCorsMapTmp;
        try {
            httpCorsMapTmp = (Map)this.dataSource.executeQuery("SELECT id, fqdn_or_ip From zr_http_cors", new Object[0], (Object)this.httpCorsEntriesMapper());
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            this.httpCorsMap = httpCorsMapTmp;
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.updateEntriesInFile();
    }

    protected ResultSetMapper httpCorsEntriesMapper() {
        return new ResultSetMapper(){

            public Map<Long, HttpCorsEntry> mapResults(ResultSet results) throws SQLException, DMException {
                ConcurrentHashMap<Long, HttpCorsEntry> map = new ConcurrentHashMap<Long, HttpCorsEntry>();
                while (results.next()) {
                    map.put(results.getLong("id"), new HttpCorsEntry(results.getLong("id"), results.getString("fqdn_or_ip")));
                }
                return map;
            }
        };
    }

    protected ResultSetMapper httpCorsEntryMapperById() {
        return new ResultSetMapper(){

            public HttpCorsEntry mapResults(ResultSet results) throws SQLException, DMException {
                HttpCorsEntry entry = null;
                while (results.next()) {
                    entry = new HttpCorsEntry(results.getLong("id"), results.getString("fqdn_or_ip"));
                }
                return entry;
            }
        };
    }

    public List<String> getDependentTables() {
        return Arrays.asList(ZR_HTTP_CORS);
    }

    protected Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDAO(DAOTableEvent tableEvent) {
        Long id = tableEvent.getKey();
        HttpCorsEntry oldEntry = null;
        HttpCorsEntry newEntry = null;
        if (tableEvent.getTableName().equals(ZR_HTTP_CORS) && tableEvent.getOperation() != null) {
            try {
                this.lock.acquireWriteLock();
                if (tableEvent.getOperation().equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
                    oldEntry = this.httpCorsMap.get(id);
                    this.httpCorsMap.remove(id);
                } else {
                    try {
                        newEntry = (HttpCorsEntry)this.dataSource.executeQuery("SELECT id, fqdn_or_ip From zr_http_cors where id = ?", new Object[]{id}, (Object)this.httpCorsEntryMapperById());
                        this.httpCorsMap.put(id, newEntry);
                    }
                    catch (DMException e) {
                        log.error((Object)("Error while updating cache for change in table zr_http_cors For id=" + id + " Exception:" + e.getMessage()));
                        this.reinit();
                    }
                }
            }
            finally {
                this.lock.releaseWriteLock();
            }
            if (oldEntry != null || newEntry != null) {
                this.updateEntriesInFile();
            }
        }
    }

    protected void updateEntriesInFile() {
        RunHttpCorsFile runTask = new RunHttpCorsFile();
        runTask.run();
    }

    @SMConsole(description="Get the list of Http Cors Entries")
    public List<String> getHttpCorsList() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            this.lock.acquireReadLock();
            HttpCorsByClusterDAO httpCorsByClusterDAO = this.getHttpCorsByClusterDAO();
            httpCorsByClusterDAO.getHttpCorsListForEDPCluster();
            list.addAll(httpCorsByClusterDAO.getHttpCorsListForEDPCluster());
        }
        finally {
            this.lock.releaseReadLock();
        }
        return list;
    }

    protected HttpCorsByClusterDAO getHttpCorsByClusterDAO() {
        ZephyrDM dm = (ZephyrDM)DMFactory.getInstance().getDataMgr(ZephyrDM.class);
        return dm.getHttpCorsByClusterDAO();
    }
}

