/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dao;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.objectapi.StationDetails;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class StationDetailsDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(StationDetailsDAO.class);
    private static final String IPT_STATION = "IPT_STATION";
    private static final String GET_STATION_DETAILS = "SELECT CSUSER.ID AS USERID, CSCOMMPROFILESET.ID AS COMMPROFILESETID, IPT_EXTENSION.EXTENSION AS STATIONEXTENSION, IPT_EXTENSION.ID AS EXTENSIONID, IPT_EXTENSION.CM_ID AS CMID, IPT_STATION.ID AS STATIONID FROM CSCOMMPROFILESET, CSCOMMPROFILE, CMCOMMPROFILE, IPT_STATION, IPT_EXTENSION, CSUSER WHERE CSCOMMPROFILESET.ID=CSCOMMPROFILE.CSCOMMPROFILESETID AND CSCOMMPROFILE.ID=CMCOMMPROFILE.ID AND CMCOMMPROFILE.STATION_ID=IPT_STATION.ID AND IPT_STATION.EXTENSION_ID=IPT_EXTENSION.ID AND CSCOMMPROFILESET.CSUSERID=CSUSER.ID";
    private static final String GET_STATION_DETAILS_BY_STATION_ID = "SELECT CSUSER.ID AS USERID, CSCOMMPROFILESET.ID AS COMMPROFILESETID, IPT_EXTENSION.EXTENSION AS STATIONEXTENSION, IPT_EXTENSION.ID AS EXTENSIONID, IPT_EXTENSION.CM_ID AS CMID, IPT_STATION.ID AS STATIONID FROM CSCOMMPROFILESET, CSCOMMPROFILE, CMCOMMPROFILE, IPT_STATION, IPT_EXTENSION, CSUSER WHERE CSCOMMPROFILESET.ID=CSCOMMPROFILE.CSCOMMPROFILESETID AND CSCOMMPROFILE.ID=CMCOMMPROFILE.ID AND CMCOMMPROFILE.STATION_ID=IPT_STATION.ID AND IPT_STATION.EXTENSION_ID=IPT_EXTENSION.ID AND CSCOMMPROFILESET.CSUSERID=CSUSER.ID AND IPT_STATION.ID=?";
    private Map<Long, List<StationDetails>> userIdToStationDetailsMap = new ConcurrentHashMap<Long, List<StationDetails>>();

    protected final ResultSetMapper getStationDetailsMapperByStationId() {
        return new ResultSetMapper(){

            public StationDetails mapResults(ResultSet results) throws SQLException, DMException {
                if (results.next()) {
                    StationDetails stationDetails = new StationDetails(results.getLong("STATIONID"), results.getString("STATIONEXTENSION"), results.getLong("USERID"));
                    return stationDetails;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Map userIdToStationDetailsMapTmp;
        StationDetailsMapper stationDetailsMapper = new StationDetailsMapper();
        try {
            Object[] params = new Object[]{};
            userIdToStationDetailsMapTmp = (Map)this.dataSource.executeQuery(GET_STATION_DETAILS, params, (Object)stationDetailsMapper);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + ((Object)((Object)this)).getClass().getSimpleName()), (Throwable)e);
            return;
        }
        this.setStatus(DataMgr.Status.OKAY);
        this.lock.acquireWriteLock();
        try {
            if (userIdToStationDetailsMapTmp != null) {
                this.userIdToStationDetailsMap = userIdToStationDetailsMapTmp;
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public List<String> getDependentTables() {
        return Arrays.asList("ipt_station");
    }

    protected Object getMainCollection() {
        return this.userIdToStationDetailsMap;
    }

    public void updateDAO(DAOTableEvent tableEvent) {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Station DAO event: " + tableEvent));
        }
        String tableName = tableEvent.getTableName();
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        Long id = tableEvent.getKey();
        if (operation != null && tableName.equalsIgnoreCase(IPT_STATION)) {
            this.updateIptStation(operation, id);
        }
    }

    private void updateIptStation(DAOReplicationEvent.OperationType operation, Long id) {
        StationDetails oldObject = null;
        StationDetails newObject = null;
        if (operation.equals((Object)DAOReplicationEvent.OperationType.DELETE)) {
            oldObject = this.handleIptStationDelete(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.UPDATE)) {
            newObject = this.handleIptStationUpdate(id);
        }
        if (operation.equals((Object)DAOReplicationEvent.OperationType.INSERT)) {
            newObject = this.handleIptStationInsert(id);
        }
        if (oldObject != null || newObject != null) {
            this.updateListeners(oldObject, newObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StationDetails handleIptStationInsert(Long id) {
        StationDetails newObject;
        block8: {
            newObject = null;
            try {
                newObject = (StationDetails)this.dataSource.executeQuery(GET_STATION_DETAILS_BY_STATION_ID, new Object[]{id}, (Object)this.getStationDetailsMapperByStationId());
                if (newObject == null) break block8;
                this.lock.acquireWriteLock();
                try {
                    List<StationDetails> stations;
                    if (this.userIdToStationDetailsMap == null) {
                        this.userIdToStationDetailsMap = new ConcurrentHashMap<Long, List<StationDetails>>();
                    }
                    if ((stations = this.userIdToStationDetailsMap.get(newObject.getUserId())) == null || stations.isEmpty()) {
                        stations = new ArrayList<StationDetails>();
                        stations.add(newObject);
                        this.userIdToStationDetailsMap.put(newObject.getUserId(), stations);
                    } else {
                        stations.add(newObject);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table IPT_STATION " + e.getMessage()));
            }
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StationDetails handleIptStationUpdate(Long id) {
        StationDetails newObject;
        block7: {
            newObject = null;
            try {
                newObject = (StationDetails)this.dataSource.executeQuery(GET_STATION_DETAILS_BY_STATION_ID, new Object[]{id}, (Object)this.getStationDetailsMapperByStationId());
                if (newObject == null) break block7;
                this.lock.acquireWriteLock();
                try {
                    List<StationDetails> stations = this.userIdToStationDetailsMap.get(newObject.getUserId());
                    if (stations != null) {
                        StationDetails stationDetails = this.getDeletedHandle(id, stations);
                        if (stationDetails != null) {
                            stations.remove(stationDetails);
                        }
                        stations.add(newObject);
                    }
                }
                finally {
                    this.lock.releaseWriteLock();
                }
            }
            catch (DMException e) {
                this.log.error((Object)("Error while updating Cache for table IPT_STATION " + e.getMessage()));
            }
        }
        return newObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StationDetails handleIptStationDelete(Long id) {
        StationDetails oldObject = null;
        try {
            this.lock.acquireWriteLock();
            for (List<StationDetails> stations : this.userIdToStationDetailsMap.values()) {
                oldObject = this.getDeletedHandle(id, stations);
                if (oldObject == null) continue;
                stations.remove(oldObject);
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
        return oldObject;
    }

    private StationDetails getDeletedHandle(Long id, List<StationDetails> stations) {
        for (StationDetails stationDetails : stations) {
            if (!stationDetails.getStationId().equals(id)) continue;
            return stationDetails;
        }
        return null;
    }

    @SMConsole(description="Get station extensions of user ID")
    public List<String> getStationExtensions(Long userId) {
        ArrayList<String> stationExtensions = new ArrayList<String>();
        if (this.userIdToStationDetailsMap.get(userId) == null || this.userIdToStationDetailsMap.get(userId).isEmpty()) {
            return stationExtensions;
        }
        for (StationDetails stationDetails : this.userIdToStationDetailsMap.get(userId)) {
            if (StringUtils.isEmpty((CharSequence)stationDetails.getStationExtension())) continue;
            stationExtensions.add(stationDetails.getStationExtension());
        }
        return stationExtensions;
    }

    public static class StationDetailsMapper
    implements ResultSetMapper {
        public Map<Long, List<StationDetails>> mapResults(ResultSet results) throws SQLException, DMException {
            ConcurrentHashMap<Long, List<StationDetails>> userIdToStationDetailsMapTmp = new ConcurrentHashMap<Long, List<StationDetails>>();
            while (results.next()) {
                Long id = (Long)results.getObject("USERID");
                StationDetails stationDetails = new StationDetails(results.getLong("STATIONID"), results.getString("STATIONEXTENSION"), results.getLong("USERID"));
                ArrayList<StationDetails> stations = (ArrayList<StationDetails>)userIdToStationDetailsMapTmp.get(id);
                if (stations == null || stations.isEmpty()) {
                    stations = new ArrayList<StationDetails>();
                    stations.add(stationDetails);
                    userIdToStationDetailsMapTmp.put(id, stations);
                    continue;
                }
                stations.add(stationDetails);
            }
            if (!userIdToStationDetailsMapTmp.isEmpty()) {
                return userIdToStationDetailsMapTmp;
            }
            return null;
        }
    }
}

