/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dm;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AppSetPatternDAO;
import com.avaya.asm.datamgr.dao.AusCommProfileDAO;
import com.avaya.asm.datamgr.dao.CsDomainDAO;
import com.avaya.asm.datamgr.objectapi.AppSetPattern;
import com.avaya.asm.datamgr.objectapi.AusCommProfile;
import com.avaya.asm.datamgr.objectapi.UserDomainAOR;
import com.avaya.collaboration.businessdata.api.AccessControlException;
import com.avaya.collaboration.businessdata.api.ClusterNotFoundException;
import com.avaya.collaboration.businessdata.api.InvalidAddressTypeException;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.NoServiceProfileFoundException;
import com.avaya.collaboration.businessdata.api.NoUserFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.data.api.AddressType;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.client.objects.UserStoreException;
import com.avaya.zephyr.encrypt.EncryptDecrypt;
import com.avaya.zephyr.platform.dal.api.objectapi.AusAttribute;
import com.avaya.zephyr.platform.dal.api.objectapi.AusClusterService;
import com.avaya.zephyr.platform.dal.api.objectapi.AusService;
import com.avaya.zephyr.platform.dal.api.objectapi.AusTemplate;
import com.avaya.zephyr.platform.dal.api.objectapi.AusTemplateService;
import com.avaya.zephyr.platform.dal.api.objectapi.ChannelSversion;
import com.avaya.zephyr.platform.dal.api.objectapi.ClusterDefaultAttribute;
import com.avaya.zephyr.platform.dal.api.objectapi.DefaultAttribute;
import com.avaya.zephyr.platform.dal.api.objectapi.DigitMapRow;
import com.avaya.zephyr.platform.dal.api.objectapi.NamedService;
import com.avaya.zephyr.platform.dao.AusAttributeDAO;
import com.avaya.zephyr.platform.dao.AusDigitMapRouterDAO;
import com.avaya.zephyr.platform.dao.AusExtJDBCDataSourceDAO;
import com.avaya.zephyr.platform.dao.AusExtJDBCProviderDAO;
import com.avaya.zephyr.platform.dao.AusServiceActivityDAO;
import com.avaya.zephyr.platform.dao.AusServiceDAO;
import com.avaya.zephyr.platform.dao.AusServiceLevelTLSVersionDAO;
import com.avaya.zephyr.platform.dao.AusServicePortsDataDAO;
import com.avaya.zephyr.platform.dao.AusServiceSdkDao;
import com.avaya.zephyr.platform.dao.AusTemplateDAO;
import com.avaya.zephyr.platform.dao.AusZangActivityDAO;
import com.avaya.zephyr.platform.dao.ChannelDAO;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;
import com.avaya.zephyr.platform.dao.TMConfDataDAO;
import com.avaya.zephyr.platform.dm.PlatformServiceDM;
import com.avaya.zephyr.platform.dm.ZephyrDM;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class AusPlatformServiceDM
extends BusinessLogicDM {
    private final Logger log = AsmLogger.getLogger(AusPlatformServiceDM.class);
    public static final String USTORE_SOURCE = "ustore";
    private static final Long GLOBAL_SERVICE_ID = 1L;
    private static DMFactory factory;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(AusDM.class);
    }

    public void init() {
        if (ZephyrDM.isMgmtServer()) {
            this.log.info((Object)"Skipping preload of DAOs on management server.");
            return;
        }
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (AusDM dm : AusDM.values()) {
            if (dm.get().okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + (Object)((Object)dm)));
        }
        this.setStatus(status);
    }

    public final AusServiceDAO getAusServiceDAO() {
        return (AusServiceDAO)this.getDataMgr(AusServiceDAO.class);
    }

    protected AusServiceSdkDao getAusServiceSdkDao() {
        return (AusServiceSdkDao)this.getDataMgr(AusServiceSdkDao.class);
    }

    protected ChannelDAO getChannelDAO() {
        return (ChannelDAO)this.getDataMgr(ChannelDAO.class);
    }

    protected AusCommProfileDAO getAusCommProfileDAO() {
        return (AusCommProfileDAO)this.getDataMgr(AusCommProfileDAO.class);
    }

    protected AusTemplateDAO getAusTemplateDAO() {
        return (AusTemplateDAO)this.getDataMgr(AusTemplateDAO.class);
    }

    protected AusAttributeDAO getAusAttributeDAO() {
        return (AusAttributeDAO)this.getDataMgr(AusAttributeDAO.class);
    }

    protected CsDomainDAO getCsDomainDAO() {
        return (CsDomainDAO)this.getDataMgr(CsDomainDAO.class);
    }

    protected AppSetPatternDAO getAppSetPatternDAO() {
        return (AppSetPatternDAO)this.getDataMgr(AppSetPatternDAO.class);
    }

    protected PlatformServiceDM getPlatformServiceDM() {
        return (PlatformServiceDM)this.getDataMgr(PlatformServiceDM.class);
    }

    public AusServiceActivityDAO getAusServiceActivityDAO() {
        return (AusServiceActivityDAO)this.getDataMgr(AusServiceActivityDAO.class);
    }

    public AusZangActivityDAO getAusZangActivityDAO() {
        return (AusZangActivityDAO)this.getDataMgr(AusZangActivityDAO.class);
    }

    public AusServicePortsDataDAO getAusServicePortsDataDAO() {
        return (AusServicePortsDataDAO)this.getDataMgr(AusServicePortsDataDAO.class);
    }

    public AusDigitMapRouterDAO getAusDigitMapRouterDAO() {
        return (AusDigitMapRouterDAO)this.getDataMgr(AusDigitMapRouterDAO.class);
    }

    public AusExtJDBCProviderDAO getAusExtJDBCProviderDAO() {
        return (AusExtJDBCProviderDAO)this.getDataMgr(AusExtJDBCProviderDAO.class);
    }

    public AusExtJDBCDataSourceDAO getAusExtJDBCDataSourceDAO() {
        return (AusExtJDBCDataSourceDAO)this.getDataMgr(AusExtJDBCDataSourceDAO.class);
    }

    public TMConfDataDAO getTMConfDataDAO() {
        return (TMConfDataDAO)this.getDataMgr(TMConfDataDAO.class);
    }

    public AusServiceLevelTLSVersionDAO getAusServiceLevelTLSVersionDAO() {
        return (AusServiceLevelTLSVersionDAO)this.getDataMgr(AusServiceLevelTLSVersionDAO.class);
    }

    protected ClusterAttributeDAO getClusterAttributeDao() {
        return (ClusterAttributeDAO)this.getDataMgr(ClusterAttributeDAO.class);
    }

    public AusAttribute getDRSOnlyAttribute(String uri, Long ausServiceId, String attrKey) {
        try {
            return this.getUStoreDRSAttribute(new UserDomainAOR(uri), ausServiceId, attrKey, false);
        }
        catch (UserStoreException e) {
            this.log.error((Object)("Caught unexpected exception for uri=" + uri + " ausServiceId=" + ausServiceId + " attrKey=" + attrKey), (Throwable)e);
            return null;
        }
    }

    public AusAttribute getDRSOnlyAttribute(String user, String domain, Long ausServiceId, String attrKey) {
        try {
            return this.getUStoreDRSAttribute(new UserDomainAOR(user, domain), ausServiceId, attrKey, false);
        }
        catch (UserStoreException e) {
            this.log.error((Object)("Caught unexpected exception for user=" + user + " domain=" + domain + " ausServiceId=" + ausServiceId + " attrKey=" + attrKey), (Throwable)e);
            return null;
        }
    }

    public AusAttribute getUStoreDRSAttribute(String uri, Long ausServiceId, String attrKey) throws UserStoreException {
        return this.getUStoreDRSAttribute(new UserDomainAOR(uri), ausServiceId, attrKey, null);
    }

    @SMConsole(description="Get the TemplateService-based Attribute based on the UStore first, then by the DRS if nothing was found.", parameterNames={"user", "domain", "ausServiceId", "attrKey"})
    public AusAttribute getUStoreDRSAttribute(String user, String domain, Long ausServiceId, String attrKey) throws UserStoreException {
        return this.getUStoreDRSAttribute(new UserDomainAOR(user, domain), ausServiceId, attrKey, null);
    }

    protected AusAttribute getUStoreDRSAttribute(UserDomainAOR aor, Long ausServiceId, String attrKey, Boolean ustoreOnly) throws UserStoreException {
        AusTemplateService ts;
        AusAttribute attribute;
        block14: {
            attribute = null;
            Long templateId = this.getTemplateIdByUser(aor.getUser(), aor.getDomain());
            if (templateId == null || ausServiceId == null) {
                return attribute;
            }
            ts = this.getAusServiceDAO().getTemplateServiceByIds(templateId, ausServiceId);
            if (ts == null) {
                return attribute;
            }
            String attrStr = null;
            if (ustoreOnly == null || ustoreOnly.equals(Boolean.TRUE)) {
                try {
                    attrStr = this.getPlatformServiceDM().getUserStoreData(aor, attrKey, new String[0]);
                    if (attrStr != null) {
                        attribute = new AusAttribute(0L, attrKey, attrStr, ts.getTemplateId(), ts.getServiceId(), null, null);
                    }
                }
                catch (UserStoreException e) {
                    this.log.warn((Object)("getUStoreDRSAttribute: Unable to get UStore based attribute. " + (ustoreOnly == null ? "Trying DRS." : "Rethrowing back to laying exception to calling code.")));
                    if (ustoreOnly == null) break block14;
                    throw e;
                }
            }
        }
        if (attribute == null && (ustoreOnly == null || ustoreOnly.equals(Boolean.FALSE))) {
            Long serviceId;
            try {
                serviceId = this.getAusServiceDAO().getServiceIdFromServiceVersionId(ts.getServiceId());
            }
            catch (Exception e) {
                if (this.log.isFineEnabled()) {
                    this.log.fine((Object)("no service ID found for service:" + ts.getServiceId()));
                }
                throw new UserStoreException(e.getMessage(), (Throwable)e);
            }
            attribute = this.getAusAttributeDAO().getAusAttribute(ts.getTemplateId(), serviceId, attrKey);
            if (attribute == null) {
                try {
                    String defaultValue = this.getDefaultAttributeValue(attrKey, serviceId);
                    return new AusAttribute(ts.getServiceId(), attrKey, defaultValue, ts.getTemplateId(), ts.getServiceId(), null, null);
                }
                catch (Exception e) {
                    throw new UserStoreException(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("getUStoreDRSAttribute: Using aorUri=" + aor.getUri() + ", svcId=" + ausServiceId + ", attrKey=" + attrKey + " src=" + ustoreOnly + ", found: " + attribute));
        }
        return attribute;
    }

    public AusCommProfile getUserTemplate(String user, String domain) {
        Long setId = this.getPlatformServiceDM().getCommProfileSetId(user, domain);
        AusCommProfile ausCommProfile = this.getAusCommProfileDAO().getAusCommProfileBySetId(setId);
        return ausCommProfile;
    }

    public AusCommProfile getUserTemplate(String user, String domain, AddressType addressType) {
        Long setId = this.getPlatformServiceDM().getCommProfileSetId(user, domain, addressType);
        AusCommProfile ausCommProfile = this.getAusCommProfileDAO().getAusCommProfileBySetId(setId);
        return ausCommProfile;
    }

    @SMConsole(description="Get the AusTemplate for given user and channel ", parameterNames={"user", "domain"})
    public AusTemplate getTemplateForUser(String user, String domain) {
        Long setId = this.getPlatformServiceDM().getCommProfileSetId(user, domain);
        AusCommProfile ausCommProfile = this.getAusCommProfileDAO().getAusCommProfileBySetId(setId);
        if (ausCommProfile == null || ausCommProfile.getTemplateId() == null) {
            return null;
        }
        return this.getAusTemplateDAO().getTemplate(ausCommProfile.getTemplateId());
    }

    public Long getTemplateIdByUser(String user, String domain) {
        AusCommProfile ausCommProfile = this.getUserTemplate(user, domain);
        Long templateId = null;
        if (ausCommProfile == null) {
            DigitMapRow digitMapRow = this.getAusDigitMapRouterDAO().findTemplateForMatchedPattern(user);
            if (digitMapRow != null) {
                templateId = digitMapRow.getTemplateId();
                if (this.log.isFinestEnabled()) {
                    this.log.finest((Object)("getTemplateIdByUser: Implicit user " + user + " has templated id:" + templateId));
                }
            } else if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("getTemplateIdByUser: Implicit user " + user + " does not match any implicit pattern"));
            }
        } else {
            templateId = ausCommProfile.getTemplateId();
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)("getTemplateIdByUser: Explicit template ID for (" + user + "," + domain + ")=" + templateId));
            }
        }
        return templateId;
    }

    public Long getTemplateIdByUser(String user, String domain, AddressType addressType) {
        AusCommProfile ausCommProfile = null;
        Long templateId = null;
        ausCommProfile = this.getUserTemplate(user, domain, addressType);
        if (ausCommProfile == null) {
            Long csDomainId = this.getCsDomainDAO().getCsDomainId(domain);
            if (csDomainId != null) {
                AppSetPattern pattern = this.getAppSetPatternDAO().getAppSetPattern(csDomainId, user);
                if (pattern != null) {
                    templateId = pattern.getTemplateId();
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("getTemplateIdByUser: Implicit template ID for (" + user + "," + domain + ")=" + templateId));
                    }
                } else if (this.log.isFineEnabled()) {
                    this.log.fine((Object)("getTemplateIdByUser: No match found for user=" + user + " domain=" + domain));
                }
            }
        } else {
            templateId = ausCommProfile.getTemplateId();
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)("getTemplateIdByUser: Explicit template ID for (" + user + "," + domain + ")=" + templateId));
            }
        }
        return templateId;
    }

    @SMConsole(description="Get either explicit or implicit service template for user. If domain is not present, default SIP domain from cluster attribute will be used ", parameterNames={"user"})
    public Long getTemplateIdByUser(String user) {
        DigitMapRow digitMapRow;
        Long templateId = null;
        if (user.contains("@")) {
            UserDomainAOR aor = new UserDomainAOR(user);
            templateId = this.getTemplateIdByUser(aor.getUser(), aor.getDomain());
        } else {
            try {
                String defaultDomain = this.getClusterAttributeDao().getClusterAttribute("SIPDefaultDomain");
                if (StringUtils.isNotBlank((CharSequence)defaultDomain)) {
                    templateId = this.getTemplateIdByUser(user, defaultDomain);
                }
            }
            catch (NoAttributeFoundException e) {
                this.log.fine((Object)"getTemplateIdByUser() No cluster attribute found for SIPDefaultDomain ", (Throwable)e);
            }
        }
        if (templateId == null && (digitMapRow = this.getAusDigitMapRouterDAO().findTemplateForMatchedPattern(user)) != null) {
            templateId = digitMapRow.getTemplateId();
        }
        return templateId;
    }

    @SMConsole(description="Find the first NamedService for this user by rank.", parameterNames={"targetUser", "targetDomain"})
    public NamedService getNamedServiceByRank(String targetUser, String targetDomain) {
        String userHandle = targetUser + "@" + targetDomain;
        List<NamedService> namedServiceList = this.getAusServiceDAO().getAllNamedServices();
        return this.getNamedServiceBasedOnRegexMatch(namedServiceList, userHandle);
    }

    private NamedService getNamedServiceBasedOnRegexMatch(List<NamedService> namedServiceList, String userHandle) {
        for (NamedService namedService : namedServiceList) {
            if (!this.regexMatch(namedService, userHandle)) continue;
            return namedService;
        }
        return null;
    }

    private boolean regexMatch(NamedService namedService, String userHandle) {
        String regex = namedService.getHandlePattern();
        try {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(userHandle);
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("regexMatch sipString " + userHandle));
                this.log.fine((Object)("regexMatch pattern " + pattern));
                this.log.fine((Object)("regexMatch matcher " + matcher));
            }
            if (matcher.find()) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            this.log.error((Object)("regexMatch error=" + e), (Throwable)e);
        }
        return false;
    }

    public Long getServiceIdByServiceName(String serviceName) {
        if (serviceName == null) {
            this.log.fine((Object)"ServiceName is null");
            return null;
        }
        return this.getAusServiceDAO().getServiceIDByServiceName(serviceName);
    }

    @SMConsole(description="Gets the value of the attribute for the given user. Args:(userHandle, serviceName, attributeName)")
    public String getServiceAttribute(String userHandle, String serviceName, String attrName) throws NoUserFoundException, ServiceNotFoundException, NoServiceProfileFoundException, NoAttributeFoundException {
        AusAttribute attr;
        Long serviceID = this.getServiceIdByServiceName(serviceName);
        if (serviceID == null) {
            throw new ServiceNotFoundException("New service ID found for service:" + serviceName);
        }
        if (userHandle == null) {
            throw new NoUserFoundException("user handle is null");
        }
        UserDomainAOR aor = new UserDomainAOR(userHandle);
        Long templateId = this.getTemplateIdByUser(aor.getUser(), aor.getDomain());
        if (templateId == null) {
            throw new NoServiceProfileFoundException("Can't find service profile for user:" + userHandle + " please make sure the user is assigned with a valid template");
        }
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("TemplateId:" + templateId + " serviceID:" + serviceID + " attrName:" + attrName));
        }
        if ((attr = this.getAusAttributeDAO().getAusAttribute(templateId, serviceID, attrName)) == null) {
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)"not found, try default.");
            }
            return this.getDefaultAttributeValue(attrName, serviceID);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("getServiceAttribute: Found attribute:" + attr));
        }
        return attr.getValue();
    }

    @SMConsole(description="Gets the value of the attribute for the given user and addressType. Args:(userHandle, addressType, serviceName, attributeName)")
    public String getServiceAttribute(String userHandle, AddressType addressType, String serviceName, String attrName) throws NoUserFoundException, ServiceNotFoundException, NoServiceProfileFoundException, NoAttributeFoundException, InvalidAddressTypeException {
        AusAttribute attr;
        Long serviceID = this.getServiceIdByServiceName(serviceName);
        if (serviceID == null) {
            throw new ServiceNotFoundException("New service ID found for service:" + serviceName);
        }
        if (userHandle == null) {
            throw new NoUserFoundException("user handle is null");
        }
        if (addressType == null) {
            throw new InvalidAddressTypeException("addres type is null");
        }
        UserDomainAOR aor = new UserDomainAOR(userHandle);
        Long templateId = this.getTemplateIdByUser(aor.getUser(), aor.getDomain(), addressType);
        if (templateId == null) {
            throw new NoServiceProfileFoundException("Can't find service profile for user:" + userHandle + " please make sure the user is assigned with a valid template");
        }
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("TemplateId:" + templateId + " serviceID:" + serviceID + " attrName:" + attrName));
        }
        if ((attr = this.getAusAttributeDAO().getAusAttribute(templateId, serviceID, attrName)) == null) {
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)"not found, try default.");
            }
            return this.getDefaultAttributeValue(attrName, serviceID);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("getServiceAttribute: Found attribute:" + attr));
        }
        return attr.getValue();
    }

    private String getDefaultAttributeValue(String attrName, Long serviceID) throws NoAttributeFoundException {
        if (this.getAusServiceDAO().isEncryptedAttribute(serviceID, attrName)) {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass() + ":Attribute name:" + attrName + " for service:" + serviceID + " is Encrypted. Please call different method for retrieving encrypted attributes");
        }
        ClusterDefaultAttribute clusterDefaultAttr = this.getAusServiceDAO().getClusterDefaultAttribute(serviceID, attrName);
        if (clusterDefaultAttr == null) {
            DefaultAttribute defaultAttr = this.getAusServiceDAO().getDefaultAttribute(serviceID, attrName);
            if (defaultAttr == null) {
                throw new NoAttributeFoundException("No AusAttribute returned;  serviceId=" + serviceID + " attributeName=" + attrName);
            }
            if (defaultAttr.getDefaultEnterpriseValue() != null) {
                return defaultAttr.getDefaultEnterpriseValue();
            }
            return defaultAttr.getDefaultFactoryValue();
        }
        return clusterDefaultAttr.getClusterOverrideValue();
    }

    private String getDefaultEncryptedAttributeValue(String attrName, Long serviceID) throws NoAttributeFoundException {
        ClusterDefaultAttribute clusterDefaultAttr = this.getAusServiceDAO().getClusterDefaultEncryptedAttribute(serviceID, attrName);
        if (clusterDefaultAttr == null) {
            DefaultAttribute defaultAttr = this.getAusServiceDAO().getDefaultEncryptedAttribute(serviceID, attrName);
            if (defaultAttr == null) {
                throw new NoAttributeFoundException("No AusAttribute returned;  serviceId=" + serviceID + " attributeName=" + attrName);
            }
            if (defaultAttr.getDefaultEnterpriseValue() != null) {
                return defaultAttr.getDefaultEnterpriseValue();
            }
            return defaultAttr.getDefaultFactoryValue();
        }
        return clusterDefaultAttr.getClusterOverrideValue();
    }

    public List<String> getServiceAttributeList(String serviceName) throws ServiceNotFoundException {
        Long serviceID = this.getServiceIdByServiceName(serviceName);
        if (serviceID == null) {
            throw new ServiceNotFoundException("No Service ID found for service name:" + serviceName);
        }
        return this.getAusServiceDAO().getServiceAttributeList(serviceID);
    }

    public String getGlobalAttribute(String attrName) {
        String value = null;
        AusAttribute attr = this.getAusAttributeDAO().getAusGlobalAttributeValue(attrName);
        if (attr == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("No configured global attribute found for:" + attrName));
            }
            try {
                value = this.getDefaultAttributeValue(attrName, GLOBAL_SERVICE_ID);
            }
            catch (Exception e) {
                if (this.log.isFineEnabled()) {
                    this.log.fine((Object)("Global attribute:" + attrName + "not defined."));
                }
            }
        } else {
            value = attr.getValue();
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("found global attribute:" + attrName + "value:" + value));
        }
        return value;
    }

    public List<String> getGlobalAttributeList() {
        return this.getAusServiceDAO().getGlobalAttributeList();
    }

    @SMConsole(description="Get the default value of the attribute. Args:(serviceName, attributeName)")
    public String getServiceAttribute(String serviceName, String attrName) throws NoAttributeFoundException {
        Long serviceID = this.getServiceIdByServiceName(serviceName);
        if (serviceID == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Service ID not found:" + serviceName));
            }
            return null;
        }
        return this.getDefaultAttributeValue(attrName, serviceID);
    }

    @SMConsole(description="Get Trust Status of a service.")
    public Boolean getServiceTrustStatus(String serviceName, String serviceVersion) throws ServiceNotFoundException {
        Boolean trustStatus;
        block5: {
            trustStatus = null;
            try {
                AusService serviceFromCache = null;
                List<AusService> serviceVersionList = this.getAusServiceDAO().getServicesByServiceName(serviceName);
                for (AusService ausService : serviceVersionList) {
                    if (!ausService.getVersion().equalsIgnoreCase(serviceVersion)) continue;
                    serviceFromCache = ausService;
                    break;
                }
                if (serviceFromCache == null) {
                    throw new ServiceNotFoundException("No Service found with name = " + serviceName + " , version = " + serviceVersion);
                }
                trustStatus = serviceFromCache.getTrustStatus();
            }
            catch (Exception e) {
                if (!this.log.isFineEnabled()) break block5;
                this.log.fine((Object)("Service not found:" + serviceName));
            }
        }
        if (trustStatus == null) {
            throw new ServiceNotFoundException("No Service found with name = " + serviceName + " , version = " + serviceVersion);
        }
        return trustStatus;
    }

    public String getEncryptedServiceAttribute(String serviceName, String attrName) throws NoAttributeFoundException {
        Long serviceID = this.getServiceIdByServiceName(serviceName);
        if (serviceID == null) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Service ID not found:" + serviceName));
            }
            return null;
        }
        return this.getDefaultEncryptedAttributeValue(attrName, serviceID);
    }

    @SMConsole(description="Get Id of preferred service for channel ", parameterNames={"channel"})
    public Long getIdOfPrefServiceForChannel(String channel) {
        ChannelSversion channelSversion = this.getChannelDAO().getPrefSversionForChannel(channel);
        return channelSversion != null ? channelSversion.getServiceId() : null;
    }

    @SMConsole(description="Get the ChannelSversion for given user and channel ", parameterNames={"user", "channel"})
    public ChannelSversion getChannelForUser(String user, String channel) {
        ChannelSversion rtChannelSversion = null;
        Map<Long, ChannelSversion> sversionsForChannel = this.getChannelDAO().getAllServicesPerChannel(channel);
        if (sversionsForChannel == null || sversionsForChannel.isEmpty()) {
            this.log.info((Object)("No service version found for channel:" + channel));
            return null;
        }
        Iterator<ChannelSversion> it = sversionsForChannel.values().iterator();
        rtChannelSversion = it.next();
        if (sversionsForChannel.size() == 1) {
            return rtChannelSversion;
        }
        Long templateId = this.getTemplateIdByUser(user);
        if (templateId == null) {
            return null;
        }
        List<AusService> servicesPerSP = this.getAusServiceDAO().getAllServices(templateId);
        ArrayList<ChannelSversion> sversionInTemplateAndChannel = new ArrayList<ChannelSversion>();
        for (AusService service : servicesPerSP) {
            if (!sversionsForChannel.containsKey(service.getId())) continue;
            sversionInTemplateAndChannel.add(sversionsForChannel.get(service.getId()));
        }
        switch (sversionInTemplateAndChannel.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ChannelSversion)sversionInTemplateAndChannel.get(0);
            }
        }
        Long prefServiceId = this.getIdOfPrefServiceForChannel(channel);
        for (ChannelSversion channelSversion : sversionInTemplateAndChannel) {
            if (!channelSversion.getServiceId().equals(prefServiceId)) continue;
            return channelSversion;
        }
        return null;
    }

    public ChannelSversion getPrefSversionForChannel(String channel) {
        return this.getChannelDAO().getPrefSversionForChannel(channel);
    }

    public List<AusService> getAllServicesByServiceName(String serviceName) {
        return this.getAusServiceDAO().getAllServicesByServiceName(serviceName);
    }

    public String getSdkVersionByApplicationName(String applicationName) {
        return this.getAusServiceSdkDao().getSdkVersionByApplicationName(applicationName);
    }

    public Collection<AusService> getAllServices() {
        return this.getAusServiceDAO().getAllAusServicesMap().values();
    }

    @SMConsole(description="Given a cluster name, service name and attribute name, find cluster overridden value of attribute ", parameterNames={"clusterName", "serviceName", "attributeName"})
    public String getServiceAttributeOnCluster(String clusterName, String serviceName, String attributeName) throws ClusterNotFoundException, ServiceNotFoundException, NoAttributeFoundException, AccessControlException {
        String attributeValue = null;
        Long clusterId = this.getClusterAttributeDao().getClusterIDByClusterName(clusterName);
        if (clusterId == null) {
            throw new ClusterNotFoundException(clusterName);
        }
        Long serviceId = this.getServiceIdByServiceName(serviceName);
        if (serviceId == null) {
            throw new ServiceNotFoundException(serviceName);
        }
        if (attributeName == null) {
            throw new NoAttributeFoundException("Attribute name should not be null");
        }
        attributeValue = this.getAusServiceDAO().getClusterOverrideValueOfAttribute(clusterName, serviceName, attributeName);
        if (attributeValue == null) {
            if (this.isServiceInstalledonCluster(serviceId, clusterId)) {
                attributeValue = this.getGlobalScopeValueOfAttribute(serviceId, attributeName);
            } else {
                throw new ServiceNotFoundException(serviceName);
            }
        }
        if (this.getAusServiceDAO().isEncryptedAttribute(serviceId, attributeName)) {
            attributeValue = EncryptDecrypt.decrypt((String)attributeValue, (String)serviceName);
        }
        return attributeValue;
    }

    private String getGlobalScopeValueOfAttribute(Long serviceID, String attrName) throws NoAttributeFoundException {
        DefaultAttribute defaultAttr = this.getAusServiceDAO().getDefaultAttribute(serviceID, attrName);
        if (defaultAttr == null) {
            throw new NoAttributeFoundException("No AusAttribute returned;  serviceId=" + serviceID + " attributeName=" + attrName);
        }
        if (defaultAttr.getDefaultEnterpriseValue() != null) {
            return defaultAttr.getDefaultEnterpriseValue();
        }
        return defaultAttr.getDefaultFactoryValue();
    }

    private boolean isServiceInstalledonCluster(Long serviceId, Long clusterId) {
        boolean isServiceInstalled = false;
        Map<String, AusClusterService> installedServicesMap = this.getAusServiceDAO().getClusterIdToServiceMap().get(clusterId);
        for (Map.Entry<String, AusClusterService> appName : installedServicesMap.entrySet()) {
            Long serviceIdFromMap = appName.getValue().getServiceId();
            if (!serviceIdFromMap.equals(serviceId)) continue;
            isServiceInstalled = true;
            break;
        }
        return isServiceInstalled;
    }

    public static enum AusDM implements BLDMEnumType
    {
        CLUSTER_ATTRIBUTE_DAO(ClusterAttributeDAO.class),
        AUS_SERVICE_DAO(AusServiceDAO.class),
        AUS_COMMPROFILE_DAO(AusCommProfileDAO.class),
        AUS_ATTRIBUTE_DAO(AusAttributeDAO.class),
        AUS_TEMPLATE_DAO(AusTemplateDAO.class),
        CS_DOMAIN_DAO(CsDomainDAO.class),
        APP_SET_PATTERN_DAO(AppSetPatternDAO.class),
        CHANNEL_DAO(ChannelDAO.class),
        AUS_SERVICE_ACTIVITY(AusServiceActivityDAO.class),
        AUS_ZANG_ACTIVITY(AusZangActivityDAO.class),
        AUS_DIGITMAP_ROUTER_DAO(AusDigitMapRouterDAO.class),
        AUS_SERVICE_PORTS(AusServicePortsDataDAO.class),
        AUS_JDBC_PROVIDER(AusExtJDBCProviderDAO.class),
        AUS_JDBC_DATASOURCE(AusExtJDBCDataSourceDAO.class),
        TMCONFDATA_DAO(TMConfDataDAO.class),
        AUS_SERVICE_LVL_TLSVERSION(AusServiceLevelTLSVersionDAO.class);

        private final Class<? extends DataMgr> subDM;

        private AusDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        public DataMgr get() {
            return AusPlatformServiceDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

