/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dm;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.AssetDM;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DMListener;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.EntityLinkTableDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.objectapi.EntityLink;
import com.avaya.asm.datamgr.objectapi.EntityLinkTable;
import com.avaya.asm.datamgr.objectapi.InstanceMonitoringParameters;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.collaboration.businessdata.api.NoAttributeFoundException;
import com.avaya.collaboration.businessdata.api.ServiceNotFoundException;
import com.avaya.collaboration.data.dao.UserDataDAO;
import com.avaya.zephyr.platform.dal.api.objectapi.AusInstance;
import com.avaya.zephyr.platform.dal.api.objectapi.AusServiceLicense;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthenticationDetails;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationClientScope;
import com.avaya.zephyr.platform.dal.api.objectapi.AuthorizationUserScope;
import com.avaya.zephyr.platform.dal.api.objectapi.EventCatalog;
import com.avaya.zephyr.platform.dao.AgentDetailsDAO;
import com.avaya.zephyr.platform.dao.AusInstanceDAO;
import com.avaya.zephyr.platform.dao.AusServiceDAO;
import com.avaya.zephyr.platform.dao.AusServiceLicenseDao;
import com.avaya.zephyr.platform.dao.AuthenticationDetailsDAO;
import com.avaya.zephyr.platform.dao.AuthorizationCertDetailsDAO;
import com.avaya.zephyr.platform.dao.AuthorizationDetailsDAO;
import com.avaya.zephyr.platform.dao.AuthorizationServiceDAO;
import com.avaya.zephyr.platform.dao.ClientFeatureDAO;
import com.avaya.zephyr.platform.dao.ClusterAttributeDAO;
import com.avaya.zephyr.platform.dao.CommunicationAddressDAO;
import com.avaya.zephyr.platform.dao.EventCatalogDAO;
import com.avaya.zephyr.platform.dao.HttpCorsByClusterDAO;
import com.avaya.zephyr.platform.dao.HttpCorsDAO;
import com.avaya.zephyr.platform.dao.LdapAttributeDetailsDAO;
import com.avaya.zephyr.platform.dao.LdapConfigDAO;
import com.avaya.zephyr.platform.dao.MailboxDetailsDAO;
import com.avaya.zephyr.platform.dao.MediaServerDAO;
import com.avaya.zephyr.platform.dao.ReliableEventingDAO;
import com.avaya.zephyr.platform.dao.StationDetailsDAO;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ZephyrDM
extends BusinessLogicDM {
    private static final String SERVER_PROPERTY_KEY = "server";
    private static final String MGMT_SERVER = "Management";
    private static final int OK_RESPONSES_MARKING_UP = 1;
    private static Boolean isMgmtServer = null;
    private static DMFactory factory;
    private final List<Class<?>> ausDAOs = Arrays.asList(AusInstanceDAO.class, AusServiceDAO.class, SIPEntityDAO.class, EntityLinkTableDAO.class, AssetDM.class, UserDataDAO.class, AusServiceLicenseDao.class, ClusterAttributeDAO.class, HttpCorsDAO.class, EventCatalogDAO.class, HttpCorsByClusterDAO.class, LdapConfigDAO.class, AuthorizationServiceDAO.class, AuthenticationDetailsDAO.class, AuthorizationCertDetailsDAO.class, LdapAttributeDetailsDAO.class);

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public static boolean isMgmtServer() {
        if (isMgmtServer != null) {
            return isMgmtServer;
        }
        String serverType = System.getProperty(SERVER_PROPERTY_KEY);
        isMgmtServer = serverType != null && serverType.equalsIgnoreCase(MGMT_SERVER) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return isMgmtServer;
    }

    public final void init() {
        if (ZephyrDM.isMgmtServer()) {
            return;
        }
        for (Class<?> c : this.ausDAOs) {
            this.getDataMgr(c);
        }
        ((AssetDM)this.getDataMgr(AssetDM.class)).setMyInstanceClass(AusInstanceDAO.class);
        this.setStatus(DataMgr.Status.OKAY);
    }

    protected final AusServiceLicenseDao getAusServiceLicenseDao() {
        return (AusServiceLicenseDao)this.getDataMgr(AusServiceLicenseDao.class);
    }

    protected final SIPEntityDAO getSIPEntityDAO() {
        return (SIPEntityDAO)this.getDataMgr(SIPEntityDAO.class);
    }

    @SMConsole(description="Get User Data DAO")
    public final UserDataDAO getUserDataDAO() {
        return (UserDataDAO)this.getDataMgr(UserDataDAO.class);
    }

    @SMConsole(description="Get Cluster Attribute DAO")
    public final ClusterAttributeDAO getClusterAttributeDAO() {
        return (ClusterAttributeDAO)this.getDataMgr(ClusterAttributeDAO.class);
    }

    @SMConsole(description="Get Event Catalog DAO")
    public final EventCatalogDAO getEventCatalogDAO() {
        return (EventCatalogDAO)this.getDataMgr(EventCatalogDAO.class);
    }

    @SMConsole(description="Get Comm Address DAO")
    public final CommunicationAddressDAO getCommunicationAddressDAO() {
        return (CommunicationAddressDAO)this.getDataMgr(CommunicationAddressDAO.class);
    }

    @SMConsole(description="Get Agent Details DAO")
    public final AgentDetailsDAO getAgentDetailsDAO() {
        return (AgentDetailsDAO)this.getDataMgr(AgentDetailsDAO.class);
    }

    @SMConsole(description="Get Station Details DAO")
    public final StationDetailsDAO getStationDetailsDAO() {
        return (StationDetailsDAO)this.getDataMgr(StationDetailsDAO.class);
    }

    @SMConsole(description="Get Mailbox Details DAO")
    public final MailboxDetailsDAO getMailboxDetailsDAO() {
        return (MailboxDetailsDAO)this.getDataMgr(MailboxDetailsDAO.class);
    }

    @SMConsole(description="Get Authorization Scope DAO")
    public final AuthorizationDetailsDAO getAuthorizationDetailsDAO() {
        return (AuthorizationDetailsDAO)this.getDataMgr(AuthorizationDetailsDAO.class);
    }

    @SMConsole(description="Get client features DAO")
    public final ClientFeatureDAO getClientFeatureDAO() {
        return (ClientFeatureDAO)this.getDataMgr(ClientFeatureDAO.class);
    }

    @SMConsole(description="Get the Media Sever DAO")
    public final MediaServerDAO getMediaServerDAO() {
        return (MediaServerDAO)this.getDataMgr(MediaServerDAO.class);
    }

    protected final EntityLinkTableDAO getEntityLinkTableDAO() {
        return (EntityLinkTableDAO)this.getDataMgr(EntityLinkTableDAO.class);
    }

    public final AusInstanceDAO getAusInstanceDAO() {
        return (AusInstanceDAO)this.getDataMgr(AusInstanceDAO.class);
    }

    public final AuthorizationServiceDAO getAuthorizationServiceDAO() {
        return (AuthorizationServiceDAO)this.getDataMgr(AuthorizationServiceDAO.class);
    }

    @SMConsole(description="Get Authentication Details DAO")
    public final AuthenticationDetailsDAO getAuthenticationDetailsDAO() {
        return (AuthenticationDetailsDAO)this.getDataMgr(AuthenticationDetailsDAO.class);
    }

    @SMConsole(description="Get Authentication Details DAO")
    public final AuthorizationCertDetailsDAO getAuthorizationCertDetailsDAO() {
        return (AuthorizationCertDetailsDAO)this.getDataMgr(AuthorizationCertDetailsDAO.class);
    }

    @SMConsole(description="Get authorization service app ID of the current node")
    public String getAuthServiceAppId() {
        return this.getAuthorizationCertDetailsDAO().getAuthServiceAppId();
    }

    @SMConsole(description="Get RSA public key for the current node")
    public RSAPublicKey getRSAPublicKey() {
        return this.getAuthorizationCertDetailsDAO().getRSAPublicKey();
    }

    @SMConsole(description="Get RSA Public key for the input authorization service app ID")
    public RSAPublicKey getRSAPublicKeyWithAuthServiceAppId(String authServiceAppId) {
        return this.getAuthorizationCertDetailsDAO().getRSAPublicKey(authServiceAppId);
    }

    @SMConsole(description="Get certificate for the current node")
    public String getCertificate() {
        return this.getAuthorizationCertDetailsDAO().getCertificate();
    }

    @SMConsole(description="Get LDAP Attribute Details DAO")
    public final LdapAttributeDetailsDAO getLdapAttributeDetailsDAO() {
        return (LdapAttributeDetailsDAO)this.getDataMgr(LdapAttributeDetailsDAO.class);
    }

    @SMConsole(description="Get Ldap attribute for the login name")
    public String getLdapAttributeForLoginName() {
        return this.getLdapAttributeDetailsDAO().getLdapAttributeForLoginName();
    }

    @SMConsole(description="Get Authentication Details")
    public final AuthenticationDetails getAuthenticationDetails() {
        return this.getAuthenticationDetailsDAO().getAuthenticationDetails();
    }

    public final ReliableEventingDAO getReliableEventingDAO() {
        return (ReliableEventingDAO)this.getDataMgr(ReliableEventingDAO.class);
    }

    @SMConsole(description="Get Service Details")
    public final AusServiceDAO getAusServiceDAO() {
        return (AusServiceDAO)this.getDataMgr(AusServiceDAO.class);
    }

    public final LdapConfigDAO getLdapConfigDao() {
        return (LdapConfigDAO)this.getDataMgr(LdapConfigDAO.class);
    }

    public final SIPEntity getMySIPEntity() {
        return this.getSIPEntityDAO().getSIPEntity(this.getMySIPEntityId());
    }

    public final Long getMySIPEntityId() {
        return this.getAusInstanceDAO().getMySIPEntityId();
    }

    public final List<SIPEntity> getSIPEntityByAddress(String address) {
        return this.getSIPEntityDAO().getSIPEntityByAddress(address);
    }

    @SMConsole(description="Get the AusInstance object for this AUS Instance")
    public final AusInstance getMyAusInstance() {
        return this.getAusInstanceDAO().getMyAusInstance();
    }

    public final Map<Long, SIPEntity> getAllSipEntities() {
        return this.getSIPEntityDAO().getAllSIPEntities();
    }

    public final List<EntityLink> getEntityLinkList() {
        long instanceId = this.getMySIPEntityId();
        EntityLinkTable entityLinkTable = this.getEntityLinkTableDAO().getEntityLinkTable(Long.valueOf(instanceId));
        LinkedList<EntityLink> entityLinks = new LinkedList<EntityLink>();
        entityLinks.addAll(entityLinkTable.getEntityLinks("tls"));
        entityLinks.addAll(entityLinkTable.getEntityLinks("tcp"));
        entityLinks.addAll(entityLinkTable.getEntityLinks("udp"));
        return entityLinks;
    }

    @SMConsole(description="Get Instance Monitoring Parameters")
    public final InstanceMonitoringParameters getMyInstanceMonitoringParameters() {
        AusInstance aus = this.getMyAusInstance();
        return new InstanceMonitoringParameters(aus.getIs_monitoring(), aus.getMonitor_proactive_secs(), aus.getMonitor_reactive_secs(), aus.getMonitor_retries(), 1);
    }

    public final List<EntityLink> getEntityLinks(Long entityId) {
        return this.getEntityLinkTableDAO().getEntityLinkTable(this.getMySIPEntityId()).getEntityLinks(entityId);
    }

    public final SIPEntity getSipEntity(long sipEntityId) {
        return this.getSIPEntityDAO().getSIPEntity(Long.valueOf(sipEntityId));
    }

    public final void registerListener(DMListener listener) {
        this.getAusInstanceDAO().registerListener(listener);
        this.getEntityLinkTableDAO().registerListener(listener);
        this.getSIPEntityDAO().registerListener(listener);
    }

    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return EnumSet.allOf(AusDM.class);
    }

    @SMConsole(description="Get Service License DAO")
    public final AusServiceLicenseDao getServiceLicenseDAO() {
        return this.getAusServiceLicenseDao();
    }

    @SMConsole(description="Get token status")
    public Boolean hasValidToken(String serviceName, String serviceVersion) throws ServiceNotFoundException {
        return this.getServiceLicenseDAO().hasValidToken(serviceName, serviceVersion);
    }

    @SMConsole(description="Get All token status")
    public Map<String, Boolean> getTokenStatusForAllVersions(String serviceName) throws ServiceNotFoundException {
        return this.getServiceLicenseDAO().getTokenStatusForAllVersions(serviceName);
    }

    @SMConsole(description="Get license mode")
    public String getLicenseMode(String serviceName, String serviceVersion) throws ServiceNotFoundException {
        return this.getServiceLicenseDAO().getLicenseMode(serviceName, serviceVersion);
    }

    @SMConsole(description="Get all license mode")
    public Map<String, String> getLicenseModeForAllVersions(String serviceName) throws ServiceNotFoundException {
        return this.getServiceLicenseDAO().getLicenseModeForAllVersions(serviceName);
    }

    @SMConsole(description="Get all the AusServiceLicense data based on the database.")
    public Map<Long, AusServiceLicense> getAllAusLicenses() {
        return this.getServiceLicenseDAO().getAllAusLicenses();
    }

    @SMConsole(description="Get license map")
    public Map<String, Map<String, String>> getLicenseMap() {
        return this.getServiceLicenseDAO().getLicenseMap();
    }

    @SMConsole(description="Get token map")
    public Map<String, Map<String, Boolean>> getTokenMap() {
        return this.getServiceLicenseDAO().getTokenMap();
    }

    @SMConsole(description="Get the list of all events")
    public List<EventCatalog> getEventList() {
        return this.getEventCatalogDAO().getEventList();
    }

    @SMConsole(description="Get list of events of specified family")
    public List<EventCatalog> getEventDefinitions(String family) {
        return this.getEventCatalogDAO().getEventDefinitions(family);
    }

    @SMConsole(description="Get the events of specified family and type")
    public List<EventCatalog> getEventDefinitions(String family, String eventType) {
        return this.getEventCatalogDAO().getEventDefinitions(family, eventType);
    }

    @SMConsole(description="Get the agent numbers of a user")
    public List<String> getAgentExtensions(Long userId) {
        return this.getAgentDetailsDAO().getAgentExtensions(userId);
    }

    @SMConsole(description="Get the station numbers of a user")
    public List<String> getStationExtensions(Long userId) {
        return this.getStationDetailsDAO().getStationExtensions(userId);
    }

    @SMConsole(description="Get the mailbox numbers of a user")
    public List<String> getMailboxNumbers(Long userId) {
        return this.getMailboxDetailsDAO().getMailboxNumbers(userId);
    }

    @SMConsole(description="Get comm addresses of user ID")
    public List<String> getCommAddresses(Long userId) {
        return this.getCommunicationAddressDAO().getCommAddresses(userId);
    }

    @SMConsole(description="Get user scopes")
    public List<AuthorizationUserScope> getUserScopes(String loginName) {
        return this.getAuthorizationDetailsDAO().getUserScopes(loginName);
    }

    @SMConsole(description="Get client scopes")
    public List<AuthorizationClientScope> getClientScopes(String clientAppId) {
        return this.getAuthorizationDetailsDAO().getClientScopes(clientAppId);
    }

    @SMConsole(description="Get base dn of user")
    public String getBaseDN(String loginName) {
        return this.getAuthorizationDetailsDAO().getBaseDN(loginName);
    }

    @SMConsole(description="Get data source of user")
    public String getDataSourceForUser(String loginName) {
        return this.getAuthorizationDetailsDAO().getDataSourceForUser(loginName);
    }

    @SMConsole(description="Get client features")
    public List<AuthorizationClientScope> getClientFeatures(String clientAppId) {
        return this.getClientFeatureDAO().getClientFeatures(clientAppId);
    }

    @SMConsole(description="Use secure signaling for platform-initiated calls?")
    public boolean useSecureSignalingForPlatformInitiatedCalls() {
        try {
            return "true".equals(this.getClusterAttributeDAO().getClusterAttribute("SIPScheme"));
        }
        catch (NoAttributeFoundException e) {
            return false;
        }
    }

    @SMConsole(description="Get HTTP CORS DAO")
    public final HttpCorsDAO getHttpCorsDAO() {
        return (HttpCorsDAO)this.getDataMgr(HttpCorsDAO.class);
    }

    @SMConsole(description="Get HTTP CORS BY CLUSTER DAO")
    public final HttpCorsByClusterDAO getHttpCorsByClusterDAO() {
        return (HttpCorsByClusterDAO)this.getDataMgr(HttpCorsByClusterDAO.class);
    }

    public static enum AusDM implements BLDMEnumType
    {
        AUS_INSTANCE_DAO(AusInstanceDAO.class),
        SIP_ENTITY_DAO(SIPEntityDAO.class),
        ENTITY_LINK_TABLE_DAO(EntityLinkTableDAO.class),
        USER_DATA_DAO(UserDataDAO.class),
        Cluster_Attribute_DAO(ClusterAttributeDAO.class),
        HTTP_CORS_DAO(HttpCorsDAO.class),
        HTTP_CORS_BY_CLUSTER_DAO(HttpCorsByClusterDAO.class),
        EVENT_CATALOG_DAO(EventCatalogDAO.class),
        Asset_DM(AssetDM.class),
        SERVICE_LICENSE_DAO(AusServiceLicenseDao.class),
        AUS_SERVICE_DAO(AusServiceDAO.class);

        private final Class<? extends DataMgr> subDM;

        private AusDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        public DataMgr get() {
            return ZephyrDM.getFactory().getDataMgr(this.subDM);
        }
    }
}

