/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.alarming.datamgr;

import com.avaya.asm.alarming.GenericAlarm;
import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.alarming.LeakyBucketAlarm;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.CACBwLocException;
import com.avaya.common.logging.helper.EventCode;

public class CACDeniedCallsAlarm
extends LeakyBucketAlarm {
    protected static final long ALARM_RETRY_INTERVAL = 3600000L;
    private static int WARNING_THRESHOLD = 1;
    private static int BUCKET_LIMIT_COUNT = Integer.MAX_VALUE;
    private static int CLEAR_THRESHOLD = 0;
    private static int ALARM_THRESHOLD = 1;
    private int numClearIntervals = 0;
    private int lastHourFailures = 0;

    @Override
    public Object[] getAlarmEventArgs() {
        CACBwLocException bwLocExc = (CACBwLocException)this.exception;
        return new Object[]{bwLocExc.getLocationName()};
    }

    @Override
    public EventCode getAlarmEventCode() {
        return AsmLogger.OP_CCAC54000;
    }

    @Override
    public Object[] getClearEventArgs() {
        CACBwLocException bwLocExc = (CACBwLocException)this.exception;
        return new Object[]{bwLocExc.getLocationName(), "hour"};
    }

    @Override
    public EventCode getClearEventCode() {
        return AsmLogger.OP_CCAC54002;
    }

    @Override
    public Object[] getWarnEventArgs() {
        CACBwLocException bwLocExc = (CACBwLocException)this.exception;
        return new Object[]{bwLocExc.getLocationName(), this.lastHourFailures, "hour"};
    }

    @Override
    public EventCode getWarnEventCode() {
        return AsmLogger.OP_CCAC54001;
    }

    @Override
    public int getAlarmThreshold() {
        return ALARM_THRESHOLD;
    }

    @Override
    public int getClearThreshold() {
        return CLEAR_THRESHOLD;
    }

    @Override
    public int getDecrementAmount() {
        this.lastHourFailures = GenericAlarmHandler.getFailureCount(this);
        this.numClearIntervals = this.lastHourFailures == 0 ? ++this.numClearIntervals : 0;
        return this.lastHourFailures;
    }

    @Override
    public int getWarningThreshold() {
        return WARNING_THRESHOLD;
    }

    @Override
    public long getTimerInterval() {
        return 3600000L;
    }

    @Override
    public int getMaxFailuresAllowed() {
        return BUCKET_LIMIT_COUNT;
    }

    @Override
    public boolean isSingularFailure() {
        return false;
    }

    @Override
    public boolean allowToLogCurrentStatus() {
        return true;
    }

    @Override
    public boolean isAtWarningThreshold() {
        return this.status == GenericAlarm.AlarmStatus.ALARMED;
    }

    @Override
    public boolean canClearAlarm() {
        return this.numClearIntervals >= 1 && super.canClearAlarm();
    }
}

