/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.datamgr.ReadWriteLockHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.junit.Assert;

public abstract class AsmJUnitHelper {
    public abstract boolean booleanFunction(String var1, Object ... var2);

    public abstract int intFunction(String var1, Object ... var2);

    public abstract long longFunction(String var1, Object ... var2);

    public abstract Object objectFunction(String var1, Object ... var2);

    public abstract void voidFunction(String var1, Object ... var2);

    public abstract String stringFunction(String var1, Object ... var2);

    public abstract void voidFunctionException(String var1, Object ... var2) throws Exception;

    public abstract String stringFunctionException(String var1, Object ... var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String filePath) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(filePath));
        }
        catch (FileNotFoundException e) {
            return e.toString();
        }
        StringBuffer fileData = new StringBuffer(1000);
        try {
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            String string = fileData.toString();
            return string;
        }
        catch (IOException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void assertLockNotHeld(ReadWriteLockHandler lock) {
        Assert.assertEquals((String)("Test exited while holding " + lock.getReadHoldCount() + " read lock(s)!  "), (long)0L, (long)lock.getReadHoldCount());
        Assert.assertEquals((String)("Test exited while holding " + lock.getWriteHoldCount() + " write lock(s)!  "), (long)0L, (long)lock.getWriteHoldCount());
    }

    public static void testQuery(String query) {
        String shellCommand = "mgmtia -c \"" + query.replace('?', '0') + "\"";
        System.out.println(shellCommand);
    }
}

