/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;

public class CustomClassLoader
extends URLClassLoader {
    private Logger log = AsmLogger.getLogger(CustomClassLoader.class);
    ClassLoader superCL;
    boolean debug = false;

    public CustomClassLoader(URL[] urls, ClassLoader superCL) {
        super(urls);
        this.superCL = superCL;
        this.log = AsmLogger.getLogger(this.getClass());
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass;
        if (this.log.isFinestEnabled() && this.debug) {
            this.log.finest((Object)("Attempting to load class " + name));
        }
        if ((loadedClass = this.findLoadedClass(name)) != null) {
            if (this.log.isFinestEnabled() && this.debug) {
                this.log.finest((Object)("Class " + name + " has already been loaded"));
            }
            return loadedClass;
        }
        try {
            if (this.log.isFinestEnabled() && this.debug) {
                this.log.finest((Object)("Class " + name + " not already loaded.  Attempting to find it."));
            }
            return this.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (this.log.isFinestEnabled() && this.debug) {
                this.log.finest((Object)("Class " + name + " not found.  Delegating to " + this.superCL.getClass()));
            }
            return this.superCL.loadClass(name);
        }
    }

    @Override
    public URL getResource(String name) {
        URL val = super.getResource(name);
        if (val == null) {
            val = this.superCL.getResource(name);
        }
        return val;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> val = super.getResources(name);
        if (val == null) {
            val = this.superCL.getResources(name);
        }
        return val;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream val = super.getResourceAsStream(name);
        if (val == null) {
            val = this.superCL.getResourceAsStream(name);
        }
        return val;
    }

    @Override
    public void addURL(URL url) {
        if (url != null) {
            super.addURL(url);
        }
    }
}

