/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

public class WaitStatus {
    private static final int __WCOREFLAG = 128;

    public static boolean WIFEXITED(int status) {
        return WaitStatus.WTERMSIG(status) == 0;
    }

    public static boolean WIFSIGNALED(int status) {
        return (status & 0x7F) != 0;
    }

    public static boolean WIFSTOPPED(int status) {
        return (status & 0xFF) == 127;
    }

    public static int WEXITSTATUS(int status) {
        return (status & 0xFF00) >> 8;
    }

    public static int WTERMSIG(int status) {
        return status & 0x7F;
    }

    public static int WSTOPSIG(int status) {
        return WaitStatus.WEXITSTATUS(status);
    }

    public static boolean WCOREDUMP(int status) {
        return (status & 0x80) != 0;
    }

    public static String asString(int status) {
        StringBuilder sb = new StringBuilder();
        if (WaitStatus.WIFEXITED(status)) {
            sb.append("exited with exit code=");
            sb.append(WaitStatus.WEXITSTATUS(status));
        } else if (WaitStatus.WIFSIGNALED(status)) {
            sb.append("signaled with signal number=");
            sb.append(WaitStatus.WTERMSIG(status));
            if (WaitStatus.WCOREDUMP(status)) {
                sb.append(", core file dumped");
            }
        } else if (WaitStatus.WIFSTOPPED(status)) {
            sb.append("stopped with signal number=");
            sb.append(WaitStatus.WSTOPSIG(status));
        } else {
            sb.append("unknown status=0x");
            sb.append(Integer.toString(status, 16));
        }
        return sb.toString();
    }
}

