/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.cassandra.KeyspaceMetaData;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.common.logging.client.Logger;
import java.util.Collection;
import java.util.Map;

public class CassandraMetaDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(CassandraMetaDAO.class);
    protected final String DROP_KS_QUERY = "DROP KEYSPACE IF EXISTS :keyspace:;";
    protected final String DROP_CF_QUERY = "DROP TABLE IF EXISTS :columnfamily:;";
    protected final String ALTER_KS_REPLICATION_QUERY = "ALTER KEYSPACE :keyspace: WITH REPLICATION = :map:";

    public CassandraMetaDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
    }

    public boolean getAllKeyspaces(Collection<KeyspaceMetaData> keyspaces) {
        boolean rc = this.sessionDAO.getKeyspaces(keyspaces);
        return rc;
    }

    public boolean getColumnFamilies(String keyspace, Collection<ColumnFamilyMetaData> columnFamilies) {
        boolean rc = this.sessionDAO.getColumnFamilies(keyspace, columnFamilies);
        return rc;
    }

    public boolean getAllColumnFamilies(Collection<ColumnFamilyMetaData> columnFamilies) {
        boolean rc = this.sessionDAO.getAllColumnFamilies(columnFamilies);
        return rc;
    }

    public void dropKeyspace(String keyspace) throws DMException {
        String query = "DROP KEYSPACE IF EXISTS :keyspace:;".replace(":keyspace:", keyspace);
        this.sessionDAO.executeQuery(query);
    }

    public void dropColumnFamily(String columnFamily) throws DMException {
        String query = "DROP TABLE IF EXISTS :columnfamily:;".replace(":columnfamily:", columnFamily);
        this.sessionDAO.executeQuery(query);
    }

    public void alterKeyspaceReplicationStrategy(String keyspace, Map<String, String> replParms) throws DMException {
        String fcn_name = "alterKeyspaceReplicationStrategy";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("alterKeyspaceReplicationStrategy: enter, keyspace=" + keyspace + ", replParms=" + replParms));
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int count = 0;
        for (Map.Entry<String, String> entry : replParms.entrySet()) {
            if (count > 0) {
                sb.append(',');
            }
            this.processMapElement(sb, entry.getKey());
            sb.append(':');
            this.processMapElement(sb, entry.getValue());
            ++count;
        }
        sb.append('}');
        String query = "ALTER KEYSPACE :keyspace: WITH REPLICATION = :map:".replace(":keyspace:", keyspace).replace(":map:", sb.toString());
        if (isFinest) {
            this.log.finest((Object)("alterKeyspaceReplicationStrategy: executing query=" + query));
        }
        this.sessionDAO.executeQuery(query);
        if (isFiner) {
            this.log.finer((Object)"alterKeyspaceReplicationStrategy: leave");
        }
    }

    private void processMapElement(StringBuilder sb, String element) {
        if (element == null) {
            sb.append("null");
        } else {
            sb.append('\'');
            sb.append(element.replace("'", "''"));
            sb.append('\'');
        }
    }
}

