/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.DebugDM;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.datadistributionlayer.DDLIntraClusterMember;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerFactory;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.asm.datamgr.objectapi.WeakHashSet;
import com.avaya.asm.datamgr.tools.SMConsoleCommand;
import com.avaya.asm.datamgr.tools.SMConsoleListener;
import com.avaya.common.logging.client.Logger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DebugDMAppBase
extends BusinessLogicDM {
    private final Logger log = AsmLogger.getLogger(DebugDMAppBase.class);
    protected static DMFactory factory;

    protected DebugDM getDebugDMInstance() {
        return (DebugDM)this.getDataMgr(DebugDM.class);
    }

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    @Override
    public void init() {
        this.log.finest((Object)"Calling init");
        this.getDebugDMInstance();
        Map<Class<? extends DataMgr>, String> loadedClasses = this.getDebugDMInstance().getClassShortNames();
        HashMap<Class<? extends DataMgr>, String> loadedClassesApp = new HashMap<Class<? extends DataMgr>, String>();
        this.addClassShortNames(loadedClassesApp);
        loadedClasses.putAll(loadedClassesApp);
        loadedClasses.put(this.getClass(), this.getShortName());
        SMConsoleListener.getInstance().addClassShortNames(loadedClasses);
    }

    protected abstract void addClassShortNames(Map<Class<? extends DataMgr>, String> var1);

    protected abstract String getShortName();

    @SMConsole
    public final String reinitAppDAOs() {
        this.log.fine((Object)("Re-initing application-specific DAOs for " + this.getClass().getSimpleName()));
        WeakHashSet<DataAccessObject> daos = DMFactory.getInstance().getDAOsByClassLoader(this.getClass().getClassLoader());
        return this.getDebugDMInstance().doReinitDAOs(daos);
    }

    @SMConsole(description="Set the context for commands to be either 1) specific to an application or 2) all available.")
    public final List<SMConsoleCommand> setApplication() {
        this.log.fine((Object)"Setting command context in SMConsole to application");
        Set<DataMgr> dms = DMFactory.getInstance().getDMsByClassLoader(this.getClass().getClassLoader());
        HashSet<Class<? extends DataMgr>> dmClassSet = new HashSet<Class<? extends DataMgr>>();
        for (DataMgr dm : dms) {
            dmClassSet.add(dm.getClass());
        }
        return SMConsoleListener.getInstance().loadAllMethods(dmClassSet);
    }

    protected DDLIntraClusterMember getMember() {
        return DataDistLayerFactory.getInstance().getIntraClusterMember();
    }

    protected void register() {
        this.getDebugDMInstance().addListener(this);
    }

    public boolean processMessage(DataDistLayerMessage message, DataDistLayerMemberAddr senderId) {
        return false;
    }

    public Object handleMessage(DataDistLayerMessage message, DataDistLayerMemberAddr srcMember) {
        return null;
    }
}

