/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.BusinessLogicDM;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmCommProfileDAO;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.CsDomainDAO;
import com.avaya.asm.datamgr.dao.CsHandleDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.SetCommunityDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.asm.datamgr.objectapi.Instance;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.UserDomainAOR;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.client.UStoreNodeIdentifier;
import com.avaya.ustore.client.UserStoreClient;
import com.avaya.ustore.client.UserStoreFactory;
import com.avaya.ustore.client.objects.UserStoreException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class DefaultUStoreNodeIdentifier
extends BusinessLogicDM
implements UStoreNodeIdentifier {
    private final Logger log = AsmLogger.getLogger(DefaultUStoreNodeIdentifier.class);
    protected static DMFactory factory;
    public static EnumSet<platDM> serviceDM;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    @Override
    public EnumSet<? extends BLDMEnumType> getDMUsages() {
        return serviceDM;
    }

    @Override
    public void init() {
        serviceDM = EnumSet.range(platDM.ASM_COMMPROFILE_DAO, platDM.USER_COMMUNITY_DAO);
        serviceDM.add(platDM.ASM_INSTANCE_DAO);
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (platDM dm : serviceDM) {
            if (dm.get().okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
    }

    protected CsDomainDAO getCsDomainDAO() {
        return (CsDomainDAO)platDM.CS_DOMAIN_DAO.get();
    }

    protected CsHandleDAO getCsHandleDAO() {
        return (CsHandleDAO)platDM.CS_HANDLE_DAO.get();
    }

    protected AsmCommProfileDAO getAsmCommProfileDAO() {
        return (AsmCommProfileDAO)platDM.ASM_COMMPROFILE_DAO.get();
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)platDM.ASM_INSTANCE_DAO.get();
    }

    protected SetCommunityDAO getSetCommunityDAO() {
        return (SetCommunityDAO)platDM.SET_COMMUNITY_DAO.get();
    }

    protected SIPEntityDAO getSIPEntityDAO() {
        return (SIPEntityDAO)platDM.SIP_ENTITY_DAO.get();
    }

    protected UserCommunityDAO getUserCommunityDAO() {
        return (UserCommunityDAO)platDM.USER_COMMUNITY_DAO.get();
    }

    protected UserStoreClient getUStoreClient() {
        return UserStoreFactory.getUserStoreRESTClient();
    }

    @SMConsole(description="Get the primary and secondary SM based on the user and domain and the resulting SIP Comm Profile", parameterNames={"user", "domain"})
    public List<String> getUserHomeSMInstanceIPs(String user, String domain) {
        ArrayList<String> homeInstanceIPs = new ArrayList<String>();
        Long commProfSetId = this.getCommProfileSetId(user, domain);
        if (commProfSetId == null) {
            return homeInstanceIPs;
        }
        Long communityId = this.getSetCommunityDAO().getUserCommunityId(commProfSetId);
        List<Long> asmInstanceIdList = this.getUserCommunityDAO().getUserCommAsmInstanceIds(communityId);
        for (Long asmInstanceId : asmInstanceIdList) {
            AsmInstance instance = this.getAsmInstanceDAO().getAsmInstance(asmInstanceId);
            if (instance == null) continue;
            homeInstanceIPs.add(instance.getManagementAccessPointHostName());
        }
        return homeInstanceIPs;
    }

    @SMConsole(description="Get the primary and secondary SM based on the user and domain and the resulting SIP Comm Profile", parameterNames={"user", "domain"})
    public List<String> getUserHomeASMSipEntityIPs(String user, String domain) {
        ArrayList<String> homeInstanceIPs = new ArrayList<String>();
        List<Long> entityIds = this.getHomeASMSipEntityIds(user, domain);
        for (Long id : entityIds) {
            SIPEntity se = this.getSIPEntityDAO().getSIPEntity(id);
            if (se == null) continue;
            homeInstanceIPs.add(se.getFqdnoripaddr());
        }
        return homeInstanceIPs;
    }

    public Long getCommProfileSetId(String user, String domain) {
        Long csDomainId = this.getCsDomainDAO().getCsDomainId(domain);
        if (csDomainId != null) {
            CsHandle csHandle = this.getCsHandleDAO().getHandle(user, csDomainId);
            if (csHandle != null) {
                return csHandle.getCsCommProfileSetId();
            }
        } else if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("Queried domain '" + domain + "' for user '" + user + "' is not provisioned!"));
        }
        return null;
    }

    public List<Long> getHomeASMSipEntityIds(Long commProfileSetId) {
        ArrayList<Long> sipEntityIdList = new ArrayList<Long>();
        Long userCommunityId = this.getSetCommunityDAO().getUserCommunityId(commProfileSetId);
        if (userCommunityId != null) {
            List<Long> asmInstanceIdList = this.getUserCommunityDAO().getUserCommAsmInstanceIds(userCommunityId);
            Map<Long, Instance> instanceMap = this.getAsmInstanceDAO().getAllAsmInstances();
            for (Long instanceId : asmInstanceIdList) {
                sipEntityIdList.add(instanceMap.get(instanceId).getSipEntityId());
            }
        }
        return sipEntityIdList;
    }

    @SMConsole(parameterNames={"user", "domain"}, description="Get IDs of SIPEntities for Session Managers in the User Community for the given user@domain.")
    public List<Long> getHomeASMSipEntityIds(String user, String domain) {
        return this.getHomeASMSipEntityIds(this.getCommProfileSetId(user, domain));
    }

    @SMConsole(description="Get data from the User Store basing the query on the user's UStore instances (primary and secondary SMs).  Optionally, the hosts may be inputted to identify which nodes to query.", parameterNames={"user", "domain", "path", "hosts"})
    public String getUserStoreData(String user, String domain, String path, String ... hosts) throws UserStoreException {
        return this.getUserStoreData(new UserDomainAOR(user, domain), path, hosts);
    }

    public String getUserStoreData(UserDomainAOR aor, String path, String ... hosts) throws UserStoreException {
        UserStoreClient client;
        String attribute = null;
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getUserStoreData: Retrieving data from UStore instances for " + aor + " on path " + path));
        }
        if ((client = this.getUStoreClient()) == null) {
            return null;
        }
        attribute = client.getData(String.class, aor.getUri(), path, hosts);
        return attribute;
    }

    @SMConsole(description="Store some data into the User Store", parameterNames={"user", "domain", "path", "data", "hosts"})
    public void setUserStoreData(String user, String domain, String path, String data, String ... hosts) throws UserStoreException {
        String aorStr = this.createAOR(user, domain);
        UserStoreClient client = this.getUStoreClient();
        if (client == null) {
            return;
        }
        client.storeData(aorStr, path, data, hosts);
    }

    protected String createAOR(String user, String domain) {
        return user + "@" + domain;
    }

    protected List<String> getRandomizedASMSipEntityList(Integer maxNonSIPEntries) {
        ArrayList<String> seList = new ArrayList<String>();
        for (Instance instance : this.getAsmInstanceDAO().getAllAsmInstances().values()) {
            SIPEntity se;
            if (instance.isBranch() || (se = this.getSIPEntityDAO().getSIPEntity(instance.getSipEntityId())) == null) continue;
            seList.add(se.getFqdnoripaddr());
        }
        Collections.shuffle(seList);
        if (maxNonSIPEntries != null && seList.size() > maxNonSIPEntries) {
            return seList.subList(0, maxNonSIPEntries);
        }
        return seList;
    }

    public Boolean isNonSIPUser(String aorURI) {
        UserDomainAOR aor = new UserDomainAOR(aorURI);
        Long cpSetId = this.getCommProfileSetId(aor.getUser(), aor.getDomain());
        if (cpSetId != null) {
            return this.getSetCommunityDAO().getUserCommunityId(cpSetId) == null;
        }
        return null;
    }

    @Override
    @SMConsole(description="Get the ordered User Store IP addresses for which the AOR is assigned - SIP Entity.  The aor is of the form 'user@domain'.  If the user is a non-SIP user, maxNonSIPEntries is applied.", parameterNames={"aor", "maxNonSIPEntries "})
    public String[] getOrderedUStoreIPs(String aorURI, Integer maxNonSIPEntries) {
        UserDomainAOR aor = new UserDomainAOR(aorURI);
        List<String> hostList = this.getUserHomeASMSipEntityIPs(aor.getUser(), aor.getDomain());
        if (hostList.size() == 0 && Boolean.TRUE.equals(this.isNonSIPUser(aorURI))) {
            hostList = this.getRandomizedASMSipEntityList(maxNonSIPEntries);
        }
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getOrderedUStoreIPs: For aorURI=" + aorURI + ", the authoritative SMs are " + hostList));
        }
        return hostList.toArray(new String[0]);
    }

    static {
        serviceDM = null;
    }

    public static enum platDM implements BLDMEnumType
    {
        ASM_COMMPROFILE_DAO(AsmCommProfileDAO.class),
        CS_DOMAIN_DAO(CsDomainDAO.class),
        CS_HANDLE_DAO(CsHandleDAO.class),
        SET_COMMUNITY_DAO(SetCommunityDAO.class),
        SIP_ENTITY_DAO(SIPEntityDAO.class),
        USER_COMMUNITY_DAO(UserCommunityDAO.class),
        ASM_INSTANCE_DAO(AsmInstanceDAO.class);

        private Class<? extends DataMgr> subDM;

        private platDM(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return DefaultUStoreNodeIdentifier.getFactory().getDataMgr(this.subDM);
        }
    }
}

