/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.CallHistoryDM_FP4;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.SMCallHistoryAPI_FP4;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.UserSetDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SMCallHistoryDM_FP4
extends DataAccessObject
implements SMCallHistoryAPI_FP4 {
    CallHistoryDM_FP4 callHistoryDM_FP4 = new CallHistoryDM_FP4();
    private final Logger log = AsmLogger.getLogger(SMCallHistoryDM_FP4.class);
    private static DMFactory factory;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    @Override
    public void addCallHistory(long cscommprofilesetId, Integer maxLogs, List<CallLog> callLogs) {
        String fcn_name = "addCallHistory";
        Long csuserId = ((UserSetDAO)dmTypes.USER_SET_DAO.get()).getUserId(cscommprofilesetId);
        if (csuserId == null) {
            this.log.warn((Object)("addCallHistory: cannot get csuserId for set id " + cscommprofilesetId));
            return;
        }
        try {
            this.callHistoryDM_FP4.addCallHistory(csuserId, cscommprofilesetId, maxLogs, callLogs);
        }
        catch (DMException exc) {
            this.log.error((Object)("addCallHistory: DMException thrown by callHistoryDM.addCallHistory() for csuserId=" + csuserId + ", cscommprofilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs + ", callLogs=" + callLogs), (Throwable)exc);
        }
    }

    @Override
    public void deleteCallHistoryById(long cscommprofilesetId, List<UUID> callLogUuids) {
        String fcn_name = "deleteCallHistoryById";
        Long csuserId = ((UserSetDAO)dmTypes.USER_SET_DAO.get()).getUserId(cscommprofilesetId);
        if (csuserId == null) {
            this.log.warn((Object)("deleteCallHistoryById: cannot get csuserId for set id " + cscommprofilesetId));
            return;
        }
        try {
            this.callHistoryDM_FP4.deleteCallHistoryById(csuserId, cscommprofilesetId, callLogUuids);
        }
        catch (DMException exc) {
            this.log.error((Object)("deleteCallHistoryById: DMException thrown by callHistoryDM.deleteCallHistoryById() for csuserId=" + csuserId + ", cscommprofilesetId=" + cscommprofilesetId + ", callLogUuids=" + callLogUuids), (Throwable)exc);
        }
    }

    @Override
    public void deleteCallHistoryByLimit(long cscommprofilesetId, int maxLogs) {
        String fcn_name = "deleteCallHistoryByLimit";
        Long csuserId = ((UserSetDAO)dmTypes.USER_SET_DAO.get()).getUserId(cscommprofilesetId);
        if (csuserId == null) {
            this.log.warn((Object)("deleteCallHistoryByLimit: cannot get csuserId for set id " + cscommprofilesetId));
            return;
        }
        try {
            this.callHistoryDM_FP4.deleteCallHistoryByLimit(csuserId, cscommprofilesetId, maxLogs);
        }
        catch (DMException exc) {
            this.log.error((Object)("deleteCallHistoryByLimit: DMException thrown by callHistoryDM.deleteCallHistoryById() for csuserId=" + csuserId + ", cscommprofilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs), (Throwable)exc);
        }
    }

    @Override
    public void deleteAllCallHistory(long csuserId) {
        String fcn_name = "deleteAllCallHistory";
        try {
            this.callHistoryDM_FP4.deleteAllCallHistory(csuserId);
        }
        catch (DMException exc) {
            this.log.error((Object)("deleteAllCallHistory: DMException thrown by callHistoryDM.deleteCallHistoryById() for csuserId=" + csuserId), (Throwable)exc);
        }
    }

    @Override
    public List<CallLog> getCallHistory(long cscommprofilesetId, Integer maxLogs) {
        String fcn_name = "getCallHistory";
        Long csuserId = ((UserSetDAO)dmTypes.USER_SET_DAO.get()).getUserId(cscommprofilesetId);
        if (csuserId == null) {
            this.log.warn((Object)("getCallHistory: cannot get csuserId for set id " + cscommprofilesetId));
            return null;
        }
        try {
            return this.callHistoryDM_FP4.getCallHistory(csuserId, cscommprofilesetId, maxLogs);
        }
        catch (DMException exc) {
            this.log.error((Object)("getCallHistory: DMException thrown by callHistoryDM.getCallHistoryById() for csuserId=" + csuserId + ", cscommprofilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs), (Throwable)exc);
            return null;
        }
    }

    @Override
    public void init() {
        this.log.info((Object)"Started initializing SMCallHistoryDM");
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (dmTypes dm : dmTypes.values()) {
            DataMgr dataMgr = dm.get();
            if (dataMgr.okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
        this.log.info((Object)"Finished initializing SMCallHistoryDM");
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        boolean isFine = this.log.isFineEnabled();
        if (isFine) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        if (operation == DAOReplicationEvent.OperationType.DELETE) {
            if (isFine) {
                this.log.fine((Object)("user deleted so delete call log history for id " + id));
            }
            this.deleteAllCallHistory(id);
        }
        if (isFine) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return null;
    }

    public static enum dmTypes implements BLDMEnumType
    {
        USER_SET_DAO(UserSetDAO.class);

        private Class<? extends DataMgr> subDM;

        private dmTypes(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return SMCallHistoryDM_FP4.getFactory().getDataMgr(this.subDM);
        }
    }
}

