/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.helpers.FlexCache;
import com.avaya.asm.datamgr.loadrulekeys.CacheSize;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.asm.datamgr.objectapi.CsCommProfile;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={CacheSize.class})
public class CsCommProfileDAO
extends IsDeletedHandler {
    private final Logger log = AsmLogger.getLogger(CsCommProfileDAO.class);
    protected Map<Long, CsCommProfile> csCommProfileMap = new HashMap<Long, CsCommProfile>();
    protected FlexCache<Long, Set<Long>> setIdMap = new FlexCache();
    public static final String getCsCommProfiles = "SELECT cs.id, cs.commprofiletype, cs.cscommprofilesetid, cs.preferredhandleid FROM cscommprofile cs WHERE cs.cscommprofilesetid NOT IN (" + IsDeletedHandler.isDeletedCommProfileSetId + ")";
    public static final String getCsCommProfilesBySurvivableId = "SELECT outercs.id, outercs.commprofiletype, outercs.cscommprofilesetid, outercs.preferredhandleid FROM cscommprofile outercs WHERE outercs.cscommprofilesetid IN (SELECT cs.cscommprofilesetid FROM cscommprofile cs JOIN asmcommprofile asm ON cs.id=asm.id JOIN cscommprofileset set ON set.id = cs.cscommprofilesetid WHERE asm.survivability_server_id = ?) AND outercs.cscommprofilesetid NOT IN (" + IsDeletedHandler.isDeletedCommProfileSetId + ")";
    public static final String getCsCommProfileBase = "SELECT cs.id, cs.commprofiletype, cs.cscommprofilesetid, cs.preferredhandleid FROM cscommprofile cs, cscommprofileset set, csuser u WHERE cs.cscommprofilesetid = set.id AND set.csuserid=u.id AND u.isdeleted=false";
    public static final String getCsCommProfile = "SELECT cs.id, cs.commprofiletype, cs.cscommprofilesetid, cs.preferredhandleid FROM cscommprofile cs, cscommprofileset set, csuser u WHERE cs.cscommprofilesetid = set.id AND set.csuserid=u.id AND u.isdeleted=false AND cs.id = ?";
    public static final String getCsCommProfileBySetId = "SELECT cs.id, cs.commprofiletype, cs.cscommprofilesetid, cs.preferredhandleid FROM cscommprofile cs, cscommprofileset set, csuser u WHERE cs.cscommprofilesetid = set.id AND set.csuserid=u.id AND u.isdeleted=false AND set.id = ?";
    private int capacity = 1;
    protected static final ResultSetMapper csCommProfileMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, CsCommProfile> profileMap = new HashMap<Long, CsCommProfile>();
            while (rs.next()) {
                long id = rs.getLong("id");
                profileMap.put(id, new CsCommProfile(id, rs.getString("commprofiletype"), (Long)rs.getObject("cscommprofilesetid"), (Long)rs.getObject("preferredhandleid")));
            }
            return profileMap;
        }
    };

    public CsCommProfileDAO() {
        super(false);
        this.getIdsByUserId = "SELECT cs.id, u.isdeleted FROM cscommprofile cs, csuser u, cscommprofileset set WHERE cs.cscommprofilesetid=set.id AND set.csuserid=u.id AND u.id = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdsDeleted(Set<FlexCache.EvictEntry<Long, Set<Long>>> deleted) {
        if (deleted.size() == 0) {
            return;
        }
        try {
            this.lock.acquireWriteLock();
            for (FlexCache.EvictEntry<Long, Set<Long>> entry : deleted) {
                for (Long profileId : entry.getValue()) {
                    this.csCommProfileMap.remove(profileId);
                }
            }
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    protected int getCapacity() {
        return this.capacity;
    }

    protected void setCapacity(int capacity) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to directly set Load Rule!");
        }
        this.capacity = capacity;
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        int bestCacheValue = 1;
        block0: for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("cachesize".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    int cap = Integer.parseInt(value);
                    if (cap <= 0) {
                        bestCacheValue = -1;
                        continue block0;
                    }
                    if (bestCacheValue == -1 || cap <= bestCacheValue) continue;
                    bestCacheValue = cap;
                }
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (bestCacheValue != this.capacity) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting FlexCache capacity to " + bestCacheValue));
            }
            this.capacity = bestCacheValue;
            reinit = true;
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)DMFactory.getInstance().getDataMgr(AsmInstanceDAO.class);
    }

    protected UserCommunityDAO getUserCommunityDAO() {
        return (UserCommunityDAO)DMFactory.getInstance().getDataMgr(UserCommunityDAO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        FlexCache setIdMapTMP = new FlexCache();
        Map csCommProfileMapTMP = new HashMap();
        try {
            HashMap profileIdsBySetId = new HashMap();
            if (this.getCapacity() >= 0) {
                Long myEntityId = this.getAsmInstanceDAO().getMySIPEntityId();
                if (myEntityId != null) {
                    Object[] params = new Object[]{myEntityId};
                    csCommProfileMapTMP = (Map)this.dataSource.executeQuery(getCsCommProfilesBySurvivableId, params, csCommProfileMapper);
                }
            } else {
                Object[] params = new Object[]{};
                csCommProfileMapTMP = (Map)this.dataSource.executeQuery(getCsCommProfiles, params, csCommProfileMapper);
            }
            for (CsCommProfile profile : csCommProfileMapTMP.values()) {
                Long setId = profile.getCsCommProfileSetId();
                if (!profileIdsBySetId.containsKey(setId)) {
                    profileIdsBySetId.put(setId, new HashSet());
                }
                ((Set)profileIdsBySetId.get(setId)).add(profile.getId());
            }
            setIdMapTMP = new FlexCache(this.getCapacity(), profileIdsBySetId, true);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        catch (Exception e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.csCommProfileMap = csCommProfileMapTMP;
                this.setIdMap = setIdMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if ("csuser".equals(tableName)) {
            super.updateDAO(event);
            return;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        CsCommProfile newProfile = null;
        boolean lockHeld = false;
        try {
            Long setId;
            if (this.getCapacity() < 0 && operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                Map map = (Map)this.dataSource.executeQuery(getCsCommProfile, params, csCommProfileMapper);
                newProfile = (CsCommProfile)map.get(id);
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            CsCommProfile oldProfile = this.csCommProfileMap.remove(id);
            if (oldProfile != null) {
                setId = oldProfile.getCsCommProfileSetId();
                this.setIdMap.get(setId).remove(id);
                if (this.setIdMap.get(setId).isEmpty()) {
                    this.setIdMap.remove(setId);
                }
            }
            if (newProfile != null) {
                this.csCommProfileMap.put(id, newProfile);
                setId = newProfile.getCsCommProfileSetId();
                if (!this.setIdMap.containsKey(setId)) {
                    Set<FlexCache.EvictEntry<Long, Set<Long>>> evicted = this.setIdMap.putReportEviction(setId, new HashSet());
                    this.setIdsDeleted(evicted);
                }
                this.setIdMap.get(setId).add(newProfile.getId());
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public String getMainTable() {
        return "cscommprofile";
    }

    @Override
    protected Object getMainCollection() {
        return this.csCommProfileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CsCommProfile> getCsCommProfiles(Long setId) {
        HashSet<CsCommProfile> retVal = new HashSet<CsCommProfile>();
        if (setId == null) {
            return retVal;
        }
        Set<Long> profileIds = null;
        try {
            this.lock.acquireReadLock();
            profileIds = this.setIdMap.get(setId);
            if (profileIds != null) {
                for (Long id : profileIds) {
                    retVal.add(this.csCommProfileMap.get(id));
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (profileIds != null) {
            return retVal;
        }
        if (this.getCapacity() < 0) {
            return retVal;
        }
        Map mapProfiles = null;
        try {
            Map tmpMap;
            Object[] params = new Object[]{setId};
            mapProfiles = tmpMap = (Map)this.dataSource.executeQuery(getCsCommProfileBySetId, params, csCommProfileMapper);
            profileIds = new HashSet<Long>();
            if (this.log.isFinerEnabled()) {
                this.log.finer((Object)("Read object(s) into FlexCache: " + mapProfiles));
            }
            for (CsCommProfile entry : mapProfiles.values()) {
                retVal.add(entry);
                profileIds.add(entry.getId());
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading CommProfiles into cache for commProfileSetID " + setId), (Throwable)e);
        }
        if (profileIds != null && profileIds.size() > 0) {
            try {
                this.lock.acquireWriteLock();
                this.csCommProfileMap.putAll(mapProfiles);
                Set<FlexCache.EvictEntry<Long, Set<Long>>> evicted = this.setIdMap.putReportEviction(setId, profileIds);
                this.setIdsDeleted(evicted);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"commProfileSetId", "commProfileType"}, description="Get the Preferred Handle ID given the parameters.")
    public Long getPreferredHandleId(Long commProfileSetId, String commProfileType) {
        block5: {
            this.getCsCommProfiles(commProfileSetId);
            try {
                this.lock.acquireReadLock();
                Set<Long> profileIds = this.setIdMap.get(commProfileSetId);
                if (profileIds == null) break block5;
                for (Long id : profileIds) {
                    CsCommProfile profile = this.csCommProfileMap.get(id);
                    if (!profile.getType().equals(commProfileType)) continue;
                    Long l = profile.getPreferredHandleId();
                    return l;
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Show all CsCommProfiles loaded into memory, which may or may not be all data in the database")
    public String getCsCommProfiles() {
        try {
            this.lock.acquireReadLock();
            StringBuilder gather = new StringBuilder("setIdMap: {");
            boolean first = true;
            for (Map.Entry<Long, Set<Long>> entry : this.setIdMap.entrySet()) {
                if (!first) {
                    gather.append(", ");
                }
                gather.append(entry.getKey());
                gather.append("=");
                gather.append(entry.getValue());
                first = false;
            }
            gather.append("}");
            gather.append("\n\ncsCommProfileMap: {");
            first = true;
            for (Map.Entry<Long, Object> entry : this.csCommProfileMap.entrySet()) {
                if (!first) {
                    gather.append(", ");
                }
                gather.append(entry.getKey());
                gather.append("=");
                gather.append(entry.getValue());
                first = false;
            }
            gather.append("}");
            String string = gather.toString();
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public static void main(String[] args) {
        System.out.println("getCsCommProfiles=" + getCsCommProfiles);
        System.out.println("getCsCommProfilesBySurvivableId=" + getCsCommProfilesBySurvivableId);
        System.out.println("getCsCommProfile=SELECT cs.id, cs.commprofiletype, cs.cscommprofilesetid, cs.preferredhandleid FROM cscommprofile cs, cscommprofileset set, csuser u WHERE cs.cscommprofilesetid = set.id AND set.csuserid=u.id AND u.isdeleted=false AND cs.id = ?");
        System.out.println("getCsCommProfileBySetId=SELECT cs.id, cs.commprofiletype, cs.cscommprofilesetid, cs.preferredhandleid FROM cscommprofile cs, cscommprofileset set, csuser u WHERE cs.cscommprofilesetid = set.id AND set.csuserid=u.id AND u.isdeleted=false AND set.id = ?");
        CsCommProfileDAO dao = new CsCommProfileDAO();
        System.out.println("getIdsByUserId=" + dao.getIdsByUserId);
    }
}

