/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.core.SMConsole;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.dao.LocalSipObjectDAO;
import com.avaya.asm.datamgr.objectapi.LocalObject;
import com.avaya.asm.datamgr.objectapi.LocalUser;
import java.util.Collection;
import java.util.Collections;

public class LocalUserDAO
extends LocalSipObjectDAO {
    static boolean isBranchFlag = DMUtilities.isBranch();
    private String getLocalIDs_SM = "SELECT u.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, asmusercommunityassign uca WHERE u.id = set.csuserid AND set.id = cs.cscommprofilesetid AND u.isDeleted = false AND cs.id = asm.id AND asm.usercommunity_id = uca.asmusercommunity_id AND uca.asminstance_id = ?";
    private String getLocalIDs_BSM = "SELECT u.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, asminstance ai WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND u.isDeleted = false AND asm.survivability_server_id = ai.sipentity_id AND ai.id=?";
    protected String getLocalIDsQuery = isBranchFlag ? this.getLocalIDs_BSM : this.getLocalIDs_SM;
    private String getDeletedByUserId_SM = "SELECT u.isdeleted, u.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, asmusercommunityassign uca WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND cs.commprofiletype = 'SIP' AND asm.id = cs.id AND uca.asmusercommunity_id = asm.usercommunity_id AND uca.asminstance_id = ? AND u.id = ?";
    private String getDeletedByUserId_BSM = "SELECT u.isdeleted, u.id, asm.id AS asmid FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, asminstance ai WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND asm.survivability_server_id = ai.sipentity_id AND ai.id=? AND u.id = ?";
    protected String getDeletedByUserIdQuery = isBranchFlag ? this.getDeletedByUserId_BSM : this.getDeletedByUserId_SM;
    private String isLocal_SM = this.getLocalIDs_SM + " AND asm.id = ?";
    private String isLocal_BSM = this.getLocalIDs_BSM + " AND asm.id = ?";
    protected String isLocalQuery = isBranchFlag ? this.isLocal_BSM : this.isLocal_SM;

    @Override
    protected LocalObject construct(long id) {
        return new LocalUser(id);
    }

    @Override
    protected String getMainTable() {
        return "csuser";
    }

    @SMConsole(description="Print a list of all local CsUser IDs. This list will contain duplicates if CsUsers have multiple CommProfileSets under them.")
    public Collection<Long> getLocalUserIDs() {
        this.lock.acquireReadLock();
        try {
            Collection<Long> collection = Collections.unmodifiableCollection(this.mainCollection.values());
            return collection;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @Override
    protected String getLocalIDsQuery() {
        return this.getLocalIDsQuery;
    }

    @Override
    protected String isLocalQuery() {
        return this.isLocalQuery;
    }

    @Override
    protected String getDeletedByUserIdQuery() {
        return this.getDeletedByUserIdQuery;
    }

    public static void main(String[] args) {
        LocalUserDAO dao = new LocalUserDAO();
        dao.printQueries();
    }
}

