/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkDomainDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(NetworkDomainDAO.class);
    private Map<Long, String> idMap = new HashMap<Long, String>();
    private Map<String, Long> networkDomainMap = new HashMap<String, Long>();
    protected static final String getNetworkDomains = "SELECT id, network_domain FROM asm_dod_network_domain";
    protected static final String getNetworkDomain = "SELECT network_domain FROM asm_dod_network_domain WHERE id = ?";
    protected static final ResultSetMapper networkDomainsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList list = new ArrayList();
            HashMap<Long, String> idMap = new HashMap<Long, String>();
            HashMap<String, Long> networkDomainMap = new HashMap<String, Long>();
            while (rs.next()) {
                long id = rs.getLong("id");
                String name = rs.getString("network_domain").toLowerCase();
                idMap.put(id, name);
                networkDomainMap.put(name, id);
            }
            list.add(idMap);
            list.add(networkDomainMap);
            return list;
        }
    };
    protected static final ResultSetMapper networkDomainMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getString("network_domain").toLowerCase();
            }
            return null;
        }
    };

    public NetworkDomainDAO() {
        super(false);
    }

    protected ResultSetMapper getNetworkDomainsMapper() {
        return networkDomainsMapper;
    }

    protected ResultSetMapper getNetworkDomainMapper() {
        return networkDomainMapper;
    }

    @Override
    protected Object getMainCollection() {
        return this.idMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        HashMap networkDomainMapTMP;
        HashMap idMapTMP;
        if (log.isFineEnabled()) {
            log.fine((Object)("Initializing " + NetworkDomainDAO.class.getSimpleName()));
        }
        Object[] params = new Object[]{};
        try {
            List list = (List)this.dataSource.executeQuery(getNetworkDomains, params, this.getNetworkDomainsMapper());
            idMapTMP = (HashMap)list.get(0);
            networkDomainMapTMP = (HashMap)list.get(1);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.idMap = idMapTMP;
                this.networkDomainMap = networkDomainMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asm_dod_network_domain");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (log.isFineEnabled()) {
            log.fine((Object)this.logTag(operation, tableName, id));
        }
        String newNetworkDomain = null;
        boolean lockHeld = false;
        try {
            Object[] params;
            if (operation != DAOReplicationEvent.OperationType.DELETE && (newNetworkDomain = (String)this.dataSource.executeQuery(getNetworkDomain, params = new Object[]{id}, this.getNetworkDomainMapper())) != null && log.isFinerEnabled()) {
                log.finer((Object)("Retrieved new network domain " + newNetworkDomain));
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            String oldDomain = this.idMap.remove(id);
            if (oldDomain != null) {
                this.networkDomainMap.remove(oldDomain);
            }
            if (newNetworkDomain != null) {
                this.idMap.put(id, newNetworkDomain);
                this.networkDomainMap.put(newNetworkDomain, id);
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (log.isFineEnabled()) {
            log.fine((Object)(NetworkDomainDAO.class.getSimpleName() + " update successful"));
        }
    }

    public String getNetworkDomain(Long id) {
        try {
            this.lock.acquireReadLock();
            String string = this.idMap.get(id);
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public Long getNetworkDomainId(String networkDomain) {
        if (networkDomain != null) {
            try {
                this.lock.acquireReadLock();
                Long l = this.networkDomainMap.get(networkDomain.toLowerCase());
                return l;
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    @SMConsole(description="Get all provisioned Network Domains.")
    public Map<String, Long> getNetworkDomainNameMap() {
        try {
            this.lock.acquireReadLock();
            Map<String, Long> map = Collections.unmodifiableMap(this.networkDomainMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned Network Domains.")
    public Map<Long, String> getAllNetworkDomains() {
        try {
            this.lock.acquireReadLock();
            Map<Long, String> map = Collections.unmodifiableMap(this.idMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

