/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DigitMapRouterDAO;
import com.avaya.asm.datamgr.dao.branch.BranchRoutePolicyDAO;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.DigitMapRouter;
import com.avaya.asm.datamgr.objectapi.DigitMapRow;
import com.avaya.common.logging.client.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BranchDigitMapRouterDAO
extends DigitMapRouterDAO {
    private final Logger log = AsmLogger.getLogger(BranchDigitMapRouterDAO.class);
    protected static final String queryEmergencyDMR = "SELECT id, mindigits, maxdigits, digitpattern, deny, routingorigination_id, sipdomain_id, digitmap_origination_pattern_set_id, treatasemergency FROM digitmap WHERE treatasemergency = true";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        if (this.log.isFineEnabled()) {
            this.log.info((Object)("Initializing " + BranchDigitMapRouterDAO.class.getSimpleName()));
        }
        HashMap<Long, Map<Long, Map<Long, DigitMapRouter>>> dmrMapTMP = new HashMap<Long, Map<Long, Map<Long, DigitMapRouter>>>();
        HashMap<Long, DigitMapRow> digitMapTableTMP = new HashMap<Long, DigitMapRow>();
        try {
            DMException innerException = null;
            Set<Long> digitMapIds = ((BranchRoutePolicyDAO)this.getDataMgr(BranchRoutePolicyDAO.class)).getDigitMapIds();
            for (Long id : digitMapIds) {
                try {
                    Object[] params = new Object[]{id};
                    Map rows = (Map)this.dataSource.executeQuery("SELECT id, mindigits, maxdigits, digitpattern, deny, routingorigination_id, sipdomain_id, digitmap_origination_pattern_set_id, treatasemergency FROM digitmap WHERE id = ?", params, digitMapRowsMapper);
                    DigitMapRow row = (DigitMapRow)rows.get(id);
                    if (row == null) {
                        throw new DMException("Digit map row query returned null");
                    }
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("Retrieved new DigitMapRow " + row));
                    }
                    digitMapTableTMP.put(id, row);
                    this.insertRowIntoDmrMap(dmrMapTMP, id, row);
                }
                catch (DMException e1) {
                    this.setStatus(DataMgr.Status.FAIL);
                    this.log.error((Object)("Error on initializing for digitMapId=" + id), (Throwable)e1);
                    innerException = e1;
                }
            }
            Object[] params = new Object[]{};
            Map rows = (Map)this.dataSource.executeQuery(queryEmergencyDMR, params, digitMapRowsMapper);
            for (Map.Entry entry : rows.entrySet()) {
                try {
                    Long id = (Long)entry.getKey();
                    if (digitMapIds.contains(id)) continue;
                    DigitMapRow row = (DigitMapRow)entry.getValue();
                    digitMapTableTMP.put(id, row);
                    this.insertRowIntoDmrMap(dmrMapTMP, id, row);
                }
                catch (DMException e1) {
                    this.setStatus(DataMgr.Status.FAIL);
                    this.log.error((Object)("Error on initializing for key=" + entry.getKey() + ", and value=" + entry.getValue()), (Throwable)e1);
                    innerException = e1;
                }
            }
            if (this.failed() && innerException != null) {
                throw innerException;
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e2) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e2);
            this.handleFailureEvent(e2);
        }
        try {
            this.lock.acquireWriteLock();
            this.dmrMap = dmrMapTMP;
            this.digitMapTable = digitMapTableTMP;
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    @Override
    public synchronized void updateDAO(DAOTableEvent event) {
        this.log.fine((Object)"updateDAO: reinitialize");
        this.reinit();
    }

    @Override
    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }
}

