/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.Uptime;
import com.avaya.asm.core.exceptions.ConnectionPoolInitializerException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.ReadWriteLockHandler;
import com.avaya.asm.datamgr.helpers.CassandraConnectionInfo;
import com.avaya.asm.datamgr.helpers.ConnectionPoolInitializer;
import com.avaya.asm.datamgr.helpers.ConnectionPoolInitializerClient;
import com.avaya.asm.datamgr.listener.cassandra.ClusterChangeNotifier;
import com.avaya.asm.datamgr.listener.cassandra.HostStateListener;
import com.avaya.asm.datamgr.listener.cassandra.SchemaChangeNotifier;
import com.avaya.asm.datamgr.listener.cassandra.SchemaUpdateListener;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CassandraClientProperties;
import com.avaya.ustore.CassandraSSLOptions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.QueryLogger;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class CassandraBasedDAO
implements ConnectionPoolInitializerClient {
    private final Logger log = AsmLogger.getLogger(CassandraBasedDAO.class);
    static final int RECONN_RETRYTIME_MS = 1000;
    static final int TOTAL_CONNECT_RETRY_TIME_MS = 50000;
    private static final int READ_TIMEOUT_MS = 40000;
    private static final int HEARTBEAT_TIMEOUT_MS = 60000;
    private ReconnectionPolicy reconnPolicy = new CBDReconnectionPolicy();
    private Cluster cluster = null;
    private CassandraConnectionInfo cConnInfo = null;
    private String dbUsername = null;
    private String dbPassword = null;
    private Cluster.Builder builder = null;
    private ReadWriteLockHandler clusterLock = new ReadWriteLockHandler(CassandraBasedDAO.class.getSimpleName());
    private ThreadLocal<Integer> readLockCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private int clusterInstance = 0;
    private HostStateListener hostStateListener = new HostStateListener(this);
    private SchemaUpdateListener schemaUpdateListener = new SchemaUpdateListener(this);
    private QueryLogger queryLogger = null;
    private int numConsecutiveFailures = 0;
    private ConnectionPoolInitializer connPoolInitializer = new ConnectionPoolInitializer(50000);

    public CassandraBasedDAO(CassandraConnectionInfo cassandraConnectionInfo, String dbUsername, String dbPassword) throws DMException {
        this.cConnInfo = cassandraConnectionInfo;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.builder = this.createClusterBuilder();
        this.createCluster();
    }

    protected void initConnectionPool() throws DMException, UnknownHostException {
        boolean isFiner;
        block28: {
            String fcn_name = "initConnectionPool";
            boolean isInfo = this.log.isInfoEnabled();
            boolean isFinest = this.log.isFinestEnabled();
            isFiner = this.log.isFinerEnabled();
            if (isFiner) {
                this.log.finer((Object)("initConnectionPool: enter, numConsecutiveFailures=" + this.numConsecutiveFailures));
            }
            this.clusterInit();
            if (this.numConsecutiveFailures == 0) {
                try {
                    this.testQueryWithMyCluster();
                    if (isFinest) {
                        this.log.finest((Object)"initConnectionPool: testQueryWithMyCluster succeeded, numConsecutiveFailures==0");
                    }
                }
                catch (DMException exc) {
                    this.log.finest((Object)"initConnectionPool: DMException thrown from testQueryWithMyCluster(), numConsecutiveFailures==0", (Throwable)exc);
                    ++this.numConsecutiveFailures;
                }
            }
            if (this.numConsecutiveFailures == 1) {
                long startTime = Uptime.getUptimeMS();
                long endTime = startTime + 50000L;
                int sleepTimeMS = 1500;
                int i = 0;
                if (isInfo) {
                    this.log.info((Object)"initConnectionPool: first time Cassandra connection problems, waiting up to 50000ms");
                }
                while (true) {
                    if (isFinest) {
                        this.log.info((Object)("initConnectionPool: iteration " + i + ", waiting " + sleepTimeMS + "ms"));
                    }
                    try {
                        Thread.sleep(sleepTimeMS);
                    }
                    catch (InterruptedException e) {
                        String msg = "initConnectionPool: interrupted waiting " + sleepTimeMS + "ms, iteration " + i;
                        if (isFiner) {
                            this.log.finer((Object)msg);
                        }
                        throw new DMException(msg, e);
                    }
                    try {
                        this.testQueryWithMyCluster();
                        if (isFinest) {
                            this.log.finest((Object)("initConnectionPool: testQueryWithMyCluster succeeded, iteration=" + i));
                        }
                        break block28;
                    }
                    catch (DMException exc) {
                        if (isFinest) {
                            this.log.finest((Object)("initConnectionPool: DMException thrown from testQueryWithMyCluster(), endTime=" + endTime + ", upTime=" + Uptime.getUptimeMS()), (Throwable)exc);
                        }
                        if (Uptime.getUptimeMS() >= endTime) {
                            try {
                                this.recoverCluster();
                                break block28;
                            }
                            catch (Exception exc2) {
                                if (isFinest) {
                                    this.log.finest((Object)("initConnectionPool: recoverCluster threw a Exception: " + exc2));
                                }
                                ++this.numConsecutiveFailures;
                                throw exc;
                            }
                        }
                        if (isFinest) {
                            this.log.finest((Object)("initConnectionPool: testQuery failed, iteration=" + i));
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            if (this.numConsecutiveFailures >= 2) {
                if (isFinest) {
                    this.log.finest((Object)("initConnectionPool: numConsecutiveFailures=" + this.numConsecutiveFailures));
                }
                try {
                    this.recoverCluster();
                }
                catch (Exception exc) {
                    if (isFinest) {
                        this.log.finest((Object)"initConnectionPool: Exception thrown by recoverCluster", (Throwable)exc);
                    }
                    ++this.numConsecutiveFailures;
                    throw exc;
                }
                if (isFinest) {
                    this.log.finest((Object)"initConnectionPool: testQuery succeeded");
                }
            }
        }
        this.connectionEstablished();
        if (isFiner) {
            this.log.finer((Object)"initConnectionPool: leave, success!");
        }
    }

    private void recoverCluster() throws DMException {
        boolean clusterOK;
        boolean isFinest;
        boolean isFiner;
        block7: {
            String fcn_name = "recoverCluster";
            isFiner = this.log.isFinerEnabled();
            isFinest = this.log.isFinestEnabled();
            if (isFiner) {
                this.log.finer((Object)"recoverCluster: enter");
            }
            this.log.info((Object)("recoverCluster: attempting to recover cluster " + this.cluster));
            this.testQueryWithTempCluster();
            clusterOK = false;
            if (!this.cluster.isClosed()) {
                try {
                    this.testQueryWithMyCluster();
                    clusterOK = true;
                }
                catch (Exception exc) {
                    if (!isFinest) break block7;
                    this.log.finest((Object)"recoverCluster: testQueryWithMyCluster threw an Exception, create a new cluster", (Throwable)exc);
                }
            }
        }
        if (!clusterOK) {
            if (isFinest) {
                this.log.finest((Object)"recoverCluster: closing cluster");
            }
            this.createCluster();
            this.clusterInit();
        }
        if (isFiner) {
            this.log.finer((Object)"recoverCluster: leave");
        }
    }

    protected void noHostAvailable() {
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "noHostAvailable";
        if (isFiner) {
            this.log.finer((Object)("noHostAvailable: enter, numConsecutiveFailures=" + this.numConsecutiveFailures));
        }
        ++this.numConsecutiveFailures;
        this.connPoolInitializer.reportError(this);
        if (isFiner) {
            this.log.finer((Object)"noHostAvailable: leave");
        }
    }

    private void connectionEstablished() {
        String fcn_name = "connectionEstablished";
        boolean isInfo = this.log.isInfoEnabled();
        StringBuffer sbuf = new StringBuffer("connectionEstablished");
        sbuf.append(": Cassandra connection ");
        if (this.numConsecutiveFailures > 0) {
            sbuf.append("re-");
        }
        sbuf.append("established!");
        if (isInfo) {
            this.log.info((Object)sbuf.toString());
        }
        this.numConsecutiveFailures = 0;
    }

    public void checkCluster() throws DMException, ConnectionPoolInitializerException {
        String fcn_name = "checkCluster";
        boolean isInfo = this.log.isInfoEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("checkCluster: enter, cluster=" + this.cluster));
        }
        try {
            this.connPoolInitializer.checkInit(this);
        }
        catch (ConnectionPoolInitializerException cpie) {
            String msg = "checkCluster: cluster initialization failed, cannot talk to Cassandra, exc=" + cpie;
            if (isInfo) {
                this.log.info((Object)msg);
            }
            Throwable cause = cpie.getCause();
            DMException dme = null;
            dme = cause instanceof DMException ? (DMException)cause : new DMException("checkCluster: cannot talk to Cassandra", cpie);
            throw dme;
        }
        if (isFiner) {
            this.log.finer((Object)("checkCluster:, leave, cluster=" + this.cluster));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCluster() throws DMException {
        String fcn_name = "createCluster";
        boolean isInfo = this.log.isInfoEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("createCluster: enter, clusterInstance=" + this.clusterInstance + ", cluster=" + this.cluster));
        }
        Integer numReadLocks = this.acquireClusterLock();
        try {
            if (this.cluster != null && !this.cluster.isClosed()) {
                this.log.info((Object)("createCluster: closing current cluster " + this.cluster));
                this.cluster.unregister((Host.StateListener)this.hostStateListener);
                this.cluster.unregister((SchemaChangeListener)this.schemaUpdateListener);
                if (this.queryLogger != null) {
                    this.cluster.unregister((LatencyTracker)this.queryLogger);
                }
                this.cluster.close();
            }
            this.cluster = this.builder.build();
            this.cluster.register((Host.StateListener)this.hostStateListener);
            this.cluster.register((SchemaChangeListener)this.schemaUpdateListener);
            ++this.clusterInstance;
            this.log.info((Object)("createCluster: created a new cluster " + this.cluster + ", clusterInstance=" + this.clusterInstance));
            CassandraConnectionInfo.ConstantQueryLogger cQueryLogger = this.cConnInfo.getConstQueryLogger();
            if (cQueryLogger != null) {
                Integer intVal;
                QueryLogger.Builder qlb = QueryLogger.builder();
                Long longVal = cQueryLogger.getSlowQueryThresholdMS();
                if (longVal != null) {
                    qlb.withConstantThreshold(longVal.longValue());
                }
                if ((intVal = cQueryLogger.getMaxLoggedParams()) != null) {
                    qlb.withMaxLoggedParameters(intVal.intValue());
                }
                if ((intVal = cQueryLogger.getMaxQueryStringLength()) != null) {
                    qlb.withMaxQueryStringLength(intVal.intValue());
                }
                if ((intVal = cQueryLogger.getMaxParamsValueLength()) != null) {
                    qlb.withMaxParameterValueLength(intVal.intValue());
                }
                this.queryLogger = qlb.build();
                this.cluster.register((LatencyTracker)this.queryLogger);
                String queryLoggerClass = QueryLogger.class.getName() + ".";
                Level[] logLevels = new Level[]{Level.TRACE, Level.DEBUG};
                block3: for (String qlLogger : new String[]{"NORMAL", "SLOW", "ERROR"}) {
                    Logger qlLog = AsmLogger.getLogger(queryLoggerClass + qlLogger);
                    for (Level logLevel : logLevels) {
                        if (!qlLog.isEnabledFor((Priority)logLevel)) continue;
                        this.log.info((Object)("createCluster: query logging for " + qlLogger + " is enabled for log level " + logLevel));
                        continue block3;
                    }
                }
                if (isFinest) {
                    this.log.finest((Object)("createCluster: registered QueryLogger=" + this.queryLogger));
                }
            }
        }
        finally {
            this.releaseClusterLock(numReadLocks);
        }
        if (isFiner) {
            this.log.finer((Object)("createCluster: leave, clusterInstance=" + this.clusterInstance + ", cluster=" + this.cluster));
        }
    }

    private Cluster.Builder createClusterBuilder() throws DMException {
        String fcn_name = "createClusterBuilder";
        boolean isInfo = this.log.isInfoEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        ArrayList<InetSocketAddress> addressList = new ArrayList<InetSocketAddress>();
        try {
            addressList.add(new InetSocketAddress(InetAddress.getByName(this.cConnInfo.getHost()), this.cConnInfo.getPort()));
        }
        catch (UnknownHostException e) {
            String msg = "createClusterBuilder: Failed to build the Cassandra cluster, exc=" + e;
            if (isInfo) {
                this.log.info((Object)msg);
            }
            throw new DMException("Caught an UnknownHostException while building the cluster.", e);
        }
        ArrayList<InetSocketAddress> addresses = addressList;
        SocketOptions sockOptions = new SocketOptions();
        sockOptions.setReadTimeoutMillis(40000);
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setHeartbeatIntervalSeconds(60);
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setConsistencyLevel(ConsistencyLevel.ONE);
        Cluster.Builder builder = new Cluster.Builder().withReconnectionPolicy(this.reconnPolicy).withoutMetrics().withCredentials(this.dbUsername, this.dbPassword).withSocketOptions(sockOptions).withPoolingOptions(poolingOptions).withQueryOptions(queryOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new WhiteListPolicy((LoadBalancingPolicy)new RoundRobinPolicy(), addresses));
        CassandraClientProperties ccp = CassandraClientProperties.getInstance();
        Boolean sslPropertyEnabled = null;
        if (ccp == null) {
            this.log.error((Object)"createClusterBuilder CassandraClientProperties.getInstance() returned null");
        } else {
            sslPropertyEnabled = ccp.isSslEnabled();
        }
        if (sslPropertyEnabled != null && !sslPropertyEnabled.booleanValue()) {
            this.log.info((Object)"createClusterBuilder: ssl_enabled property is false so not using TLS");
        } else {
            SSLContext sslContext;
            CassandraSSLOptions cassSSLOptions = this.cConnInfo.getSslOptions();
            SSLContext sSLContext = sslContext = cassSSLOptions != null ? cassSSLOptions.getSslContext() : null;
            if (sslContext != null) {
                if (isFinest) {
                    this.log.finest((Object)("createClusterBuilder: cassandra SSLOptions=" + cassSSLOptions));
                }
                RemoteEndpointAwareJdkSSLOptions.Builder optionsBuilder = RemoteEndpointAwareJdkSSLOptions.builder();
                optionsBuilder.withSSLContext(sslContext);
                optionsBuilder.withCipherSuites(cassSSLOptions.getCipherSuites());
                this.log.info((Object)("createClusterBuilder: using ssl protocol=" + sslContext.getProtocol() + ", ciphers=" + Arrays.toString(cassSSLOptions.getCipherSuites())));
                RemoteEndpointAwareJdkSSLOptions sslOptions = optionsBuilder.build();
                builder.withSSL((SSLOptions)sslOptions);
            } else {
                this.log.info((Object)("createClusterBuilder: SSLContext is null so no TLS, cassandra SSLOptions=" + cassSSLOptions));
            }
        }
        builder.addContactPoint(this.cConnInfo.getHost());
        builder.withPort(this.cConnInfo.getPort());
        return builder;
    }

    private void clusterInit() throws DMException {
        String fcn_name = "clusterInit";
        boolean isInfo = this.log.isInfoEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"clusterInit: enter");
        }
        try {
            this.cluster.init();
            this.log.info((Object)("clusterInit: inited cluster " + this.cluster));
        }
        catch (Exception exc) {
            String msg = "clusterInit: Cassandra cluster.init() failed, numConsecutiveFailures=" + this.numConsecutiveFailures + ", exc=" + exc;
            if (isInfo) {
                this.log.info((Object)msg);
            }
            this.createCluster();
            if (isFiner) {
                this.log.finer((Object)"clusterInit: throwing a DMException", (Throwable)exc);
            }
            throw new DMException(msg, exc);
        }
        if (isFiner) {
            this.log.finer((Object)"clusterInit: leave");
        }
    }

    public Session createSession(String keyspace) throws DMException {
        String fcn_name = "createSession";
        boolean isInfo = this.log.isInfoEnabled();
        boolean isFiner = this.log.isFinerEnabled();
        String keyspaceInfo = "";
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter: with keyspace = " + keyspace));
        }
        this.acquireQueryLock();
        Session session = null;
        try {
            session = keyspace == null ? this.cluster.connect() : this.cluster.connect(keyspace);
        }
        catch (InvalidQueryException iqe) {
            if (keyspace != null) {
                keyspaceInfo = " to keyspace: " + keyspace;
                String msg = fcn_name + ": Cassandra cluster.connect() failed" + keyspaceInfo + " because the keyspace didn't exist, exc=" + (Object)((Object)iqe);
                if (isInfo) {
                    this.log.info((Object)msg);
                }
            }
            throw iqe;
        }
        catch (Exception e) {
            if (keyspace != null) {
                keyspaceInfo = " to keyspace: " + keyspace;
            }
            String msg = fcn_name + ": Cassandra cluster.connect() failed" + keyspaceInfo + ", exc=" + e;
            if (isInfo) {
                this.log.info((Object)msg);
            }
            throw new DMException(msg, e);
        }
        finally {
            this.releaseQueryLock();
        }
        return session;
    }

    private void testQuery(Cluster testCluster) throws DMException {
        String fcn_name = "testQuery";
        boolean isInfo = this.log.isInfoEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        Session session = testCluster.connect();
        try {
            session.execute("TEST;");
        }
        catch (SyntaxError e) {
            if (isFinest) {
                this.log.finest((Object)"testQuery: expected SyntaxError exception occurred, connection is good");
            }
        }
        catch (Exception exc) {
            String msg = "testQuery: Cassandra TEST query failed, exc=" + exc;
            if (isInfo) {
                this.log.info((Object)msg);
            }
            throw new DMException(msg, exc);
        }
        finally {
            session.close();
            session = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQueryWithTempCluster() throws DMException {
        String fcn_name = "testQueryWithTempCluster";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"testQueryWithTempCluster: enter");
        }
        try (Cluster tmpCluster = this.builder.build();){
            this.testQuery(tmpCluster);
        }
        if (isFiner) {
            this.log.finer((Object)"testQueryWithTempCluster: leave");
        }
    }

    private void testQueryWithMyCluster() throws DMException {
        String fcn_name = "testQueryWithMyCluster";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"testQueryWithMyCluster: enter");
        }
        this.testQuery(this.cluster);
        if (isFiner) {
            this.log.finer((Object)"testQueryWithMyCluster: leave");
        }
    }

    public int getClusterInstance() {
        return this.clusterInstance;
    }

    public boolean registerClusterChangeNotifier(ClusterChangeNotifier notifier) {
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "registerClusterChangeNotifier";
        if (isFiner) {
            this.log.finer((Object)("registerClusterChangeNotifier: enter, notifier=" + notifier));
        }
        boolean rc = this.hostStateListener.registerNotifier(notifier);
        if (isFiner) {
            this.log.finer((Object)("registerClusterChangeNotifier: leave, rc=" + rc));
        }
        return rc;
    }

    public boolean unregisterClusterChangeNotifier(ClusterChangeNotifier notifier) {
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "unregisterClusterChangeNotifier";
        if (isFiner) {
            this.log.finer((Object)("unregisterClusterChangeNotifier: enter, notifier=" + notifier));
        }
        boolean rc = this.hostStateListener.unregisterNotifier(notifier);
        if (isFiner) {
            this.log.finer((Object)("unregisterClusterChangeNotifier: leave, rc=" + rc));
        }
        return rc;
    }

    public boolean registerSchemaChangeNotifier(SchemaChangeNotifier notifier) {
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "registerClusterChangeNotifier";
        if (isFiner) {
            this.log.finer((Object)("registerClusterChangeNotifier: enter, notifier=" + notifier));
        }
        boolean rc = this.schemaUpdateListener.registerNotifier(notifier);
        if (isFiner) {
            this.log.finer((Object)("registerClusterChangeNotifier: leave, rc=" + rc));
        }
        return rc;
    }

    public boolean unregisterSchemaChangeNotifier(SchemaChangeNotifier notifier) {
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "unregisterClusterChangeNotifier";
        if (isFiner) {
            this.log.finer((Object)("unregisterClusterChangeNotifier: enter, notifier=" + notifier));
        }
        boolean rc = this.schemaUpdateListener.unregisterNotifier(notifier);
        if (isFiner) {
            this.log.finer((Object)("unregisterClusterChangeNotifier: leave, rc=" + rc));
        }
        return rc;
    }

    public void closeCluster() {
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    @Override
    public void init() throws ConnectionPoolInitializerException {
        try {
            this.initConnectionPool();
        }
        catch (DMException e) {
            throw new ConnectionPoolInitializerException(e);
        }
        catch (UnknownHostException e) {
            throw new ConnectionPoolInitializerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesTableExist(String keyspace, String table) {
        String fcn_name = "doesTableExist";
        this.acquireQueryLock();
        try {
            if (!this.isValidCluster("doesTableExist")) {
                boolean bl = false;
                return bl;
            }
            Metadata metadata = this.cluster.getMetadata();
            if (metadata == null) {
                this.log.info((Object)"doesTableExist: metadata is null, returning false");
                boolean bl = false;
                return bl;
            }
            KeyspaceMetadata kmd = metadata.getKeyspace(keyspace);
            if (kmd == null) {
                boolean bl = false;
                return bl;
            }
            TableMetadata tmd = kmd.getTable(table);
            boolean bl = tmd != null;
            return bl;
        }
        finally {
            this.releaseQueryLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSchemaAgreement() {
        String fcn_name = "checkSchemaAgreement";
        this.acquireQueryLock();
        try {
            if (!this.isValidCluster("checkSchemaAgreement")) {
                boolean bl = false;
                return bl;
            }
            Metadata metadata = this.cluster.getMetadata();
            if (metadata == null) {
                this.log.info((Object)"checkSchemaAgreement: metadata is null, returning false");
                boolean bl = false;
                return bl;
            }
            boolean bl = metadata.checkSchemaAgreement();
            return bl;
        }
        catch (Exception e) {
            this.log.error((Object)"checkSchemaAgreement: caught exception: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseQueryLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Host> getAllHosts() {
        String fcn_name = "getAllHosts";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getAllHosts: enter");
        }
        this.acquireQueryLock();
        try {
            if (!this.isValidCluster("getAllHosts")) {
                Set<Host> set = null;
                return set;
            }
            Metadata metadata = this.cluster.getMetadata();
            if (metadata == null) {
                this.log.info((Object)"getAllHosts: metadata is null, returning false");
                Set<Host> set = null;
                return set;
            }
            Set hosts = metadata.getAllHosts();
            if (isFiner) {
                this.log.finer((Object)("getAllHosts: leave, numHosts=" + hosts.size()));
            }
            Set set = hosts;
            return set;
        }
        finally {
            this.releaseQueryLock();
        }
    }

    public void acquireQueryLock() {
        String fcn_name = "acquireQueryLock";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"acquireQueryLock: enter");
        }
        this.clusterLock.acquireReadLock();
        this.readLockCounter.set(this.readLockCounter.get() + 1);
        if (isFiner) {
            this.log.finer((Object)"acquireQueryLock: leave");
        }
    }

    public void releaseQueryLock() {
        String fcn_name = "releaseQueryLock";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)"releaseQueryLock: enter");
        }
        Integer numReadLocks = this.readLockCounter.get();
        if (isFinest) {
            this.log.finest((Object)("releaseQueryLock: numReadLocks=" + numReadLocks));
        }
        if (numReadLocks != null && numReadLocks != 0) {
            this.readLockCounter.set(numReadLocks - 1);
        }
        this.clusterLock.releaseReadLock();
        if (isFiner) {
            this.log.finer((Object)("releaseQueryLock: leave, numReadLocks=" + numReadLocks));
        }
    }

    public Integer acquireClusterLock() {
        String fcn_name = "acquireClusterLock";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)"acquireClusterLock: enter");
        }
        Integer numReadLocks = this.readLockCounter.get();
        if (isFinest) {
            this.log.finest((Object)("acquireClusterLock: numReadLocks=" + numReadLocks));
        }
        if (numReadLocks != null && numReadLocks > 0) {
            for (int i = 0; i < numReadLocks; ++i) {
                this.releaseQueryLock();
            }
        }
        this.clusterLock.acquireWriteLock();
        if (isFiner) {
            this.log.finer((Object)("acquireClusterLock: leave, numReadLocks=" + numReadLocks));
        }
        return numReadLocks;
    }

    public void releaseClusterLock(Integer numReadLocks) {
        String fcn_name = "releaseClusterLock";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("releaseClusterLock: enter, numReadLocks=" + numReadLocks));
        }
        this.clusterLock.releaseWriteLock();
        if (numReadLocks != null && numReadLocks > 0) {
            for (int i = 0; i < numReadLocks; ++i) {
                this.acquireQueryLock();
            }
        }
        if (isFiner) {
            this.log.finer((Object)"releaseClusterLock: leave");
        }
    }

    private boolean isValidCluster(String fcn_name) {
        if (this.cluster == null) {
            this.log.info((Object)(fcn_name + ": cluster is null, returning false"));
            return false;
        }
        if (this.cluster.isClosed()) {
            this.log.info((Object)(fcn_name + ": cluster is closed, returning false"));
            return false;
        }
        return true;
    }

    public String getHost() {
        return this.cConnInfo.getHost();
    }

    public int getPort() {
        return this.cConnInfo.getPort();
    }

    public int getMaxRequests() {
        return this.cConnInfo.getRateLimitingParms().getMaxRequests();
    }

    public int getMaxQueryWaitTimeoutMs() {
        return this.cConnInfo.getRateLimitingParms().getMaxQueryWaitTimeoutMs();
    }

    static {
        System.setProperty("io.netty.selectorAutoRebuildThreshold", "1024");
    }

    private class CBDReconnectionPolicy
    implements ReconnectionPolicy {
        private CBDReconnectionPolicy() {
        }

        public ReconnectionPolicy.ReconnectionSchedule newSchedule() {
            if (CassandraBasedDAO.this.log.isFinestEnabled()) {
                CassandraBasedDAO.this.log.finer((Object)"newSchedule: returning a new ReconnectionSchedule");
            }
            return new CBDReconnectionSchedule();
        }

        public void close() {
        }

        public void init(Cluster arg0) {
        }

        private class CBDReconnectionSchedule
        implements ReconnectionPolicy.ReconnectionSchedule {
            private long totalDelay = 0L;

            private CBDReconnectionSchedule() {
            }

            public long nextDelayMs() {
                long rc = 1000L;
                if (this.totalDelay >= 50000L) {
                    rc = 50000L;
                }
                this.totalDelay += rc;
                if (CassandraBasedDAO.this.log.isFinestEnabled()) {
                    CassandraBasedDAO.this.log.finer((Object)("nextDelayMs: totalDelay=" + this.totalDelay + ", returning " + rc));
                }
                return rc;
            }
        }
    }
}

