/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.ContactPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.datastax.driver.core.PreparedStatement;

public class ContactPreparedStatements
extends PreparedStatements<ContactPreparedStatementType> {
    private static final String COMMA = ", ";
    private static final String FROM = " FROM ";
    private static final String IF = " IF ";
    private static final String IF_NOT_EXISTS = " IF NOT EXISTS ";
    private static final String SET = " SET ";
    private static final String COUNT = " count(*) ";
    private static final String CONTACT_CF = "__KEYSPACE__.contact";
    private static final String COMMON_ADD_AND_UPDATE_CONTACT_FIELDS = "displaynamelocal, firstnamelocal, lastnamelocal, displaynameascii, firstnameascii, lastnameascii, preferredlanguage, alias, notes, isbuddy, videocapable, primarynumber, csuserid, cscontactid, endpointdata, ppmaddress, cscontactlistmemberid, csprivatecontactinfoid, manager, pictureurl, favourite, instantconnection, servicedata, handles, addresses";
    private static final String ALL_ADD_CONTACT_FIELDS = "ownercsuserid, id, type, createddatetime, updatedatetime, displaynamelocal, firstnamelocal, lastnamelocal, displaynameascii, firstnameascii, lastnameascii, preferredlanguage, alias, notes, isbuddy, videocapable, primarynumber, csuserid, cscontactid, endpointdata, ppmaddress, cscontactlistmemberid, csprivatecontactinfoid, manager, pictureurl, favourite, instantconnection, servicedata, handles, addresses";
    private static final String ALL_UPDATE_CONTACT_FIELDS = "ownercsuserid, id, type, updatedatetime, displaynamelocal, firstnamelocal, lastnamelocal, displaynameascii, firstnameascii, lastnameascii, preferredlanguage, alias, notes, isbuddy, videocapable, primarynumber, csuserid, cscontactid, endpointdata, ppmaddress, cscontactlistmemberid, csprivatecontactinfoid, manager, pictureurl, favourite, instantconnection, servicedata, handles, addresses";
    private static final String ADD_CONTACT_QRY = "INSERT INTO __KEYSPACE__.contact";
    private static final String DELETE_CONTACT_QRY = "DELETE FROM __KEYSPACE__.contact";
    public static final String GET_CONTACT_QRY = "SELECT ownercsuserid, id, type, createddatetime, updatedatetime, displaynamelocal, firstnamelocal, lastnamelocal, displaynameascii, firstnameascii, lastnameascii, preferredlanguage, alias, notes, isbuddy, videocapable, primarynumber, csuserid, cscontactid, endpointdata, ppmaddress, cscontactlistmemberid, csprivatecontactinfoid, manager, pictureurl, favourite, instantconnection, servicedata, handles, addresses FROM __KEYSPACE__.contact";
    public static final String GET_CONTACT_COUNT_QRY = "SELECT  count(*)  FROM __KEYSPACE__.contact";
    private static final String GET_OWNERCSUSERIDS = "SELECT DISTINCT ownercsuserid FROM __KEYSPACE__.contact";
    private static final String SMGR_CONTACT_REF_CF = "__KEYSPACE__.smgr_contact_ref";
    private static final String ADD_SMGR_CONTACT_REF_FIELDS = "ownercsuserid, rectype, recid, updatedatetime, clmid, contactid";
    private static final String ADD_SMGR_CONTACT_REF_QRY = "INSERT INTO __KEYSPACE__.smgr_contact_ref";
    private static final String DELETE_SMGR_CONTACT_REF_QRY = "DELETE FROM __KEYSPACE__.smgr_contact_ref";
    private static final String GET_SMGR_CONTACT_REF_QRY = "SELECT ownercsuserid, rectype, recid, updatedatetime, clmid, contactid FROM __KEYSPACE__.smgr_contact_ref";
    private static final String UPDATE_SMGR_CONTACT_REF_QRY = "UPDATE __KEYSPACE__.smgr_contact_ref";

    public ContactPreparedStatements(SessionDAO dao) {
        super(ContactPreparedStatementType.class, dao);
    }

    @Override
    public PreparedStatement prepareStatement(ContactPreparedStatementType queryType, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        StringBuilder query = new StringBuilder();
        switch (queryType) {
            case ADD_CONTACT: {
                query.append(ADD_CONTACT_QRY);
                query.append(" (ownercsuserid, id, type, createddatetime, updatedatetime, displaynamelocal, firstnamelocal, lastnamelocal, displaynameascii, firstnameascii, lastnameascii, preferredlanguage, alias, notes, isbuddy, videocapable, primarynumber, csuserid, cscontactid, endpointdata, ppmaddress, cscontactlistmemberid, csprivatecontactinfoid, manager, pictureurl, favourite, instantconnection, servicedata, handles, addresses)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                break;
            }
            case ADD_SMGR_CONTACT_REF: {
                query.append((CharSequence)this.buildSmgrContactRefAddQuery());
                break;
            }
            case ADD_SMGR_CONTACT_REF_IF_NOT_EXISTS: {
                query.append((CharSequence)this.buildSmgrContactRefAddQuery());
                query.append(IF_NOT_EXISTS);
                break;
            }
            case DELETE_CONTACT: {
                query.append(DELETE_CONTACT_QRY);
                query.append(" WHERE ownercsuserid=? AND id=?");
                break;
            }
            case DELETE_ALL_CONTACTS: {
                query.append(DELETE_CONTACT_QRY);
                query.append(" WHERE ownercsuserid=?");
                break;
            }
            case DELETE_SMGR_CONTACT_REF: {
                query.append(DELETE_SMGR_CONTACT_REF_QRY);
                query.append(" WHERE ownercsuserid=? AND rectype=? AND recid=?");
                break;
            }
            case DELETE_ALL_SMGR_CONTACT_REFS: {
                query.append(DELETE_SMGR_CONTACT_REF_QRY);
                query.append(" WHERE ownercsuserid=?");
                break;
            }
            case GET_CONTACT: {
                query.append(GET_CONTACT_QRY);
                query.append(" WHERE ownercsuserid=? AND id=?");
                break;
            }
            case GET_ALL_CONTACTS: {
                query.append(GET_CONTACT_QRY);
                query.append(" WHERE ownercsuserid=?");
                break;
            }
            case GET_CONTACTS_COUNT: {
                query.append(GET_CONTACT_COUNT_QRY);
                query.append(" WHERE csuserId=? ALLOW FILTERING");
                break;
            }
            case GET_SMGR_CONTACT_REFS: {
                query.append(GET_SMGR_CONTACT_REF_QRY);
                query.append(" WHERE ownercsuserid=? AND rectype=? AND recid =?");
                break;
            }
            case GET_SMGR_CONTACT_REFS_BY_RECTYPE: {
                query.append(GET_SMGR_CONTACT_REF_QRY);
                query.append(" WHERE ownercsuserid=? AND rectype=?");
                break;
            }
            case GET_SMGR_CONTACT_REFS_BY_CONTACT_ID: {
                query.append(GET_SMGR_CONTACT_REF_QRY);
                query.append(" WHERE ownercsuserid=? AND contactid=?");
                break;
            }
            case GET_SMGR_CONTACT_REFS_BY_OWNER_ID: {
                query.append(GET_SMGR_CONTACT_REF_QRY);
                query.append(" WHERE ownercsuserid=?");
                break;
            }
            case UPDATE_CONTACT: {
                query.append(ADD_CONTACT_QRY);
                query.append(" (ownercsuserid, id, type, updatedatetime, displaynamelocal, firstnamelocal, lastnamelocal, displaynameascii, firstnameascii, lastnameascii, preferredlanguage, alias, notes, isbuddy, videocapable, primarynumber, csuserid, cscontactid, endpointdata, ppmaddress, cscontactlistmemberid, csprivatecontactinfoid, manager, pictureurl, favourite, instantconnection, servicedata, handles, addresses)");
                query.append(" VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                break;
            }
            case UPDATE_SMGR_CONTACT_REF: {
                query.append((CharSequence)this.buildSmgrContactRefUpdateQuery());
                break;
            }
            case UPDATE_SMGR_CONTACT_REF_IF_NOT_EQUAL: {
                query.append((CharSequence)this.buildSmgrContactRefUpdateQuery());
                query.append(" IF updatedatetime!=?");
                break;
            }
            case GET_OWNERCSUSERIDS: {
                query.append(GET_OWNERCSUSERIDS);
            }
        }
        return this.prepareQuery(query.toString(), keyspaceBuilder);
    }

    public StringBuilder buildSmgrContactRefAddQuery() {
        StringBuilder query = new StringBuilder();
        query.append(ADD_SMGR_CONTACT_REF_QRY);
        query.append(" (ownercsuserid, rectype, recid, updatedatetime, clmid, contactid)");
        query.append(" VALUES(?, ?, ?, ?, ?, ?)");
        return query;
    }

    public StringBuilder buildSmgrContactRefUpdateQuery() {
        StringBuilder query = new StringBuilder();
        query.append(UPDATE_SMGR_CONTACT_REF_QRY);
        query.append(" SET clmid=?, contactid=?, updatedatetime=?");
        query.append(" WHERE ownercsuserid=? AND rectype=? AND recid =?");
        return query;
    }
}

