/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.ConnectionPoolInitializerException;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CassandraBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.ColumnFamilyMetaData;
import com.avaya.asm.datamgr.dao.cassandra.KeyspaceMetaData;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreStatementBuilder;
import com.avaya.asm.datamgr.dao.ustore.factory.UstoreDAOFactory;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.TransportException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SessionDAO {
    private final Logger log = AsmLogger.getLogger(SessionDAO.class);
    Session session = null;
    String keyspace = null;
    CassandraBasedDAO cbDAO = null;
    int cbdInstance = 0;
    private int port = 0;
    private String host = "";
    private UstoreDAOFactory.HostPortKey hpKey = null;
    private static Map<UstoreDAOFactory.HostPortKey, Semaphore> hpSemaphoreMap = new HashMap<UstoreDAOFactory.HostPortKey, Semaphore>();
    private static ThreadLocal<Integer> permitCounter = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final int MAX_SEMAPHORE_PERMITS = 45;
    private static final int SEMAPHORE_ACQUIRE_TIMEOUT_MS = 30000;
    private static final String maxSemaphorePermitsProperty = "asm.common.cassandra.max.queries.value";
    private static final String maxSemaphorePermitsEnv = "CASSANDRA_MAX_QUERIES_VALUE";
    private static int maxSemaphorePermits = 45;
    private static int semaphoreAcquireTimeoutMs = 30000;
    private static final String semaphoreAcquireTimeoutMsProperty = "asm.common.cassandra.max.queries.timeoutms";
    private static final String semaphoreAcquireTimeoutMsEnv = "CASSANDRA_MAX_QUERIES_TIMEOUT";
    static final Pattern keyspacePattern = Pattern.compile("Keyspace '?\\w+'? does not exist");
    static final Pattern tablePattern = Pattern.compile("unconfigured (columnfamily|table)");
    protected static CleanseQuery cleanQuery = new CleanseQuery();

    public SessionDAO() {
    }

    public SessionDAO(CassandraBasedDAO cbDAO, String keyspace) throws DMException {
        this.cbDAO = cbDAO;
        this.cbdInstance = cbDAO.getClusterInstance();
        this.keyspace = keyspace;
        this.createSemaphore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSemaphore() {
        UstoreDAOFactory.HostPortKey hpk;
        String fcn_name = "createSemaphore";
        this.host = this.cbDAO.getHost();
        this.port = this.cbDAO.getPort();
        Integer maxPermits = this.cbDAO.getMaxRequests();
        maxSemaphorePermits = maxPermits != 0 ? maxPermits.intValue() : this.getIntParameterValue(45, maxSemaphorePermitsProperty, maxSemaphorePermitsEnv).intValue();
        Integer timeout = this.cbDAO.getMaxQueryWaitTimeoutMs();
        semaphoreAcquireTimeoutMs = timeout != 0 ? timeout.intValue() : this.getIntParameterValue(30000, semaphoreAcquireTimeoutMsProperty, semaphoreAcquireTimeoutMsEnv).intValue();
        this.log.info((Object)("createSemaphore: host = " + this.host + ", port = " + this.port + ", maxSemaphorePermits = " + maxSemaphorePermits + ", semaphoreAcquireTimeoutMs = " + semaphoreAcquireTimeoutMs));
        this.hpKey = hpk = new UstoreDAOFactory.HostPortKey(this.host, this.port);
        Map<UstoreDAOFactory.HostPortKey, Semaphore> map = hpSemaphoreMap;
        synchronized (map) {
            if (!hpSemaphoreMap.containsKey(hpk)) {
                hpSemaphoreMap.put(hpk, new Semaphore(maxSemaphorePermits, true));
                this.log.info((Object)("createSemaphore: Created semaphore with maxSemaphorePermits = " + maxSemaphorePermits + ", semaphoreAcquireTimeoutMs = " + semaphoreAcquireTimeoutMs));
            }
        }
    }

    public Session getSession() {
        return this.session;
    }

    private Object executeSessionMethod(SessionMethod command, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        Object result;
        block9: {
            result = null;
            Boolean acquired = false;
            try {
                try {
                    acquired = this.getPermit();
                }
                catch (InterruptedException ie) {
                    DMException dme = new DMException("InterruptedException caught while waiting for semaphore permits.", ie);
                    throw dme;
                }
                if (acquired.booleanValue()) {
                    result = this.doExecuteSessionMethod(command, keyspaceBuilder);
                    break block9;
                }
                DMException dme = new DMException("Timedout waiting for semaphore permits.", new TimeoutException());
                throw dme;
            }
            catch (DMException dme) {
                throw dme;
            }
            finally {
                if (acquired.booleanValue()) {
                    this.releasePermit();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doExecuteSessionMethod(SessionMethod command, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        String fcn_name = "doExecuteSessionMethod";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("doExecuteSessionMethod: command=" + command + ": this.keyspace=" + this.keyspace));
            if (keyspaceBuilder != null && keyspaceBuilder.getKeyspace() != null) {
                this.log.finer((Object)("doExecuteSessionMethod: keyspaceBuilder.keyspace=" + keyspaceBuilder.getKeyspace().toString()));
            } else {
                this.log.finer((Object)"doExecuteSessionMethod: keyspaceBuilder==null or keyspaceBuilder.keyspace==null");
            }
        }
        if (isFiner) {
            this.log.finer((Object)("doExecuteSessionMethod: session=" + this.getSession()));
        }
        int count = 0;
        ExceptionCounters excCounters = new ExceptionCounters();
        while (true) {
            ++count;
            this.cbDAO.checkCluster();
            if (this.session == null) {
                this.createNewSession(command, keyspaceBuilder, ": session is null for keyspace: ");
            }
            this.cbDAO.acquireQueryLock();
            try {
                if (this.cbdInstance != this.cbDAO.getClusterInstance()) {
                    if (isFinest) {
                        this.log.finest((Object)("doExecuteSessionMethod: cluster instance has changed from " + this.cbdInstance + " to " + this.cbDAO.getClusterInstance()));
                    }
                    this.createNewSession(command, keyspaceBuilder, ": cluster has changed so creating a new Session for keyspace: ");
                }
                Object object = command.execute(this.session);
                this.cbDAO.releaseQueryLock();
                return object;
            }
            catch (Throwable throwable) {
                try {
                    this.cbDAO.releaseQueryLock();
                    throw throwable;
                }
                catch (ConnectionPoolInitializerException exc) {
                    Throwable dme = null;
                    Throwable cause = dme.getCause();
                    dme = cause instanceof DMException ? (DMException)cause : new DMException("doExecuteSessionMethod: cannot talk to Cassandra: command=" + command, exc);
                    throw dme;
                }
                catch (NoHostAvailableException exc) {
                    if (exc.getMessage().contains(DriverException.class.getName())) {
                        this.handleDriverException((DriverException)((Object)exc), command, keyspaceBuilder, excCounters);
                        continue;
                    }
                    Map errors = exc.getErrors();
                    for (Map.Entry entry : errors.entrySet()) {
                        InetSocketAddress address = (InetSocketAddress)entry.getKey();
                        Throwable throwable2 = (Throwable)entry.getValue();
                        if (!isFinest) continue;
                        this.log.finest((Object)("doExecuteSessionMethod: address=" + address + " throwable=" + throwable2));
                    }
                    this.handleCassandraDown(command, keyspaceBuilder, count, excCounters, (Exception)((Object)exc));
                    continue;
                }
                catch (DriverException e) {
                    if (e instanceof TransportException) {
                        this.handleCassandraDown(command, keyspaceBuilder, count, excCounters, (Exception)((Object)e));
                        continue;
                    }
                    this.handleDriverException(e, command, keyspaceBuilder, excCounters);
                    continue;
                }
                catch (Exception exc) {
                    StringBuilder msg = new StringBuilder("doExecuteSessionMethod");
                    msg.append(": Exception encountered, count=");
                    msg.append(count);
                    msg.append(": excCounters=");
                    msg.append(excCounters);
                    msg.append(", cbd.clusterInstance=");
                    msg.append(this.cbDAO.getClusterInstance());
                    msg.append(", exception=");
                    msg.append(exc);
                    this.log.warn((Object)msg.toString(), (Throwable)exc);
                    throw new DMException("doExecuteSessionMethod: cannot talk to Cassandra: command=" + command, exc);
                }
            }
            break;
        }
    }

    private void handleCassandraDown(SessionMethod command, UserStoreKeyspaceBuilder keyspaceBuilder, int count, ExceptionCounters excCounters, Exception exc) throws DMException {
        String fcn_name = "handleCassandraDown";
        boolean isFinest = this.log.isFinestEnabled();
        if (isFinest) {
            StringBuilder msg = new StringBuilder("handleCassandraDown");
            msg.append(": count=");
            msg.append(count);
            msg.append(": excCounters=");
            msg.append(excCounters);
            msg.append(", cbdInstance=");
            msg.append(this.cbdInstance);
            msg.append(", getGetClusterInstance=");
            msg.append(this.cbDAO.getClusterInstance());
            msg.append(", exception=");
            msg.append(exc);
            this.log.finest((Object)msg.toString());
        }
        if (this.cbdInstance != this.cbDAO.getClusterInstance()) {
            if (isFinest) {
                this.log.finest((Object)("handleCassandraDown: cluster instance has changed from " + this.cbdInstance + " to " + this.cbDAO.getClusterInstance()));
            }
            this.createNewSession(command, keyspaceBuilder, ": cluster has changed so creating a new Session for keyspace: ");
        } else {
            this.cbDAO.noHostAvailable();
            if (count == 1) {
                if (isFinest) {
                    this.log.finest((Object)"handleCassandraDown: count is 1 so retrying query");
                }
            } else if (count == 2) {
                this.createNewSession(command, keyspaceBuilder, ": Session appears bad so creating a new Session for keyspace: ");
            } else {
                DMException dme = null;
                dme = exc instanceof DMException ? (DMException)exc : new DMException("handleCassandraDown: cannot talk to Cassandra", exc);
                throw dme;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDriverException(DriverException e, SessionMethod command, UserStoreKeyspaceBuilder keyspaceBuilder, ExceptionCounters excCounters) throws DMException {
        String fcn_name = "handleDriverException";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("handleDriverException: enter, excCounters=" + excCounters + ", e.message=" + e.getMessage()));
        }
        excCounters.incrDriverExceptionCount();
        if (isFinest) {
            StringBuilder msg = new StringBuilder("handleDriverException");
            msg.append(": excCounters=");
            msg.append(excCounters);
            msg.append(", exception=");
            msg.append((Object)e);
            this.log.finest((Object)msg.toString());
        }
        if (e.getMessage().contains("execute unknown prepared query")) {
            excCounters.incrStalePreparedStatement();
            if (excCounters.getStalePreparedStatementCount() != 1) throw new DMException("handleDriverException: since stalePreparedStatementCount > 1 (" + excCounters.getStalePreparedStatementCount() + "), there's nothing we can do but throw an exception: exception=" + (Object)((Object)e));
            if (isFinest) {
                this.log.finest((Object)"handleDriverException: count is 1 so recreating the session.");
            }
            this.createNewSession(command, keyspaceBuilder, ": Session appears bad so creating a new Session for keyspace: ");
        } else {
            this.handleKeyspaceException((Exception)((Object)e), command, keyspaceBuilder, excCounters.getDriverExceptionCount());
        }
        if (!isFiner) return;
        this.log.finer((Object)"handleDriverException: leave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createNewSession(SessionMethod command, UserStoreKeyspaceBuilder keyspaceBuilder, String logMessage) throws DMException {
        String fcn_name = "createNewSession";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter"));
        }
        if (this.session != null && !this.session.isClosed()) {
            this.session.close();
        }
        this.log.info((Object)(fcn_name + logMessage + this.keyspace));
        int invalidQueryExceptionCount = 0;
        boolean wasCreated = false;
        while (!wasCreated) {
            try {
                this.session = this.cbDAO.createSession(this.keyspace);
                wasCreated = true;
            }
            catch (InvalidQueryException iqe) {
                String message = iqe.getMessage();
                if (this.log.isFinestEnabled()) {
                    StringBuilder msg = new StringBuilder(fcn_name);
                    msg.append(", cbdInstance=");
                    msg.append(this.cbdInstance);
                    msg.append(", getGetClusterInstance=");
                    msg.append(this.cbDAO.getClusterInstance());
                    msg.append(", message=\"");
                    msg.append(message);
                    msg.append("\"");
                    this.log.finest((Object)msg.toString());
                }
                if (keyspaceBuilder == null) {
                    throw new DMException(fcn_name + ": since keyspaceBuilder == null, there's nothing we can do but throw an exception: throwable=" + (Object)((Object)iqe));
                }
                if (invalidQueryExceptionCount > 1) {
                    throw new DMException(fcn_name + ": since invalidQueryExceptionCount exceeds 1 (" + invalidQueryExceptionCount + "), there's nothing we can do but throw an exception: throwable=" + (Object)((Object)iqe));
                }
                Matcher keyspaceMatcher = keyspacePattern.matcher(message);
                if (keyspaceMatcher.find() && keyspaceBuilder.getKeyspace() != null) {
                    this.session = this.cbDAO.createSession(null);
                    try {
                        keyspaceBuilder.createKeyspace(this);
                    }
                    finally {
                        Session tmpSession = this.session;
                        this.session = null;
                        tmpSession.close();
                    }
                    this.session = this.cbDAO.createSession(this.keyspace);
                    continue;
                }
                throw new DMException(fcn_name + ": not sure what happened here, so throw an exception: throwable=" + (Object)((Object)iqe));
            }
        }
        command.newSession(this.session);
        this.cbdInstance = this.cbDAO.getClusterInstance();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": leave"));
        }
    }

    private void handleKeyspaceException(Exception exception, SessionMethod command, UserStoreKeyspaceBuilder keyspaceBuilder, int driverExceptionCount) throws DMException {
        String fcn_name = "handleKeyspaceException";
        String message = exception.getMessage();
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)(fcn_name + ": message=\"" + message + "\""));
        }
        if (keyspaceBuilder == null) {
            throw new DMException(fcn_name + ": since keyspaceBuilder == null, there's nothing we can do but throw an exception: exception=" + exception, exception);
        }
        if (driverExceptionCount > 1) {
            throw new DMException(fcn_name + ": since keyspaceBuilder > 1 (" + driverExceptionCount + "), there's nothing we can do but throw an exception: exception=" + exception, exception);
        }
        Matcher keyspaceMatcher = keyspacePattern.matcher(message);
        if (keyspaceMatcher.find()) {
            keyspaceBuilder.createKeyspace(this);
            keyspaceBuilder.createColumnFamilies(this);
            return;
        }
        Matcher tableMatcher = tablePattern.matcher(message);
        if (tableMatcher.find()) {
            keyspaceBuilder.createColumnFamilies(this);
            return;
        }
        throw new DMException(fcn_name + ": unable to handle exception for command=" + command + " exception=" + exception, exception);
    }

    public PreparedStatement prepareQuery(String query) throws DMException {
        String fcn_name = "prepareQuery";
        try {
            PreparedStatement ps = this.prepareQuery(query, null);
            return ps;
        }
        catch (DMException dme) {
            throw new DMException(fcn_name + ": cannot talk to Cassandra", dme);
        }
    }

    public PreparedStatement prepareQuery(String query, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        return (PreparedStatement)this.executeSessionMethod(new PrepareMethod(query), keyspaceBuilder);
    }

    public ResultSet executeStatement(UserStoreStatementBuilder statement) throws DMException {
        String fcn_name = "executeStatement";
        try {
            ResultSet rs = this.executeStatement(statement, null);
            return rs;
        }
        catch (DMException dme) {
            this.log.error((Object)(fcn_name + ": failure to execute statement with no keyspace builder"));
            throw dme;
        }
    }

    public ResultSet executeStatement(UserStoreStatementBuilder statement, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        return (ResultSet)this.executeSessionMethod(new ExecuteStatementMethod(statement), keyspaceBuilder);
    }

    public ResultSet executeQuery(String query) throws DMException {
        return this.executeQuery(query, null);
    }

    public ResultSet executeQuery(String query, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        return (ResultSet)this.executeSessionMethod(new ExecuteQueryMethod(query), keyspaceBuilder);
    }

    public boolean getKeyspaces(Collection<KeyspaceMetaData> keyspaces) {
        boolean rc;
        String fcn_name = "getKeyspaces";
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)(fcn_name + ": enter, keyspaces.size=" + keyspaces.size()));
        }
        GetAllKeyspacesMethod gAKSMethod = new GetAllKeyspacesMethod(keyspaces);
        try {
            rc = (Boolean)this.executeSessionMethod(gAKSMethod, null);
        }
        catch (DMException e) {
            this.log.error((Object)(fcn_name + ": executeSessionMethod() threw DMException"), (Throwable)e);
            return false;
        }
        if (!rc) {
            this.log.warn((Object)(fcn_name + ": cbDAO.getAllKeyspaces returned false"));
            return false;
        }
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)(fcn_name + ": leave with keyspaces: " + Arrays.toString(keyspaces.toArray())));
        }
        return true;
    }

    public KeyspaceMetaData getKeyspace(String ksName) {
        String fcn_name = "getKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter, ksName=" + ksName));
        }
        GetKeyspaceMethod gKsMethod = new GetKeyspaceMethod(ksName);
        KeyspaceMetaData ksMD = null;
        try {
            ksMD = (KeyspaceMetaData)this.executeSessionMethod(gKsMethod, null);
        }
        catch (DMException e) {
            this.log.error((Object)(fcn_name + ": executeSessionMethod() threw DMException, ksName=" + ksName), (Throwable)e);
            return null;
        }
        if (ksMD == null) {
            this.log.warn((Object)(fcn_name + ": executeSessionMethod() returned null for keyspace " + ksName));
        }
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": leave, ksMD=: " + ksMD));
        }
        return ksMD;
    }

    public boolean getColumnFamilies(String keyspace, Collection<ColumnFamilyMetaData> columnFamilies) {
        String fcn_name = "getColumnFamilies";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter, columnFamilies.size=" + columnFamilies.size()));
        }
        GetColumnFamiliesMethod gCFMethod = new GetColumnFamiliesMethod(keyspace, columnFamilies);
        boolean rc = false;
        try {
            rc = (Boolean)this.executeSessionMethod(gCFMethod, null);
        }
        catch (DMException e) {
            this.log.error((Object)(fcn_name + ": executeSessionMethod() threw DMException, "), (Throwable)e);
            return false;
        }
        if (!rc) {
            this.log.warn((Object)(fcn_name + ": executeSessionMethod() returned false"));
            return false;
        }
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": leave with columnFamilies: " + Arrays.toString(columnFamilies.toArray())));
        }
        return true;
    }

    public boolean getAllColumnFamilies(Collection<ColumnFamilyMetaData> columnFamilies) {
        String fcn_name = "getAllColumnFamilies";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": enter, columnFamilies.size=" + columnFamilies.size()));
        }
        GetAllColumnFamiliesMethod gACFMethod = new GetAllColumnFamiliesMethod(columnFamilies);
        boolean rc = false;
        try {
            rc = (Boolean)this.executeSessionMethod(gACFMethod, null);
        }
        catch (DMException e) {
            this.log.error((Object)(fcn_name + ": executeSessionMethod() threw DMException, "), (Throwable)e);
            return false;
        }
        if (!rc) {
            this.log.warn((Object)(fcn_name + ": executeSessionMethod() returned false"));
            return false;
        }
        if (isFiner) {
            this.log.finer((Object)(fcn_name + ": leave with columnFamilies: " + Arrays.toString(columnFamilies.toArray())));
        }
        return true;
    }

    public boolean doesTableExist(String keyspaceName, String table) throws DMException {
        return this.cbDAO.doesTableExist(keyspaceName, table);
    }

    public static String cqlEscape(String argument) {
        if (argument == null) {
            return null;
        }
        return argument.replace("'", "''");
    }

    public PreparedStatement prepareQuery(RegularStatement rs) throws DMException {
        return (PreparedStatement)this.executeSessionMethod(new PrepareMethod(rs.getQueryString()), null);
    }

    public PreparedStatement prepareQuery(RegularStatement rs, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        return (PreparedStatement)this.executeSessionMethod(new PrepareMethod(rs.getQueryString()), keyspaceBuilder);
    }

    public int getClusterNodeCount() throws DMException {
        return 1;
    }

    public void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
    }

    public void setSession(Session session) {
        this.session = session;
    }

    /*
     * Unable to fully structure code
     */
    private boolean getPermit() throws InterruptedException {
        acquired = false;
        sdSemaphore = SessionDAO.hpSemaphoreMap.get(this.hpKey);
        fcn_name = "getPermit";
        isFinest = this.log.isFinestEnabled();
        if (SessionDAO.permitCounter != null) {
            currentPC = SessionDAO.permitCounter.get();
            if (isFinest) {
                this.log.finest((Object)("getPermit: permitCounter.get() = " + currentPC + " for this = " + this));
            }
            if (currentPC == 0) {
                try {
                    acquired = sdSemaphore.tryAcquire(SessionDAO.semaphoreAcquireTimeoutMs, TimeUnit.MILLISECONDS);
                    if (acquired.booleanValue()) {
                        SessionDAO.permitCounter.set(currentPC + 1);
                    } else {
                        this.log.info((Object)("getPermit: Timedout waiting for semaphore for this = " + this));
                    }
                    if (!isFinest) ** GOTO lbl24
                    this.log.finest((Object)("getPermit: acquired = " + acquired + " with permitCounter = " + currentPC + " for this = " + this));
                }
                catch (InterruptedException ie) {
                    this.log.info((Object)("getPermit: Caught InterruptedException -  for this = " + this), (Throwable)ie);
                    throw ie;
                }
            } else {
                SessionDAO.permitCounter.set(currentPC + 1);
                acquired = true;
            }
        }
lbl24:
        // 5 sources

        if (isFinest) {
            this.log.finest((Object)("getPermit: acquired = " + acquired + ", permitCounter (per thread) = " + SessionDAO.permitCounter.get() + ", sdSemaphore.availablePermits()  = " + sdSemaphore.availablePermits() + " for host = " + this.hpKey.getHost() + " and port = " + this.hpKey.getPort() + " for this = " + this));
        }
        return acquired;
    }

    private void releasePermit() {
        String fcn_name = "releasePermit";
        boolean isFinest = this.log.isFinestEnabled();
        Semaphore sdSemaphore = null;
        if (permitCounter != null) {
            Integer currentPC = permitCounter.get();
            if (isFinest) {
                this.log.finest((Object)("releasePermit: will release " + currentPC + " for this = " + this));
            }
            if (currentPC > 0) {
                Integer n = currentPC;
                Integer n2 = currentPC = Integer.valueOf(currentPC - 1);
                permitCounter.set(currentPC);
                if (currentPC == 0) {
                    sdSemaphore = hpSemaphoreMap.get(this.hpKey);
                    sdSemaphore.release();
                    if (isFinest) {
                        this.log.finest((Object)("releasePermit: Released semaphore with permitCounter = " + currentPC + " for this = " + this));
                    }
                }
            } else {
                this.log.warn((Object)("releasePermit: Unexpected releasePermit request with permitCounter = " + currentPC + " for this = " + this));
            }
        }
        if (isFinest) {
            this.log.finest((Object)("releasePermit: permitCounter = " + permitCounter.get() + " , sdSemaphore.availablePermits()  = " + hpSemaphoreMap.get(this.hpKey).availablePermits() + " for host = " + this.hpKey.getHost() + " and port = " + this.hpKey.getPort() + " for this = " + this));
        }
    }

    private Integer getIntParameterValue(Integer defaultValue, String systemProperty, String envVarName) {
        String paramValue = null;
        Integer retValue = defaultValue;
        paramValue = System.getProperty(systemProperty);
        if (paramValue == null) {
            paramValue = System.getenv(envVarName);
        }
        retValue = paramValue == null ? defaultValue : Integer.valueOf(Integer.parseInt(paramValue));
        return retValue;
    }

    public Metadata getClusterMetadata() throws DMException {
        return (Metadata)this.executeSessionMethod(new GetClusterMetadata(), null);
    }

    public class GetClusterMetadata
    implements SessionMethod {
        @Override
        public Object execute(Session session) throws DMException {
            String fcn_name = "execute";
            Cluster cluster = session.getCluster();
            if (cluster == null) {
                SessionDAO.this.log.warn((Object)"execute: cluster is null for session, returning null");
                return null;
            }
            Metadata metadata = cluster.getMetadata();
            if (metadata == null) {
                SessionDAO.this.log.warn((Object)"execute: metadata is null, returning null");
                return null;
            }
            return metadata;
        }

        @Override
        public void newSession(Session session) {
        }
    }

    public class GetAllColumnFamiliesMethod
    implements SessionMethod {
        private final Collection<ColumnFamilyMetaData> columnFamilies;

        public GetAllColumnFamiliesMethod(Collection<ColumnFamilyMetaData> columnFamilies) {
            this.columnFamilies = columnFamilies;
        }

        @Override
        public Object execute(Session session) throws DMException {
            String fcn_name = "execute";
            Cluster cluster = session.getCluster();
            if (cluster == null) {
                SessionDAO.this.log.warn((Object)"execute: cluster is null for session, returning false");
                return false;
            }
            Metadata metadata = cluster.getMetadata();
            if (metadata == null) {
                SessionDAO.this.log.warn((Object)"execute: metadata is null, returning false");
                return false;
            }
            List kmdList = metadata.getKeyspaces();
            for (KeyspaceMetadata kmd : kmdList) {
                for (TableMetadata tmd : kmd.getTables()) {
                    ColumnFamilyMetaData cfmd = new ColumnFamilyMetaData(tmd);
                    this.columnFamilies.add(cfmd);
                }
            }
            return true;
        }

        @Override
        public void newSession(Session session) {
        }
    }

    public class GetColumnFamiliesMethod
    implements SessionMethod {
        private final String ksName;
        private final Collection<ColumnFamilyMetaData> columnFamilies;

        public GetColumnFamiliesMethod(String ksName, Collection<ColumnFamilyMetaData> columnFamilies) {
            this.ksName = ksName;
            this.columnFamilies = columnFamilies;
        }

        @Override
        public Object execute(Session session) throws DMException {
            String fcn_name = "execute";
            Cluster cluster = session.getCluster();
            if (cluster == null) {
                SessionDAO.this.log.warn((Object)("execute: cluster is null for session, ksName=" + this.ksName + ", returning false"));
                return false;
            }
            Metadata metadata = cluster.getMetadata();
            if (metadata == null) {
                SessionDAO.this.log.warn((Object)("execute: metadata is null, ksName=" + this.ksName + ", returning false"));
                return false;
            }
            KeyspaceMetadata ksMd = metadata.getKeyspace(this.ksName);
            if (ksMd == null) {
                SessionDAO.this.log.warn((Object)("execute: metadata.getKeyspace() is null, ksName=" + this.ksName + ", returning false"));
                return false;
            }
            for (TableMetadata tmd : ksMd.getTables()) {
                ColumnFamilyMetaData cfmd = new ColumnFamilyMetaData(tmd);
                this.columnFamilies.add(cfmd);
            }
            return true;
        }

        @Override
        public void newSession(Session session) {
        }
    }

    public class GetAllKeyspacesMethod
    implements SessionMethod {
        private Collection<KeyspaceMetaData> keyspaceColl;

        public GetAllKeyspacesMethod(Collection<KeyspaceMetaData> keyspaceColl) {
            this.keyspaceColl = keyspaceColl;
        }

        @Override
        public Object execute(Session session) throws DMException {
            String fcn_name = "execute";
            Cluster cluster = session.getCluster();
            if (cluster == null) {
                SessionDAO.this.log.warn((Object)"execute: cluster is null for session, returning false");
                return false;
            }
            Metadata metadata = cluster.getMetadata();
            if (metadata == null) {
                SessionDAO.this.log.warn((Object)"execute: metadata is null, returning false");
                return false;
            }
            List kmdList = metadata.getKeyspaces();
            if (kmdList == null) {
                SessionDAO.this.log.warn((Object)"execute: metadata.getKeyspaces() is null, returning null");
                return false;
            }
            for (KeyspaceMetadata kmd : kmdList) {
                KeyspaceMetaData ksmd = new KeyspaceMetaData(kmd);
                this.keyspaceColl.add(ksmd);
            }
            return true;
        }

        @Override
        public void newSession(Session session) {
        }
    }

    public class GetKeyspaceMethod
    implements SessionMethod {
        private final String ksName;

        public GetKeyspaceMethod(String ksName) {
            this.ksName = ksName;
        }

        @Override
        public Object execute(Session session) throws DMException {
            String fcn_name = "execute";
            Cluster cluster = session.getCluster();
            if (cluster == null) {
                SessionDAO.this.log.warn((Object)("execute: cluster is null for session, ksName=" + this.ksName + ", returning null"));
                return null;
            }
            Metadata metadata = cluster.getMetadata();
            if (metadata == null) {
                SessionDAO.this.log.warn((Object)("execute: metadata is null, ksName=" + this.ksName + ", returning null"));
                return null;
            }
            KeyspaceMetadata ksMd = metadata.getKeyspace(this.ksName);
            if (ksMd == null) {
                SessionDAO.this.log.warn((Object)("execute: metadata.getKeyspace() is null, ksName=" + this.ksName + ", returning null"));
                return null;
            }
            KeyspaceMetaData ksMD = new KeyspaceMetaData(ksMd);
            return ksMD;
        }

        @Override
        public void newSession(Session session) {
        }
    }

    public class ExecuteQueryMethod
    implements SessionMethod {
        private final String query;

        public ExecuteQueryMethod(String query) {
            this.query = query;
        }

        @Override
        public Object execute(Session session) {
            return session.execute(this.query);
        }

        public String toString() {
            return "QueryCommand[" + cleanQuery.purge(this.query) + "]";
        }

        @Override
        public void newSession(Session session) {
        }
    }

    public class ExecuteStatementMethod
    implements SessionMethod {
        private final UserStoreStatementBuilder statement;

        public ExecuteStatementMethod(UserStoreStatementBuilder statement) {
            this.statement = statement;
        }

        @Override
        public Object execute(Session session) throws DMException {
            return session.execute(this.statement.getStatement());
        }

        public String toString() {
            return "StatementCommand[" + this.statement + "]";
        }

        @Override
        public void newSession(Session session) {
            this.statement.newSession();
        }
    }

    public class PrepareMethod
    implements SessionMethod {
        private final String query;

        public PrepareMethod(String query) {
            this.query = query;
        }

        @Override
        public Object execute(Session session) {
            return session.prepare(this.query);
        }

        public String toString() {
            return "PrepareCommand[" + cleanQuery.purge(this.query) + "]";
        }

        @Override
        public void newSession(Session session) {
        }
    }

    public static interface SessionMethod {
        public Object execute(Session var1) throws DMException;

        public void newSession(Session var1);
    }

    private class ExceptionCounters {
        private int driverExceptionCount = 0;
        private int stalePreparedStatementCount = 0;

        public int getDriverExceptionCount() {
            return this.driverExceptionCount;
        }

        public void incrDriverExceptionCount() {
            ++this.driverExceptionCount;
        }

        public int getStalePreparedStatementCount() {
            return this.stalePreparedStatementCount;
        }

        public void incrStalePreparedStatement() {
            ++this.stalePreparedStatementCount;
        }

        public String toString() {
            return "ExceptionCounters [driverExceptionCount=" + this.driverExceptionCount + ", stalePreparedStatementCount=" + this.stalePreparedStatementCount + "]";
        }
    }

    protected static class CleanseQuery {
        protected static final Object BLANK_PHRASE = "*****";
        private final Logger log = AsmLogger.getLogger(CleanseQuery.class);
        final String createUser = "\\s*CREATE\\s+USER";
        final String alterUser = "\\s*ALTER\\s+USER";
        final String userCmd = "\\s+([^\\s]*)\\s+WITH\\s+PASSWORD\\s+'([^']*)'.*";
        final String ifNotExists = "\\s+IF\\s+NOT\\s+EXISTS";
        private String queryPattern = "\\s*ALTER\\s+USER\\s+([^\\s]*)\\s+WITH\\s+PASSWORD\\s+'([^']*)'.*|\\s*CREATE\\s+USER\\s+([^\\s]*)\\s+WITH\\s+PASSWORD\\s+'([^']*)'.*|\\s*CREATE\\s+USER\\s+IF\\s+NOT\\s+EXISTS\\s+([^\\s]*)\\s+WITH\\s+PASSWORD\\s+'([^']*)'.*";
        private Pattern pattern = Pattern.compile(this.queryPattern, 2);

        protected CleanseQuery() {
        }

        String purge(String query) {
            Matcher matcher = this.pattern.matcher(query);
            if (!matcher.matches()) {
                return query;
            }
            StringBuilder sb = new StringBuilder();
            int start = 0;
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                if (matcher.group(i) == null) continue;
                sb.append(query.substring(start, matcher.start(i)));
                sb.append(BLANK_PHRASE);
                start = matcher.end(i);
            }
            sb.append(query.substring(start));
            return sb.toString();
        }
    }
}

