/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import java.io.Serializable;

public class DataDistLayerMemberAddr
implements Serializable,
Comparable<DataDistLayerMemberAddr> {
    private static final long serialVersionUID = 7925983559328203702L;
    private String clusterName;
    private Object hostId;
    private String memberType;
    private Double memberVersion;
    private String memberIpAddr;
    private boolean isMutable = true;

    public DataDistLayerMemberAddr() {
        this.clusterName = null;
        this.hostId = null;
        this.memberType = null;
        this.memberVersion = null;
        this.memberIpAddr = null;
        this.isMutable = true;
    }

    public DataDistLayerMemberAddr(DataDistLayerMemberAddr other) {
        this.clusterName = other.clusterName;
        this.hostId = other.hostId;
        this.memberType = other.memberType;
        this.memberVersion = other.memberVersion;
        this.memberIpAddr = other.memberIpAddr;
        this.isMutable = other.isMutable;
    }

    public DataDistLayerMemberAddr(String clusterName, Object hostId) {
        this.clusterName = clusterName;
        this.hostId = hostId;
        this.memberType = null;
        this.memberVersion = null;
        this.memberIpAddr = null;
        this.isMutable = true;
    }

    public DataDistLayerMemberAddr(String clusterName, Object hostId, String memberIpAddr) {
        this.clusterName = clusterName;
        this.hostId = hostId;
        this.memberType = null;
        this.memberVersion = null;
        this.memberIpAddr = memberIpAddr;
        this.isMutable = true;
    }

    public DataDistLayerMemberAddr(String clusterName, Object hostId, String memberIpAddr, Double version) {
        this.clusterName = clusterName;
        this.hostId = hostId;
        this.memberType = null;
        this.memberVersion = version;
        this.memberIpAddr = memberIpAddr;
        this.isMutable = true;
    }

    @Override
    public int compareTo(DataDistLayerMemberAddr o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof DataDistLayerMemberAddr)) {
            return false;
        }
        return (this.clusterName == null ? ((DataDistLayerMemberAddr)obj).getClusterName() == null : this.clusterName.equals(((DataDistLayerMemberAddr)obj).getClusterName())) && (this.hostId == null ? ((DataDistLayerMemberAddr)obj).getHostId() == null : this.hostId.equals(((DataDistLayerMemberAddr)obj).getHostId()));
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getMemberType() {
        return this.memberType;
    }

    public Double getMemberVersion() {
        return this.memberVersion;
    }

    public void setMemberType(String memberType) {
        this.memberType = memberType;
    }

    public void setMemberIpAddr(String memberIpAddr) {
        if (!this.isMutable) {
            throw new IllegalStateException("Object is not mutable.");
        }
        this.memberIpAddr = memberIpAddr;
    }

    public Object getHostId() {
        return this.hostId;
    }

    public String getIpAddress() {
        if (this.hostId == null) {
            return null;
        }
        if (this.memberIpAddr != null) {
            return this.memberIpAddr;
        }
        String host = this.hostId.toString();
        try {
            return host.substring(0, host.indexOf(58));
        }
        catch (Exception e) {
            return null;
        }
    }

    public int hashCode() {
        return ((this.clusterName == null ? "" : this.clusterName) + (this.hostId == null ? "" : this.hostId.toString())).hashCode();
    }

    public void setClusterName(String clusterName) {
        if (!this.isMutable) {
            throw new IllegalStateException("Object is not mutable.");
        }
        this.clusterName = clusterName;
    }

    public void setHostId(Object hostId) {
        if (!this.isMutable) {
            throw new IllegalStateException("Object is not mutable.");
        }
        this.hostId = hostId;
    }

    public void setMemberVersion(Double memberVersion) {
        this.memberVersion = memberVersion;
    }

    public void setIsMutable(boolean isMutable) {
        this.isMutable = isMutable;
    }

    public String toString() {
        return "DataDistLayerMemberAddr[memberType='" + this.memberType + "', clusterName='" + this.clusterName + "', hostId='" + this.hostId + "', IP='" + this.memberIpAddr + "', memberVersion='" + this.memberVersion + "', isMutable=" + this.isMutable + "]";
    }
}

