/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.ustore.CassandraSSLOptions;

public class CassandraConnectionInfo {
    protected String host;
    protected int port;
    protected int jmxPort;
    protected RateLimitingParms rateLimitingParms = new RateLimitingParms();
    protected CassandraSSLOptions sslOptions;
    protected ConstantQueryLogger constQueryLogger = new ConstantQueryLogger();

    public CassandraConnectionInfo(String host, int port, int jmxPort, CassandraSSLOptions sslOptions) {
        this.host = host;
        this.port = port;
        this.jmxPort = jmxPort;
        this.sslOptions = sslOptions;
    }

    public CassandraConnectionInfo(String host, int port, int jmxPort, CassandraSSLOptions sslOptions, RateLimitingParms rlp) {
        this.host = host;
        this.port = port;
        this.jmxPort = jmxPort;
        this.sslOptions = sslOptions;
        this.rateLimitingParms = rlp;
    }

    @Deprecated
    public CassandraConnectionInfo(String host, int port, int jmxPort, boolean isConnectionEncrypted) {
        this.host = host;
        this.port = port;
        this.jmxPort = jmxPort;
        if (isConnectionEncrypted) {
            throw new IllegalArgumentException("isConnectionEncrypted is true but TLS is not supported. Use constructor with SSLOptions argument for TLS support.");
        }
        this.sslOptions = null;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getJmxPort() {
        return this.jmxPort;
    }

    public CassandraSSLOptions getSslOptions() {
        return this.sslOptions;
    }

    public ConstantQueryLogger getConstQueryLogger() {
        return this.constQueryLogger;
    }

    public void setConstQueryLogger(ConstantQueryLogger constQueryLogger) {
        this.constQueryLogger = constQueryLogger;
    }

    public RateLimitingParms getRateLimitingParms() {
        return this.rateLimitingParms;
    }

    public void setRateLimitingParms(RateLimitingParms rateLimitingParms) {
        this.rateLimitingParms = rateLimitingParms;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.jmxPort;
        result = 31 * result + this.port;
        result = 31 * result + (this.sslOptions == null ? 0 : this.sslOptions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraConnectionInfo other = (CassandraConnectionInfo)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.jmxPort != other.jmxPort) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.sslOptions == null ? other.sslOptions != null : !this.sslOptions.equals(other.sslOptions));
    }

    public String toString() {
        return "CassandraConnectionInfo [host=" + this.host + ", port=" + this.port + ", jmxPort=" + this.jmxPort + ", sslOptions=" + this.sslOptions + "]";
    }

    public class RateLimitingParms {
        private Integer maxRequests = 0;
        private Integer maxQueryWaitTimeoutMs = 0;

        public Integer getMaxRequests() {
            return this.maxRequests;
        }

        public Integer getMaxQueryWaitTimeoutMs() {
            return this.maxQueryWaitTimeoutMs;
        }

        public void setMaxRequests(Integer maxRequests) {
            this.maxRequests = maxRequests;
        }

        public void setMaxQueryWaitTimeoutMs(Integer maxQueryWaitTimeoutMs) {
            this.maxQueryWaitTimeoutMs = maxQueryWaitTimeoutMs;
        }

        public String toString() {
            return "CassandraRateLimiting [maxRequests=" + this.maxRequests + ", maxQueryWaitTimeoutMs=" + this.maxQueryWaitTimeoutMs + "]";
        }
    }

    public class ConstantQueryLogger {
        private Long slowQueryThresholdMS;
        private Integer maxLoggedParams;
        private Integer maxParamsValueLength;
        private Integer maxQueryStringLength;

        public Long getSlowQueryThresholdMS() {
            return this.slowQueryThresholdMS;
        }

        public void setSlowQueryThresholdMS(Long slowQueryThresholdMS) {
            this.slowQueryThresholdMS = slowQueryThresholdMS;
        }

        public Integer getMaxLoggedParams() {
            return this.maxLoggedParams;
        }

        public void setMaxLoggedParams(Integer maxLoggedParams) {
            this.maxLoggedParams = maxLoggedParams;
        }

        public Integer getMaxParamsValueLength() {
            return this.maxParamsValueLength;
        }

        public void setMaxParamsValueLength(Integer maxParamsValueLength) {
            this.maxParamsValueLength = maxParamsValueLength;
        }

        public Integer getMaxQueryStringLength() {
            return this.maxQueryStringLength;
        }

        public void setMaxQueryStringLength(Integer maxQueryStringLength) {
            this.maxQueryStringLength = maxQueryStringLength;
        }

        public String toString() {
            return "ConstantQueryLogger [slowQueryThresholdMS=" + this.slowQueryThresholdMS + ", maxLoggedParams=" + this.maxLoggedParams + ", maxParamsValueLength=" + this.maxParamsValueLength + ", maxQueryStringLength=" + this.maxQueryStringLength + "]";
        }
    }
}

