/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;

public class UriFormatter {
    String user;
    String scheme;
    String domain;
    String port;
    String parameters;
    private static final Logger log = AsmLogger.getLogger(UriFormatter.class);

    public UriFormatter() {
        this.init();
    }

    public UriFormatter(String uri) {
        this.parseURI(uri);
    }

    public UriFormatter(String scheme, String user, String domain, String port) {
        this.setFields(scheme, user, domain, port);
    }

    public void setUri(String uri) {
        this.parseURI(uri);
    }

    public void setFields(String scheme, String user, String domain, String port) {
        this.init();
        this.scheme = scheme;
        this.user = user;
        this.domain = domain;
        this.port = port;
    }

    public String getUri() {
        String uri = "";
        if (this.scheme != null) {
            uri = this.scheme + ":";
        }
        if (this.user != null) {
            uri = uri + this.user;
        }
        if (this.domain != null) {
            if (this.user != null) {
                uri = uri + "@";
            }
            uri = uri + this.domain;
        }
        if (this.port != null) {
            uri = uri + ":" + this.port;
        }
        if (this.parameters != null) {
            uri = uri + ";" + this.parameters;
        }
        return uri;
    }

    void init() {
        this.user = null;
        this.scheme = null;
        this.domain = null;
        this.port = null;
        this.parameters = null;
    }

    void parseURI(String uri) {
        int i;
        String fcn_name = "parseURI";
        boolean isFiner = log.isFinerEnabled();
        this.init();
        if (uri == null || uri.isEmpty()) {
            return;
        }
        uri = uri.trim();
        int curPos = 0;
        String[] schemes = this.getSchemes();
        if (schemes != null) {
            for (String lscheme : schemes) {
                if (!uri.startsWith(lscheme + ":")) continue;
                this.scheme = lscheme;
                curPos = lscheme.length() + 1;
                break;
            }
        } else {
            for (int i2 = 0; i2 < uri.length(); ++i2) {
                char ch = uri.charAt(i2);
                if (ch == ':') {
                    if (i2 > 0) {
                        this.scheme = uri.substring(0, i2);
                        curPos = i2 + 1;
                    } else {
                        this.scheme = "";
                    }
                } else {
                    if (Character.isLetter(ch)) continue;
                    this.scheme = null;
                }
                break;
            }
        }
        if ((i = uri.indexOf(64, curPos)) >= 0) {
            this.user = uri.substring(curPos, i);
            curPos = i + 1;
        }
        Token nextToken = Token.DOMAIN;
        for (i = curPos; i < uri.length(); ++i) {
            char ch = uri.charAt(i);
            if (ch == ':') {
                this.domain = uri.substring(curPos, i);
                nextToken = Token.PORT;
                curPos = i + 1;
                continue;
            }
            if (ch != ';' || nextToken == Token.ARGS) continue;
            if (nextToken == Token.PORT) {
                this.port = uri.substring(curPos, i);
            } else if (nextToken == Token.DOMAIN) {
                this.domain = uri.substring(curPos, i);
            }
            nextToken = Token.ARGS;
            curPos = i + 1;
        }
        if (nextToken == Token.DOMAIN) {
            this.domain = uri.substring(curPos);
        } else if (nextToken == Token.PORT) {
            this.port = uri.substring(curPos);
        } else if (nextToken == Token.ARGS) {
            this.parameters = uri.substring(curPos);
        }
        if (isFiner) {
            log.finer((Object)("parseURI: leave, " + this));
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    protected String[] getSchemes() {
        return null;
    }

    public String toString() {
        return "UriFormatter [domain=" + this.domain + ", parameters=" + this.parameters + ", port=" + this.port + ", scheme=" + this.scheme + ", user=" + this.user + "]";
    }

    static enum Token {
        USER,
        DOMAIN,
        PORT,
        ARGS;

    }
}

