/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.IPv4Address;
import com.avaya.asm.datamgr.objectapi.IPv6Address;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;

public abstract class IPAddress
implements Serializable {
    private static final long serialVersionUID = -8672173137046392230L;
    protected char[] groups;
    protected String zoneId;
    private static Logger log = AsmLogger.getLogger(IPAddress.class);

    public static IPAddress parseIPAddr(String address) throws ParseException {
        if (IPAddress.getAddressFamily(address) == IPAddressFamily.IPV6) {
            return new IPv6Address(address);
        }
        return new IPv4Address(address);
    }

    public static IPAddress fromString(String address) {
        if (address == null) {
            return null;
        }
        try {
            return IPAddress.parseIPAddr(address);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static IPAddressFamily getAddressFamily(String address) {
        return address.indexOf(58) >= 0 ? IPAddressFamily.IPV6 : IPAddressFamily.IPV4;
    }

    public static IPAddressFamily getOppositeAddressFamily(IPAddressFamily ipAddrFamily) {
        return ipAddrFamily == IPAddressFamily.IPV4 ? IPAddressFamily.IPV6 : IPAddressFamily.IPV4;
    }

    public static boolean isIPAddress(String address) {
        if (address == null) {
            return false;
        }
        try {
            IPAddress.parseIPAddr(address);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isIPv4Address(String address) {
        try {
            new IPv4Address(address);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isIPv6Address(String address) {
        try {
            new IPv6Address(address);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static int compare(String address1, String address2) throws ParseException {
        if (address1 == null) {
            return address2 == null ? 0 : -1;
        }
        if (address2 == null) {
            return 1;
        }
        if (address1.equalsIgnoreCase(address2)) {
            return 0;
        }
        IPAddress addr1 = IPAddress.parseIPAddr(address1);
        IPAddress addr2 = IPAddress.parseIPAddr(address2);
        return addr1.compareTo(addr2);
    }

    public static boolean areEqual(String address1, String address2) {
        try {
            return IPAddress.compare(address1, address2) == 0;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public boolean isEqualTo(String address) {
        return address != null ? this.equals(IPAddress.fromString(address)) : false;
    }

    public abstract IPAddressFamily getAddressFamily();

    public int compareTo(IPAddress address) {
        if (address == null) {
            return 1;
        }
        if (address == this) {
            return 0;
        }
        if (address.getAddressFamily() != this.getAddressFamily()) {
            return this.getAddressFamily() == IPAddressFamily.IPV6 ? 1 : -1;
        }
        char[] otherGroups = address.getGroups();
        for (int i = 0; i < this.groups.length; ++i) {
            int thisGroup = this.groups[i] & 0xFFFF;
            int otherGroup = otherGroups[i] & 0xFFFF;
            if (thisGroup > otherGroup) {
                return 1;
            }
            if (thisGroup >= otherGroup) continue;
            return -1;
        }
        return 0;
    }

    public abstract IPAddress createMask(int var1) throws Exception;

    public char[] getGroups() {
        return this.groups;
    }

    public static String stripZoneId(String address) {
        int idx = address.indexOf(37);
        if (idx < 0) {
            return address;
        }
        return address.substring(0, idx);
    }

    protected String procZoneId(String address) {
        int idx = address.indexOf(37);
        if (idx < 0) {
            this.zoneId = null;
            return address;
        }
        this.zoneId = address.substring(idx + 1);
        return address.substring(0, idx);
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public static String getLoopbackIP(IPAddressFamily ipAddrFamily) {
        return ipAddrFamily == IPAddressFamily.IPV6 ? "::1" : "127.0.0.1";
    }

    public static IPAddress getLoopbackIPAddr(IPAddressFamily ipAddrFamily) {
        return IPAddress.fromString(IPAddress.getLoopbackIP(ipAddrFamily));
    }

    public static String getSipContainerIP(IPAddressFamily ipAddrFamily) {
        return ipAddrFamily == IPAddressFamily.IPV6 ? "::2" : "127.0.0.2";
    }

    public static IPAddress getSipContainerIPAddr(IPAddressFamily ipAddrFamily) {
        return IPAddress.fromString(IPAddress.getSipContainerIP(ipAddrFamily));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.groups);
        result = 31 * result + (this.zoneId == null ? 0 : this.zoneId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPAddress other = (IPAddress)obj;
        if (!Arrays.equals(this.groups, other.groups)) {
            return false;
        }
        return !(this.zoneId == null ? other.zoneId != null : !this.zoneId.equals(other.zoneId));
    }

    public static String toCannonicalForm(String address) {
        return IPAddress.toCannonicalForm(address, false);
    }

    public static String toCannonicalForm(String address, boolean includeZoneId) {
        IPAddress ipAddress;
        try {
            ipAddress = IPAddress.parseIPAddr(address);
        }
        catch (ParseException e) {
            return address;
        }
        return ipAddress.toCannonicalForm(includeZoneId);
    }

    public static String toExpandedForm(String address) {
        return IPAddress.toExpandedForm(address, false);
    }

    public static String toExpandedForm(String address, boolean includeZoneId) {
        IPAddress ipAddress;
        try {
            ipAddress = IPAddress.parseIPAddr(address);
        }
        catch (ParseException e) {
            return address;
        }
        return ipAddress.toExpandedForm(includeZoneId);
    }

    public String toCannonicalForm() {
        return this.toCannonicalForm(true);
    }

    public String toCannonicalForm(boolean includeZoneId) {
        return this.toString(false, includeZoneId);
    }

    public String toExpandedForm() {
        return this.toExpandedForm(true);
    }

    public String toExpandedForm(boolean includeZoneId) {
        return this.toString(true, includeZoneId);
    }

    public String toString() {
        return this.toString(false, true);
    }

    public String toString(boolean includeZoneId) {
        return this.toString(false, includeZoneId);
    }

    protected abstract String toString(boolean var1, boolean var2);

    public static enum IPAddressFamily {
        IPV4,
        IPV6;

    }
}

