/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReconstructableCall
implements Serializable {
    private static final long serialVersionUID = 1635763228259557939L;
    private ReconstructableCallKey key;
    private long startTime;
    private String resourcePriority;
    protected List<ReconstructableBranch> branches;

    public ReconstructableCall(ReconstructableCallKey key, long startTime, String resourcePriority) {
        this.key = key;
        this.startTime = startTime;
        this.resourcePriority = resourcePriority;
        this.branches = new ArrayList<ReconstructableBranch>();
    }

    public String getGSID() {
        return this.key.gsid;
    }

    public Long getAsmInstanceId() {
        return this.key.asmInstanceId;
    }

    public ReconstructableCallKey getKey() {
        return this.key;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public String getResourcePriority() {
        return this.resourcePriority;
    }

    public void setResourcePriority(String resourcePriority) {
        this.resourcePriority = resourcePriority;
    }

    public ReconstructableBranch getBranch(String branchId) {
        if (branchId != null && this.branches != null) {
            for (ReconstructableBranch branch : this.branches) {
                if (!branchId.equals(branch.getBranchId())) continue;
                return branch;
            }
        }
        return null;
    }

    public ReconstructableBranch getBranchByCallId(String callId) {
        if (callId != null && this.branches != null) {
            for (ReconstructableBranch branch : this.branches) {
                if (!branch.containsCallId(callId)) continue;
                return branch;
            }
        }
        return null;
    }

    public List<ReconstructableBranch> getBranches() {
        return this.branches;
    }

    public void setBranches(List<ReconstructableBranch> branches) {
        this.branches = branches;
    }

    public void addBranch(ReconstructableBranch branch) {
        this.branches.add(branch);
    }

    public boolean isEmpty() {
        return this.branches == null || this.branches.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.branches == null ? 0 : this.branches.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.resourcePriority == null ? 0 : this.resourcePriority.hashCode());
        result = 31 * result + (int)(this.startTime ^ this.startTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReconstructableCall other = (ReconstructableCall)obj;
        if (this.branches == null ? other.branches != null : !this.branches.equals(other.branches)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.resourcePriority == null ? other.resourcePriority != null : !this.resourcePriority.equals(other.resourcePriority)) {
            return false;
        }
        return this.startTime == other.startTime;
    }

    public String toString() {
        return "ReconstructableCall[key=" + this.key + ", startTime=" + this.startTime + ", resourcePriority=" + this.resourcePriority + ", branches=" + this.branches + "]";
    }

    public static class ReconstructableBranch
    implements Serializable {
        private static final long serialVersionUID = -427525995211051505L;
        protected String branchId;
        protected List<ReconstructableSession> sessions;

        public ReconstructableBranch(String branchId) {
            this.branchId = branchId;
            this.sessions = new ArrayList<ReconstructableSession>();
        }

        public String getBranchId() {
            return this.branchId;
        }

        public void setBranchId(String branchId) {
            this.branchId = branchId;
        }

        public List<ReconstructableSession> getSessions() {
            return this.sessions;
        }

        public void setSessions(List<ReconstructableSession> sessions) {
            this.sessions = sessions;
        }

        public void addSession(ReconstructableSession session) {
            this.sessions.add(session);
        }

        public boolean isEmpty() {
            return this.sessions == null || this.sessions.isEmpty();
        }

        public boolean containsCallId(String callId) {
            if (callId != null && this.sessions != null) {
                for (ReconstructableSession session : this.sessions) {
                    if (!callId.equals(session.getCallId())) continue;
                    return true;
                }
            }
            return false;
        }

        public Long getCommProfileSetIdCaller() {
            ReconstructableSession.ReconstructableUAInfo callerUAInfo = this.getCallerUAInfo();
            return callerUAInfo != null ? callerUAInfo.getCommProfileSetId() : null;
        }

        public ReconstructableSession.ReconstructableUAInfo getCallerUAInfo() {
            if (!this.sessions.isEmpty()) {
                ReconstructableSession sess = this.sessions.get(0);
                return sess.isB2BUA() ? sess.getCalleeInfo() : sess.getCallerInfo();
            }
            return null;
        }

        public Long getCommProfileSetIdCallee() {
            ReconstructableSession.ReconstructableUAInfo calleeUAInfo = this.getCalleeUAInfo();
            return calleeUAInfo != null ? calleeUAInfo.getCommProfileSetId() : null;
        }

        public ReconstructableSession.ReconstructableUAInfo getCalleeUAInfo() {
            int size = this.sessions.size();
            if (size > 0) {
                ReconstructableSession sess = this.sessions.get(size - 1);
                return sess.getCalleeInfo();
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.branchId == null ? 0 : this.branchId.hashCode());
            result = 31 * result + (this.sessions == null ? 0 : this.sessions.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReconstructableBranch other = (ReconstructableBranch)obj;
            if (this.branchId == null ? other.branchId != null : !this.branchId.equals(other.branchId)) {
                return false;
            }
            return !(this.sessions == null ? other.sessions != null : !this.sessions.equals(other.sessions));
        }

        public String toString() {
            return "ReconstructableBranch[branchId=" + this.branchId + ", sessions=" + this.sessions + "]";
        }

        public static class ReconstructableSession
        implements Serializable {
            private static final long serialVersionUID = 3526204844575262548L;
            protected String callId;
            protected ReconstructableUAInfo callerInfo;
            protected ReconstructableUAInfo calleeInfo;
            protected boolean isB2BUA;
            protected boolean isFGDNPreserved;

            public ReconstructableSession(String callId, ReconstructableUAInfo callerInfo, ReconstructableUAInfo calleeInfo, boolean isB2BUA, boolean isFGDNPreserved) {
                this.callId = callId;
                this.callerInfo = callerInfo;
                this.calleeInfo = calleeInfo;
                this.isB2BUA = isB2BUA;
                this.isFGDNPreserved = isFGDNPreserved;
            }

            public String getCallId() {
                return this.callId;
            }

            public ReconstructableUAInfo getCallerInfo() {
                return this.callerInfo;
            }

            public ReconstructableUAInfo getCalleeInfo() {
                return this.calleeInfo;
            }

            public boolean isB2BUA() {
                return this.isB2BUA;
            }

            public void setB2BUA(boolean isB2BUA) {
                this.isB2BUA = isB2BUA;
            }

            public boolean isFGDNPreserved() {
                return this.isFGDNPreserved;
            }

            public void setFGDNPreserved(boolean isFGDNPreserved) {
                this.isFGDNPreserved = isFGDNPreserved;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.callId == null ? 0 : this.callId.hashCode());
                result = 31 * result + (this.calleeInfo == null ? 0 : this.calleeInfo.hashCode());
                result = 31 * result + (this.callerInfo == null ? 0 : this.callerInfo.hashCode());
                result = 31 * result + (this.isB2BUA ? 1231 : 1237);
                result = 31 * result + (this.isFGDNPreserved ? 1231 : 1237);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                ReconstructableSession other = (ReconstructableSession)obj;
                if (this.callId == null ? other.callId != null : !this.callId.equals(other.callId)) {
                    return false;
                }
                if (this.calleeInfo == null ? other.calleeInfo != null : !this.calleeInfo.equals(other.calleeInfo)) {
                    return false;
                }
                if (this.callerInfo == null ? other.callerInfo != null : !this.callerInfo.equals(other.callerInfo)) {
                    return false;
                }
                if (this.isB2BUA != other.isB2BUA) {
                    return false;
                }
                return this.isFGDNPreserved == other.isFGDNPreserved;
            }

            public String toString() {
                return "ReconstructableSession[callId=" + this.callId + ", callerInfo=" + this.callerInfo + ", calleeInfo=" + this.calleeInfo + ", isB2BUA=" + this.isB2BUA + ", isFGDNPreserved=" + this.isFGDNPreserved + "]";
            }

            public static class ReconstructableUAInfo
            implements Serializable {
                private static final long serialVersionUID = -4717077885780756479L;
                protected String aor;
                protected String adaptedAor;
                protected String contact;
                protected String epvHdr;
                protected String paiHdr;
                protected String displayName;
                protected String adaptedDisplayName;
                protected String tag;
                protected long entityId;
                protected long sendingEntityId;
                protected long commProfileSetId;
                protected String instanceId;
                protected byte[] sdp;
                protected String routingPhase;
                protected String seqType;
                protected String supportedHdrs;
                protected long allowHdrs;
                protected String requireHdrs;
                protected int cmLineId;
                protected byte b2buaType;
                protected boolean isSupportReplaces;
                protected boolean isSupportTandem;
                protected boolean isAvayaEndpoint;
                protected boolean isSeqApp;
                protected boolean isRecordRouteApp;
                protected boolean isOrigCaller;
                private static Map<String, Long> methodMap = new HashMap<String, Long>();
                private static Map<Long, String> reverseMethodMap = new HashMap<Long, String>();

                public ReconstructableUAInfo(String aor, String adaptedAor, String contact, String epvHdr, String paiHdr, String displayName, String adaptedDisplayName, String tag, Long entityId, Long sendingEntityId, Long commProfileSetId, String instanceId, String sdp, String routingPhase, String seqType, List<String> supportedHdrs, List<String> allowHdrs, List<String> requireHdrs, int cmLineId, B2BUAType b2buaType, boolean isSupportReplaces, boolean isSupportTandem, boolean isAvayaEndpoint, boolean isSeqApp, boolean isRecordRouteApp, boolean isOrigCaller) {
                    this.aor = aor;
                    this.adaptedAor = adaptedAor;
                    this.contact = contact;
                    this.epvHdr = epvHdr;
                    this.paiHdr = paiHdr;
                    this.displayName = displayName;
                    this.adaptedDisplayName = adaptedDisplayName;
                    this.tag = tag;
                    this.entityId = ReconstructableUAInfo.Long2long(entityId);
                    this.sendingEntityId = ReconstructableUAInfo.Long2long(sendingEntityId);
                    this.commProfileSetId = ReconstructableUAInfo.Long2long(commProfileSetId);
                    this.instanceId = instanceId;
                    this.sdp = this.string2bytes(sdp);
                    this.routingPhase = routingPhase;
                    this.seqType = seqType;
                    this.supportedHdrs = ReconstructableUAInfo.stringList2CommaString(supportedHdrs);
                    this.allowHdrs = ReconstructableUAInfo.methodList2long(allowHdrs);
                    this.requireHdrs = ReconstructableUAInfo.stringList2CommaString(requireHdrs);
                    this.cmLineId = cmLineId;
                    this.b2buaType = (byte)b2buaType.ordinal();
                    this.isSupportReplaces = isSupportReplaces;
                    this.isSupportTandem = isSupportTandem;
                    this.isAvayaEndpoint = isAvayaEndpoint;
                    this.isSeqApp = isSeqApp;
                    this.isRecordRouteApp = isRecordRouteApp;
                    this.isOrigCaller = isOrigCaller;
                }

                private static long Long2long(Long value) {
                    return value == null ? 0L : value;
                }

                private static Long long2Long(long value) {
                    return value == 0L ? null : new Long(value);
                }

                private static String stringList2CommaString(List<String> l) {
                    if (l == null || l.isEmpty()) {
                        return null;
                    }
                    StringBuilder buf = new StringBuilder();
                    for (String s : l) {
                        buf.append(',');
                        buf.append(s);
                    }
                    return buf.substring(1);
                }

                private static List<String> commaString2StringList(String s) {
                    ArrayList<String> l = new ArrayList<String>();
                    if (s == null || s.isEmpty()) {
                        return l;
                    }
                    for (String ss : s.split(",")) {
                        l.add(ss.trim());
                    }
                    return l;
                }

                private byte[] string2bytes(String s) {
                    try {
                        return s == null ? null : s.getBytes("UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                }

                private String bytes2String(byte[] bytes) {
                    try {
                        return bytes == null ? null : new String(bytes, "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return null;
                    }
                }

                private static long methodList2long(List<String> methods) {
                    long m = 0L;
                    if (methods != null) {
                        for (String method : methods) {
                            Long mask = methodMap.get(method);
                            if (mask == null) continue;
                            m |= mask.longValue();
                        }
                    }
                    return m;
                }

                private static List<String> long2methodList(long m) {
                    ArrayList<String> methods = new ArrayList<String>();
                    if (m != 0L) {
                        int size = methodMap.size();
                        long mask = 1L;
                        for (int i = 0; i < size; ++i) {
                            if ((m & mask) != 0L) {
                                methods.add(reverseMethodMap.get(mask));
                            }
                            mask <<= 1;
                        }
                    }
                    return methods;
                }

                public String getAor() {
                    return this.aor;
                }

                public void setAor(String aor) {
                    this.aor = aor;
                }

                public String getAdaptedAor() {
                    return this.adaptedAor;
                }

                public void setAdaptedAor(String adaptedAor) {
                    this.adaptedAor = adaptedAor;
                }

                public String getContact() {
                    return this.contact;
                }

                public void setContact(String contact) {
                    this.contact = contact;
                }

                public String getEPVHdr() {
                    return this.epvHdr;
                }

                public void setEPVHdr(String epvHdr) {
                    this.epvHdr = epvHdr;
                }

                public void setPAIHdr(String paiHdr) {
                    this.paiHdr = paiHdr;
                }

                public String getPAIHdr() {
                    return this.paiHdr;
                }

                public String getDisplayName() {
                    return this.displayName;
                }

                public void setDisplayName(String displayName) {
                    this.displayName = displayName;
                }

                public String getAdaptedDisplayName() {
                    return this.adaptedDisplayName;
                }

                public void setAdaptedDisplayName(String adaptedDisplayName) {
                    this.adaptedDisplayName = adaptedDisplayName;
                }

                public String getTag() {
                    return this.tag;
                }

                public void setTag(String tag) {
                    this.tag = tag;
                }

                public Long getEntityId() {
                    return ReconstructableUAInfo.long2Long(this.entityId);
                }

                public void setEntityId(Long entityId) {
                    this.entityId = ReconstructableUAInfo.Long2long(entityId);
                }

                public Long getSendingEntityId() {
                    return ReconstructableUAInfo.long2Long(this.sendingEntityId);
                }

                public void setSendingEntityId(Long sendingEntityId) {
                    this.sendingEntityId = ReconstructableUAInfo.Long2long(sendingEntityId);
                }

                public Long getCommProfileSetId() {
                    return ReconstructableUAInfo.long2Long(this.commProfileSetId);
                }

                public void setCommProfileSetId(Long commProfileSetId) {
                    this.commProfileSetId = ReconstructableUAInfo.Long2long(commProfileSetId);
                }

                public String getInstanceId() {
                    return this.instanceId;
                }

                public void setInstanceId(String instanceId) {
                    this.instanceId = instanceId;
                }

                public String getSdp() {
                    return this.bytes2String(this.sdp);
                }

                public void setSdp(String sdp) {
                    this.sdp = this.string2bytes(sdp);
                }

                public String getRoutingPhase() {
                    return this.routingPhase;
                }

                public void setRoutingPhase(String routingPhase) {
                    this.routingPhase = routingPhase;
                }

                public String getSeqType() {
                    return this.seqType;
                }

                public void setSeqType(String seqType) {
                    this.seqType = seqType;
                }

                public List<String> getSupportedHdrs() {
                    return ReconstructableUAInfo.commaString2StringList(this.supportedHdrs);
                }

                public void setSupportedHdrs(List<String> supportedHdrs) {
                    this.supportedHdrs = ReconstructableUAInfo.stringList2CommaString(supportedHdrs);
                }

                public List<String> getAllowHdrs() {
                    return ReconstructableUAInfo.long2methodList(this.allowHdrs);
                }

                public void setAllowHdrs(List<String> allowHdrs) {
                    this.allowHdrs = ReconstructableUAInfo.methodList2long(allowHdrs);
                }

                public List<String> getRequireHdrs() {
                    return ReconstructableUAInfo.commaString2StringList(this.requireHdrs);
                }

                public void setRequireHdrs(List<String> requireHdrs) {
                    this.requireHdrs = ReconstructableUAInfo.stringList2CommaString(requireHdrs);
                }

                public int getCMLineId() {
                    return this.cmLineId;
                }

                public void setCMLineId(int cmLineId) {
                    this.cmLineId = cmLineId;
                }

                public B2BUAType getB2buaType() {
                    switch (this.b2buaType) {
                        default: {
                            return B2BUAType.NON_B2BUA;
                        }
                        case 1: {
                            return B2BUAType.B2BUA_SM;
                        }
                        case 2: {
                            return B2BUAType.B2BUA_CALLER;
                        }
                        case 3: 
                    }
                    return B2BUAType.B2BUA_CALLEE;
                }

                public void setB2buaType(B2BUAType b2buaType) {
                    this.b2buaType = (byte)b2buaType.ordinal();
                }

                public boolean isSupportReplaces() {
                    return this.isSupportReplaces;
                }

                public boolean isSupportTandem() {
                    return this.isSupportTandem;
                }

                public boolean isAvayaEndpoint() {
                    return this.isAvayaEndpoint;
                }

                public boolean isSeqApp() {
                    return this.isSeqApp;
                }

                public boolean isRecordRouteApp() {
                    return this.isRecordRouteApp;
                }

                public boolean isOrigCaller() {
                    return this.isOrigCaller;
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.adaptedAor == null ? 0 : this.adaptedAor.hashCode());
                    result = 31 * result + (this.adaptedDisplayName == null ? 0 : this.adaptedDisplayName.hashCode());
                    result = 31 * result + (int)(this.allowHdrs ^ this.allowHdrs >>> 32);
                    result = 31 * result + (this.aor == null ? 0 : this.aor.hashCode());
                    result = 31 * result + this.b2buaType;
                    result = 31 * result + this.cmLineId;
                    result = 31 * result + (int)(this.commProfileSetId ^ this.commProfileSetId >>> 32);
                    result = 31 * result + (this.contact == null ? 0 : this.contact.hashCode());
                    result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
                    result = 31 * result + (int)(this.entityId ^ this.entityId >>> 32);
                    result = 31 * result + (this.epvHdr == null ? 0 : this.epvHdr.hashCode());
                    result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
                    result = 31 * result + (this.isAvayaEndpoint ? 1231 : 1237);
                    result = 31 * result + (this.isOrigCaller ? 1231 : 1237);
                    result = 31 * result + (this.isRecordRouteApp ? 1231 : 1237);
                    result = 31 * result + (this.isSeqApp ? 1231 : 1237);
                    result = 31 * result + (this.isSupportReplaces ? 1231 : 1237);
                    result = 31 * result + (this.isSupportTandem ? 1231 : 1237);
                    result = 31 * result + (this.paiHdr == null ? 0 : this.paiHdr.hashCode());
                    result = 31 * result + (this.requireHdrs == null ? 0 : this.requireHdrs.hashCode());
                    result = 31 * result + (this.routingPhase == null ? 0 : this.routingPhase.hashCode());
                    result = 31 * result + Arrays.hashCode(this.sdp);
                    result = 31 * result + (int)(this.sendingEntityId ^ this.sendingEntityId >>> 32);
                    result = 31 * result + (this.seqType == null ? 0 : this.seqType.hashCode());
                    result = 31 * result + (this.supportedHdrs == null ? 0 : this.supportedHdrs.hashCode());
                    result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    ReconstructableUAInfo other = (ReconstructableUAInfo)obj;
                    if (this.adaptedAor == null ? other.adaptedAor != null : !this.adaptedAor.equals(other.adaptedAor)) {
                        return false;
                    }
                    if (this.adaptedDisplayName == null ? other.adaptedDisplayName != null : !this.adaptedDisplayName.equals(other.adaptedDisplayName)) {
                        return false;
                    }
                    if (this.allowHdrs != other.allowHdrs) {
                        return false;
                    }
                    if (this.aor == null ? other.aor != null : !this.aor.equals(other.aor)) {
                        return false;
                    }
                    if (this.b2buaType != other.b2buaType) {
                        return false;
                    }
                    if (this.cmLineId != other.cmLineId) {
                        return false;
                    }
                    if (this.commProfileSetId != other.commProfileSetId) {
                        return false;
                    }
                    if (this.contact == null ? other.contact != null : !this.contact.equals(other.contact)) {
                        return false;
                    }
                    if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
                        return false;
                    }
                    if (this.entityId != other.entityId) {
                        return false;
                    }
                    if (this.epvHdr == null ? other.epvHdr != null : !this.epvHdr.equals(other.epvHdr)) {
                        return false;
                    }
                    if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
                        return false;
                    }
                    if (this.isAvayaEndpoint != other.isAvayaEndpoint) {
                        return false;
                    }
                    if (this.isOrigCaller != other.isOrigCaller) {
                        return false;
                    }
                    if (this.isRecordRouteApp != other.isRecordRouteApp) {
                        return false;
                    }
                    if (this.isSeqApp != other.isSeqApp) {
                        return false;
                    }
                    if (this.isSupportReplaces != other.isSupportReplaces) {
                        return false;
                    }
                    if (this.isSupportTandem != other.isSupportTandem) {
                        return false;
                    }
                    if (this.paiHdr == null ? other.paiHdr != null : !this.paiHdr.equals(other.paiHdr)) {
                        return false;
                    }
                    if (this.requireHdrs == null ? other.requireHdrs != null : !this.requireHdrs.equals(other.requireHdrs)) {
                        return false;
                    }
                    if (this.routingPhase == null ? other.routingPhase != null : !this.routingPhase.equals(other.routingPhase)) {
                        return false;
                    }
                    if (!Arrays.equals(this.sdp, other.sdp)) {
                        return false;
                    }
                    if (this.sendingEntityId != other.sendingEntityId) {
                        return false;
                    }
                    if (this.seqType == null ? other.seqType != null : !this.seqType.equals(other.seqType)) {
                        return false;
                    }
                    if (this.supportedHdrs == null ? other.supportedHdrs != null : !this.supportedHdrs.equals(other.supportedHdrs)) {
                        return false;
                    }
                    return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
                }

                public String toString() {
                    return "ReconstructableUAInfo[aor=" + this.aor + ", adaptedAor=" + this.adaptedAor + ", contact=" + this.contact + ", epvHdr=" + this.epvHdr + ", paiHdr=" + this.paiHdr + ", displayName=" + this.displayName + ", adaptedDisplayName=" + this.adaptedDisplayName + ", tag=" + this.tag + ", entityId=" + this.getEntityId() + ", sendingEntityId=" + this.getSendingEntityId() + ", commProfileSetId=" + this.getCommProfileSetId() + ", instanceId=" + this.instanceId + ", sdp=" + this.sdpString(this.bytes2String(this.sdp)) + ", routingPhase=" + this.routingPhase + ", seqType=" + this.seqType + ", supportedHdrs=" + this.getSupportedHdrs() + ", allowHdrs=" + this.getAllowHdrs() + ", requireHdrs=" + this.getRequireHdrs() + ", cmLineId=" + this.cmLineId + ", b2buaType=" + (Object)((Object)this.getB2buaType()) + ", isSupportReplaces=" + this.isSupportReplaces + ", isSupportTandem=" + this.isSupportTandem + ", isAvayaEndpoint=" + this.isAvayaEndpoint + ", isSeqApp=" + this.isSeqApp + ", isRecordRouteApp=" + this.isRecordRouteApp + ", isOrigCaller=" + this.isOrigCaller + "]";
                }

                private String sdpString(String sdp) {
                    if (sdp == null) {
                        return "null";
                    }
                    String[] lines = sdp.split("\r\n");
                    StringBuilder buf = new StringBuilder();
                    buf.append("[SDP:");
                    for (String line : lines) {
                        if (!line.startsWith("m=")) continue;
                        String media = line.substring(2, line.indexOf(32));
                        buf.append(' ');
                        buf.append(media);
                    }
                    buf.append("]");
                    return buf.toString();
                }

                static {
                    methodMap.put("INVITE", 1L);
                    methodMap.put("ACK", 2L);
                    methodMap.put("OPTIONS", 4L);
                    methodMap.put("BYE", 8L);
                    methodMap.put("CANCEL", 16L);
                    methodMap.put("NOTIFY", 32L);
                    methodMap.put("MESSAGE", 64L);
                    methodMap.put("REFER", 128L);
                    methodMap.put("INFO", 256L);
                    methodMap.put("PUBLISH", 512L);
                    methodMap.put("UPDATE", 1024L);
                    methodMap.put("REGISTER", 2048L);
                    methodMap.put("SUBSCRIBE", 4096L);
                    methodMap.put("PRACK", 8192L);
                    for (Map.Entry<String, Long> e : methodMap.entrySet()) {
                        reverseMethodMap.put(e.getValue(), e.getKey());
                    }
                }

                public static enum B2BUAType {
                    NON_B2BUA,
                    B2BUA_SM,
                    B2BUA_CALLER,
                    B2BUA_CALLEE;

                }
            }
        }
    }

    public static class ReconstructableCallKey
    implements Serializable {
        private static final long serialVersionUID = -8691963000787782616L;
        private final String gsid;
        private final Long asmInstanceId;

        public ReconstructableCallKey(String gsid, Long asmInstanceId) {
            this.asmInstanceId = asmInstanceId;
            this.gsid = gsid;
        }

        public static ReconstructableCallKey fromKeyString(String keyString) {
            try {
                String[] parts = keyString.split("#");
                if (parts.length != 2) {
                    return null;
                }
                String gsid = parts[0];
                Long asmInstanceId = Long.parseLong(parts[1]);
                return new ReconstructableCallKey(gsid, asmInstanceId);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public String getKey() {
            return this.gsid + "#" + this.asmInstanceId.toString();
        }

        public String getGSID() {
            return this.gsid;
        }

        public Long getAsmInstanceId() {
            return this.asmInstanceId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.asmInstanceId == null ? 0 : this.asmInstanceId.hashCode());
            result = 31 * result + (this.gsid == null ? 0 : this.gsid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReconstructableCallKey other = (ReconstructableCallKey)obj;
            if (this.asmInstanceId == null ? other.asmInstanceId != null : !this.asmInstanceId.equals(other.asmInstanceId)) {
                return false;
            }
            return !(this.gsid == null ? other.gsid != null : !this.gsid.equals(other.gsid));
        }

        public String toString() {
            return "ReconstructableCallKey[gsid=" + this.gsid + ", asmInstanceId=" + this.asmInstanceId + "]";
        }
    }
}

