/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.TrustMgmtUtil;
import com.avaya.common.logging.client.Logger;
import com.avaya.mgmt.trust.tmclient.service.TMServiceQuery;
import com.avaya.mgmt.trust.tmclient.service.TMServiceQueryFactory;
import com.avaya.ustore.CassandraSSLOptions;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class JBossTrustMgmtUtil
extends TrustMgmtUtil {
    private static Logger log = AsmLogger.getLogger(JBossTrustMgmtUtil.class);
    private static final String MGMT = "mgmt";
    private static final String JBOSS_USER = "jboss";
    private static final String JBOSS_SSHID = "/home/jboss/.ssh/id_rsa";
    private static final String TM_SERVICE_LOCATION = "/opt/Avaya/wildfly-10.1.0.Final/standalone/configuration/tm/";
    private static final String defaultServiceName = System.getProperty("com.avaya.asm.trustmgmt.serviceName", "mgmt");
    private static final String serviceLocation = System.getProperty("avaya.tm.home.dir", "/opt/Avaya/wildfly-10.1.0.Final/standalone/configuration/tm/");
    private TMServiceQueryFactory tmServiceFactory = new TMServiceQueryFactory();
    private static volatile JBossTrustMgmtUtil instance = null;

    private JBossTrustMgmtUtil() {
        String functionName = "JBossTrustMgmtUtil";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (isFinestEnabled) {
            log.finest((Object)"JBossTrustMgmtUtil: instantiated.");
        }
    }

    public static synchronized JBossTrustMgmtUtil getInstance() {
        if (instance == null) {
            instance = new JBossTrustMgmtUtil();
        }
        return instance;
    }

    @Override
    protected byte[] getStoragePassword() {
        return this.getStoragePassword(defaultServiceName, JBOSS_USER, JBOSS_SSHID, TM_SERVICE_LOCATION);
    }

    private byte[] getStoragePassword(String tmServiceName, String tmServiceUser, String sshId, String tmConfLocation) {
        String functionName = "getStoragePassword";
        boolean isFinestEnabled = log.isFinestEnabled();
        byte[] result = null;
        try {
            TMServiceQuery serviceQuery = this.tmServiceFactory.getTMServiceQuery(tmServiceName, tmConfLocation);
            String keyStorePassword = serviceQuery.getKeyStorePassword(tmServiceUser, sshId);
            if (keyStorePassword != null) {
                result = keyStorePassword.getBytes("UTF-8");
            }
        }
        catch (Exception e) {
            log.error((Object)("getStoragePassword: Could not retrieve password." + e));
        }
        if (isFinestEnabled) {
            if (result != null) {
                log.finest((Object)("getStoragePassword: result.length=" + result.length));
            } else {
                log.finest((Object)"getStoragePassword: result=null");
            }
        }
        return result;
    }

    @Override
    protected String getKeyStorePassword() {
        return this.getKeyStorePassword(defaultServiceName);
    }

    protected String getKeyStorePassword(String serviceName) {
        String functionName = "getKeyStorePassword";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String result = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            String defaultAuthUser = query.getDefaultAuthUser();
            String defaultAuthPassKey = query.getDefaultAuthPasskey();
            result = query.getKeyStorePassword(defaultAuthUser, defaultAuthPassKey);
        }
        catch (Exception e) {
            log.error((Object)("getKeyStorePassword: Can't get keyStorePassword. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinestEnabled) {
            if (result != null) {
                log.finest((Object)("getKeyStorePassword: result.length()=" + result.length() + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            } else {
                log.finest((Object)("getKeyStorePassword: result=null serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            }
        }
        return result;
    }

    @Override
    protected String getKeyStorePath() {
        return this.getKeyStorePath(defaultServiceName);
    }

    protected String getKeyStorePath(String serviceName) {
        String functionName = "getKeyStorePath";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String keyStorePath = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            keyStorePath = query.getKeyStorePath();
        }
        catch (Exception e) {
            log.error((Object)("getKeyStorePath: Can't get keyStorePath. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinestEnabled) {
            log.finest((Object)("getKeyStorePath: keystorePath=" + keyStorePath + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return keyStorePath;
    }

    @Override
    protected String getKeyStoreType() {
        return this.getKeyStoreType(defaultServiceName);
    }

    protected String getKeyStoreType(String serviceName) {
        String functionName = "getKeyStoreType";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String keyStoreType = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            keyStoreType = query.getKeyStoreType();
        }
        catch (Exception e) {
            log.error((Object)("getKeyStoreType: Can't get keyStoreType. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinestEnabled) {
            log.finest((Object)("getKeyStoreType: keyStoreType=" + keyStoreType + ", serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return keyStoreType;
    }

    @Override
    protected String getTrustStorePassword() {
        return this.getTrustStorePassword(defaultServiceName);
    }

    protected String getTrustStorePassword(String serviceName) {
        String functionName = "getTrustStorePassword";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String result = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            String defaultAuthUser = query.getDefaultAuthUser();
            String defaultAuthPassKey = query.getDefaultAuthPasskey();
            result = query.getTrustStorePassword(defaultAuthUser, defaultAuthPassKey);
        }
        catch (Exception e) {
            log.error((Object)("getTrustStorePassword: Can't get trustStore Password. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinestEnabled) {
            if (result != null) {
                log.finest((Object)("getTrustStorePassword: result.length()=" + result.length() + ", serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            } else {
                log.finest((Object)("getTrustStorePassword: result=null, serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
            }
        }
        return result;
    }

    @Override
    protected String getTrustStorePath() {
        return this.getTrustStorePath(defaultServiceName);
    }

    protected String getTrustStorePath(String serviceName) {
        String functionName = "getTruststorePath";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String trustStorePath = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            trustStorePath = query.getTrustStorePath();
        }
        catch (Exception e) {
            log.error((Object)("getTruststorePath: Can't get trustStore Path. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinestEnabled) {
            log.finest((Object)("getTruststorePath: trustStorePath=" + trustStorePath + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return trustStorePath;
    }

    @Override
    protected String getTrustStoreType() {
        return this.getTrustStoreType(defaultServiceName);
    }

    protected String getTrustStoreType(String serviceName) {
        String functionName = "getTrustStoreType";
        boolean isFinestEnabled = log.isFinestEnabled();
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        String trustStoreType = null;
        try {
            TMServiceQuery query = this.tmServiceFactory.getTMServiceQuery(serviceName, serviceLocation);
            trustStoreType = query.getTrustStoreType();
        }
        catch (Exception e) {
            log.error((Object)("getTrustStoreType: Can't get trustStoreType. serviceLocation=" + serviceLocation + ", serviceName=" + serviceName), (Throwable)e);
        }
        if (isFinestEnabled) {
            log.finest((Object)("getTrustStoreType: trustStoreType=" + trustStoreType + " serviceLocation=" + serviceLocation + ", serviceName=" + serviceName));
        }
        return trustStoreType;
    }

    @Override
    protected SSLContext getSSLContext() {
        return this.createDefaultRevocationAwareSSLContext(defaultServiceName);
    }

    @Override
    public CassandraSSLOptions getSSLOptions() {
        return this.getSSLOptions(true);
    }

    public SSLContext createDefaultRevocationAwareSSLContext(String serviceName) {
        String functionName = "createDefaultRevocationAwareSSLContext";
        boolean isFinestEnabled = log.isFinestEnabled();
        SSLContext sslContext = this.createRevocationAwareSSLContext(serviceName);
        if (sslContext != null) {
            SSLContext.setDefault(sslContext);
            if (isFinestEnabled) {
                log.finest((Object)("createDefaultRevocationAwareSSLContext: Created Default Revocation Aware SSLContext. serviceName=" + serviceName + ", sslContext=" + sslContext));
            }
        } else {
            log.error((Object)("createDefaultRevocationAwareSSLContext: Error creating Default Revocation Aware SSLContext. serviceName=" + serviceName));
        }
        return sslContext;
    }

    public SSLContext createRevocationAwareSSLContext(String serviceName) {
        String functionName = "createRevocationAwareSSLContext";
        if (serviceName == null) {
            serviceName = defaultServiceName;
        }
        SSLContext sslContext = null;
        try {
            String trustStorePath = this.getTrustStorePath(serviceName);
            String trustStorePassword = this.getTrustStorePassword(serviceName);
            String trustStoreType = this.getTrustStoreType(serviceName);
            String trustManagerFactoryAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
            String trustStoreProvider = null;
            String keyStorePath = this.getKeyStorePath(serviceName);
            String keyStorePassword = this.getKeyStorePassword(serviceName);
            String keyStoreType = this.getKeyStoreType(serviceName);
            String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            String keyStoreProvider = null;
            String minimumTlsVersion = "TLSv1.2";
            String contextProvider = null;
            sslContext = this.createRevocationAwareSSLContext(trustStorePath, trustStoreType, trustStorePassword, trustManagerFactoryAlgorithm, trustStoreProvider, keyStorePath, keyStoreType, keyStorePassword, keyManagerFactoryAlgorithm, keyStoreProvider, "TLSv1.2", contextProvider);
        }
        catch (Exception e) {
            log.error((Object)("createRevocationAwareSSLContext: Error creating Revocation Aware SSLContext. serviceName=" + serviceName), (Throwable)e);
        }
        return sslContext;
    }

    @Override
    protected SecureRandom getSecureRandom() throws NoSuchAlgorithmException {
        return SecureRandom.getInstance("DEFAULT");
    }
}

