/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.nio.file.FileSystems;

public class RevocationInfoUtilities {
    private static final Logger log = AsmLogger.getLogger(RevocationInfoUtilities.class);
    private static final String defaultCrlFolder = "/opt/Avaya/wildfly-10.1.0.Final/standalone/configuration/tm/revocation/crl";
    private static final String defaultRevocationPropertiesFile = "/opt/Avaya/wildfly-10.1.0.Final/standalone/configuration/tm/revocation/revocation.properties";
    private static final String crlFolderProperty = System.getProperty("revocation.properties.crlLocation");
    private static final String revocationPropertiesFile = System.getProperty("revocation.properties.file", "/opt/Avaya/wildfly-10.1.0.Final/standalone/configuration/tm/revocation/revocation.properties");
    private static RevocationInfoUtilities instance = null;

    private RevocationInfoUtilities() {
        String functionName = "RevocationInfoUtilities";
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)"RevocationInfoUtilities: Creating new instance.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RevocationInfoUtilities getInstance() {
        if (instance != null) return instance;
        Class<RevocationInfoUtilities> clazz = RevocationInfoUtilities.class;
        synchronized (RevocationInfoUtilities.class) {
            if (instance != null) return instance;
            instance = new RevocationInfoUtilities();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getCrlFolder() {
        File folder;
        String result = defaultCrlFolder;
        if (crlFolderProperty != null && (folder = new File(crlFolderProperty)).exists() && folder.isDirectory()) {
            result = crlFolderProperty;
        }
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        return result;
    }

    public String getRevocationPropertiesFile() {
        return revocationPropertiesFile;
    }

    public boolean isValidCrlFilename(String filename) {
        boolean result = false;
        if (filename != null) {
            result = filename.endsWith(".crl") || filename.endsWith(".pem");
        }
        return result;
    }

    public boolean isRevocationPropertiesFilename(String filename) {
        boolean result = false;
        if (filename != null) {
            String filenameString = FileSystems.getDefault().getPath(filename, new String[0]).getFileName().toString();
            String revFilenameString = FileSystems.getDefault().getPath(revocationPropertiesFile, new String[0]).getFileName().toString();
            result = filenameString.contentEquals(revFilenameString);
        }
        return result;
    }

    public void clearCrlFolder() {
        String functionName = "clearCrlFolder";
        boolean isFinestEnabled = log.isFinestEnabled();
        String crlFolder = this.getCrlFolder();
        if (crlFolder != null) {
            try {
                File folder = new File(crlFolder);
                if (folder.exists() && folder.isDirectory()) {
                    for (File file : folder.listFiles()) {
                        String crlFilename = file.getAbsolutePath();
                        if (!this.isValidCrlFilename(crlFilename)) continue;
                        if (!file.delete()) {
                            log.error((Object)("clearCrlFolder: Cannot delete. crlFilename=" + crlFilename));
                            continue;
                        }
                        if (!isFinestEnabled) continue;
                        log.finest((Object)("clearCrlFolder: Deleted. crlFilename=" + crlFilename));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"clearCrlFolder: Exception clearing CRL Folder: ", (Throwable)e);
            }
        }
    }
}

